/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import org.appwork.utils.Time;

public class ModuleProgress {
    private double value;
    private double stepVolume;
    private double startValue;
    private boolean indeterminated;
    private long starttime;
    private boolean stepVolumeLocked = false;
    private boolean locked = false;
    private double stepValue = 0.0;
    private Object stepID;
    private ModuleProgress[] forwarder;

    public boolean isIndeterminated() {
        return this.indeterminated;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public ModuleProgress() {
        this.reset();
    }

    public ModuleProgress(ModuleProgress ... fordwarder) {
        this.forwarder = fordwarder;
    }

    public void fillStep() {
        this.setStepValue(1.0);
    }

    public double getValue() {
        return this.indeterminated ? -1.0 : this.value;
    }

    public void reset() {
        this.setIndeterminated(false);
        this.startValue = 0.0;
        this.stepVolume = 0.0;
        this.starttime = Time.systemIndependentCurrentJVMTimeMillis();
        this.setStepValue(0.0);
    }

    public void setIndeterminated(boolean b) {
        if (this.isLocked()) {
            return;
        }
        this.indeterminated = b;
    }

    public void setStepValue(double v) {
        if (this.isLocked()) {
            return;
        }
        this.stepValue = v = Math.min(v, 1.0);
        this.setIndeterminated(false);
        double pre = (1.0 - this.startValue) * this.stepVolume / 1.0;
        this.value = this.startValue + pre * v;
        if (this.forwarder != null) {
            for (ModuleProgress mp : this.forwarder) {
                mp.setStepValue(this.value);
            }
        }
    }

    private double calculateValue(double stepValue, double startValue, double stepVolume) {
        stepValue = Math.min(stepValue, 1.0);
        double pre = (1.0 - startValue) * stepVolume / 1.0;
        return startValue + pre * stepValue;
    }

    public double getStepValue() {
        return this.stepValue;
    }

    public void setStepValue(long value, long total) {
        if (this.isLocked()) {
            return;
        }
        this.setStepValue((double)value / (double)total);
    }

    public long getEta() {
        double speed = this.getSpeed();
        if (speed <= 0.0) {
            return -1L;
        }
        double vol = this.startValue + (1.0 - this.startValue) * this.stepVolume - this.value;
        long ret = (long)(vol / speed);
        return ret;
    }

    public double getSpeed() {
        long ms = Time.systemIndependentCurrentJVMTimeMillis() - this.starttime;
        return (this.value - this.startValue) * 1000.0 / (double)ms;
    }

    public void setStepVolume(double stepVolume) {
        if (this.isLocked()) {
            return;
        }
        if (this.isStepVolumeLocked()) {
            return;
        }
        this.starttime = Time.systemIndependentCurrentJVMTimeMillis();
        this.setIndeterminated(false);
        this.stepVolume = stepVolume;
        this.startValue = this.value;
        this.setStepValue(0.0);
    }

    public void setStartValue(double startValue) {
        this.startValue = startValue;
    }

    public void setStepVolumeLocked(boolean b) {
        this.stepVolumeLocked = b;
    }

    public boolean isStepVolumeLocked() {
        return this.stepVolumeLocked;
    }

    public void setStepID(Object stepIdentifier) {
        if (this.isLocked()) {
            return;
        }
        this.stepID = stepIdentifier;
        if (this.forwarder != null) {
            for (ModuleProgress mp : this.forwarder) {
                mp.setStepID(stepIdentifier);
            }
        }
    }

    public Object getStepID() {
        return this.stepID;
    }
}

