/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.defaultimpl.http;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.regex.Pattern;
import org.appwork.loggingv3.LogV3;
import org.appwork.updatesys.client.defaultimpl.http.HttpClientImpl;
import org.appwork.updatesys.transport.exchange.Constants;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.BasicHTTP.BasicHTTP;
import org.appwork.utils.net.BasicHTTP.InvalidResponseCode;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class HttpBackend
extends BasicHTTP {
    private static String USER_AGENT = null;
    private final HttpClientImpl client;

    public static String getGlobalUserAgent() {
        String userAgent = USER_AGENT;
        if (StringUtils.isEmpty(userAgent)) {
            return "AppWork.org/" + Application.getApplication();
        }
        return userAgent;
    }

    public static void setGlobalUserAgent(String uSER_AGENT) {
        USER_AGENT = uSER_AGENT;
    }

    @Override
    protected void log(HTTPConnection connection) {
        LogInterface logger = this.getLogger();
        if (logger != null && connection != null) {
            try {
                String str = connection.toString();
                for (Field f : Constants.class.getFields()) {
                    if (f.getType() != String.class) continue;
                    str = str.replaceAll("\\s+" + Pattern.quote(String.valueOf(f.get(null))) + "\\s*:[^\r\n$]+", "$0 (" + f.getName() + ")");
                }
                logger.info(str);
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
    }

    public HttpBackend(HttpClientImpl httpClientImpl) {
        this.client = httpClientImpl;
        this.putRequestHeader("User-Agent", HttpBackend.getGlobalUserAgent());
        this.putRequestHeader("Cache-Control", "no-cache, no-store");
        this.putRequestHeader("Pragma", "no-cache");
        this.putRequestHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.putRequestHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.3");
        this.setAllowedResponseCodes(200, 206);
    }

    public HttpClientImpl getHttpClient() {
        return this.client;
    }

    @Override
    public LogInterface getLogger() {
        HttpClientImpl client = this.getHttpClient();
        LogInterface logger = client != null ? client.getLogger() : super.getLogger();
        logger = logger != null ? logger : LogV3.I().getDefaultLogger();
        return logger;
    }

    @Override
    public int getConnectTimeout() {
        return Math.max(5000, this.getHttpClient().getSettings().getConnectTimeout());
    }

    @Override
    public int getReadTimeout() {
        return Math.max(5000, this.getHttpClient().getSettings().getReadTimeout());
    }

    @Override
    protected HTTPConnection createHTTPConnection(URL url) {
        HTTPConnection ret = super.createHTTPConnection(url);
        ret.setSSLTrustALL(this.isTrustAllSSL(url));
        return ret;
    }

    protected boolean isTrustAllSSL(URL url) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvalidResponseCode createInvalidResponseCodeException(HTTPConnection connection) {
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            String str = IO.readInputStreamToString(inputStream);
            InvalidResponseCode invalidResponseCode = new InvalidResponseCode(connection, str);
            return invalidResponseCode;
        }
        catch (Exception e) {
            this.getLogger().log(e);
            InvalidResponseCode invalidResponseCode = new InvalidResponseCode(connection, (Throwable)e);
            return invalidResponseCode;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.getLogger().log(e);
                }
            }
        }
    }
}

