/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.tests;

import java.io.File;
import java.io.IOException;
import org.appwork.testframework.AWTest;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.utils.Files;
import org.appwork.utils.os.CrossSystem;

public class AbsoluteFileTest
extends AWTest {
    public static void main(String[] args) throws IOException {
        AWTest.run();
    }

    @Override
    public void runTest() throws Exception {
        if (CrossSystem.isWindows()) {
            AWTest.assertTrue("c:\\".equals(AbsoluteFile.getParent("c:\\xc1")));
            AWTest.assertTrue(AbsoluteFile.getParent("c:\\") == null);
            String res = Files.getRelativePath(new File(""), new File(AbsoluteFile.getParent("test"), "test\\hallo.txt").getCanonicalFile());
            AWTest.assertTrue("test/hallo.txt".equals(res));
            res = Files.getRelativePath(new File(""), new File(AbsoluteFile.getParent("test"), "test2\\hallo.txt").getCanonicalFile());
            AWTest.assertTrue("test2/hallo.txt".equals(res));
            AWTest.assertTrue("test\\..".equals(AbsoluteFile.getParent("test")));
            AWTest.assertTrue("test\\..\\..".equals(AbsoluteFile.getParent("test\\..")));
            AWTest.assertTrue("test\\..\\bla".equals(AbsoluteFile.getParent("test\\..\\bla\\")));
            AWTest.assertTrue("test\\..".equals(AbsoluteFile.getParent("test\\..\\bla")));
            AWTest.assertTrue("test\\..\\bla\\..\\..".equals(AbsoluteFile.getParent("test\\..\\bla\\..")));
            AbsoluteFile parent = new AbsoluteFile("test", "c:\\xc1\\sub", "test");
            parent = parent.getParentFile();
            AWTest.assertTrue("test\\..".equals(parent.getRelative()));
            parent = parent.getParentFile();
            AWTest.assertTrue("test\\..\\..".equals(parent.getRelative()));
            parent = parent.getParentFile();
            AWTest.assertTrue(parent == null);
            AbsoluteFile file = new AbsoluteFile(".%test", "c:\\xc1\\sub", ".%test\\test.txt");
            AWTest.assertTrue("c:\\xc1\\sub\\test.txt".equals(file.getAbsolutePath()));
            String path = file.getParent();
            file = file.getParentFile();
            AWTest.assertTrue(new File(path).equals(file));
            AWTest.assertTrue(".%test".equals(file.getRelative()));
            AWTest.assertTrue("c:\\xc1\\sub".equals(file.getAbsolutePath()));
            path = file.getParent();
            file = file.getParentFile();
            AWTest.assertTrue(new File(path).equals(file));
            AWTest.assertTrue(".%test\\..".equals(file.getRelative()));
            AWTest.assertTrue("c:\\xc1".equals(file.getAbsolutePath()));
            path = file.getParent();
            file = file.getParentFile();
            AWTest.assertTrue(new File(path).equals(file));
            AWTest.assertTrue(".%test\\..\\..".equals(file.getRelative()));
            AWTest.assertTrue("c:\\".equals(file.getAbsolutePath()));
            path = file.getParent();
            file = file.getParentFile();
            AWTest.assertTrue(file == null);
        }
    }
}

