/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.service;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.updatesys.service.ServiceInstallation;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;

public abstract class ConnectService {
    public abstract List<File> getPossibleInstallationDirectories();

    public List<ServiceInstallation> getInstallations() {
        ArrayList<ServiceInstallation> ret = new ArrayList<ServiceInstallation>();
        HashSet<ServiceInstallation> set = new HashSet<ServiceInstallation>();
        List<File> directories = this.getPossibleInstallationDirectories();
        for (File installDir : directories) {
            LogV3.I().getDefaultLogger().info("Search Service in " + installDir);
            ServiceInstallation i = this.getInstallation(installDir, true);
            if (i == null || !set.add(i)) continue;
            LogV3.I().getDefaultLogger().info("Found " + i);
            ret.add(i);
        }
        return ret;
    }

    protected void add(File dir, ArrayList<File> directories) {
        if (!dir.exists()) {
            return;
        }
        if (!directories.contains(dir)) {
            LogV3.I().getDefaultLogger().info("Possible Service Installation: " + dir);
            directories.add(dir);
        }
    }

    protected void collect(File dir, ArrayList<File> directories) {
        if (dir == null || !dir.exists()) {
            return;
        }
        for (File d : dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && (pathname.getName().matches("v\\.(\\d{8}_\\d{6}_\\d+)(_\\d+)?") || pathname.getName().matches("v\\.(\\d+)(_\\d+)?"));
            }
        })) {
            this.add(d, directories);
        }
    }

    public ServiceInstallation getInstallation(File installDir, boolean validate) {
        File portFile = new File(installDir, "http.port");
        File accessTokenFile = new File(installDir, "access.token");
        if (!(!validate || portFile.exists() && accessTokenFile.exists())) {
            LogV3.I().getDefaultLogger().info(installDir + " Port: " + portFile.exists() + " Token: " + accessTokenFile.exists());
            return null;
        }
        int port = -1;
        String accessToken = null;
        try {
            port = portFile.exists() ? Integer.parseInt(IO.readFileToTrimmedString(portFile)) : -1;
        }
        catch (Throwable e) {
            LogV3.I().getDefaultLogger().log(e);
        }
        try {
            accessToken = accessTokenFile.exists() ? IO.readFileToTrimmedString(accessTokenFile) : null;
        }
        catch (Throwable e) {
            LogV3.I().getDefaultLogger().log(e);
        }
        LogV3.I().getDefaultLogger().info(installDir + " AToken: " + StringUtils.isNotEmpty(accessToken) + "; port: " + port);
        if (!validate || port > 0 && StringUtils.isNotEmpty(accessToken)) {
            return new ServiceInstallation(port, accessToken, installDir);
        }
        LogV3.I().getDefaultLogger().info(installDir + " Port: " + port + " Token: " + accessToken);
        return null;
    }

    public ServiceInstallation getRunningServiceInstallation() {
        try {
            List<ServiceInstallation> installations = this.getInstallations();
            if (installations != null) {
                ServiceInstallation highest = null;
                for (ServiceInstallation inst : installations) {
                    inst.loadVersion();
                    if (highest != null && inst.getVersion() <= highest.getVersion()) continue;
                    highest = inst;
                }
                return highest;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

