/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.updatesys.client.DownloadPackageInfo;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.extensions.ExtensionManagerInterface;
import org.appwork.updatesys.transport.DataExchange;
import org.appwork.updatesys.transport.TransportException;
import org.appwork.updatesys.transport.exchange.DeduplicationMode;
import org.appwork.updatesys.transport.exchange.DiskSpaceChanges;
import org.appwork.updatesys.transport.exchange.DownloadUrlList;
import org.appwork.updatesys.transport.exchange.ErrorResponse;
import org.appwork.updatesys.transport.exchange.LastChanceResponse;
import org.appwork.updatesys.transport.exchange.NoChangesResponse;
import org.appwork.updatesys.transport.exchange.PackageResponse;
import org.appwork.updatesys.transport.exchange.ResponseStatus;
import org.appwork.updatesys.transport.exchange.Revision;
import org.appwork.updatesys.transport.exchange.SelfUpdateResponse;
import org.appwork.updatesys.transport.exchange.Up2DateResponse;
import org.appwork.updatesys.transport.exchange.UpdateOptions;
import org.appwork.updatesys.transport.exchange.WaitResponse;
import org.appwork.updatesys.transport.exchange.batch.JobResponse;
import org.appwork.updatesys.transport.exchange.interfaces.ChangeLogResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.ErrorResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.ExportRevisionResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.LastChanceResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.NoChangesResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.PackageResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.RevisionResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.ServerResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.Up2DateResponseInterface;
import org.appwork.updatesys.transport.exchange.interfaces.WaitResponseInterface;
import org.appwork.updatesys.transport.exchange.json.DeserializeableServerJsonResponse;
import org.appwork.updatesys.transport.exchange.json.ErrorJsonResponse;
import org.appwork.updatesys.transport.exchange.json.LastChanceJsonResponse;
import org.appwork.updatesys.transport.exchange.json.LocalPackageJsonResponse;
import org.appwork.updatesys.transport.exchange.json.NoChangesJsonResponse;
import org.appwork.updatesys.transport.exchange.json.PackageJsonResponse;
import org.appwork.updatesys.transport.exchange.json.ServerJsonResponse;
import org.appwork.updatesys.transport.exchange.json.Up2DateJsonResponse;
import org.appwork.updatesys.transport.exchange.json.WaitJsonResponse;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.StringUtils;

public class Pkg
implements DataExchange<Pkg> {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected final UpdateClient updateClient;
    protected final ExtensionManagerInterface optionalsManager;
    protected ServerResponseInterface serverResponse;
    protected ResponseStatus responseStatus;
    protected ArrayList<String> optionalRequestsInstall;
    protected ArrayList<String> optionalRequestsUninstall;
    protected final UpdateOptions updateOptions;
    private ArrayList<String> installedExtensions;
    private int revUrlParameter;
    private int dstUrlParameter;
    protected long timeStamp = -1L;

    public void setOptionalRequestsInstall(ArrayList<String> optionalRequestsInstall) {
        this.optionalRequestsInstall = optionalRequestsInstall;
    }

    public void setOptionalRequestsUninstall(ArrayList<String> optionalRequestsUninstall) {
        this.optionalRequestsUninstall = optionalRequestsUninstall;
    }

    public void setRevUrlParameter(int revUrlParameter) {
        this.revUrlParameter = revUrlParameter;
    }

    public Pkg(UpdateClient updateClient) throws ExtIOException {
        this.updateClient = updateClient;
        this.optionalsManager = updateClient.getExtensionManager();
        this.updateOptions = updateClient.getUpdateOptions();
        this.dstUrlParameter = updateClient.getForcedDestRevision();
        this.initOptionals(updateClient);
        this.revUrlParameter = this.getUpdateClient().getCurrentRevision().getId();
    }

    public void setDstUrlParameter(int dstUrlParameter) {
        this.dstUrlParameter = dstUrlParameter;
    }

    protected ExtensionManagerInterface getExtensionManager() {
        return this.optionalsManager;
    }

    @Override
    public String modifyFinalUrl(String url) throws InterruptedException {
        return url;
    }

    protected void initOptionals(UpdateClient updateClient) throws ExtIOException {
        ExtensionManagerInterface extensionManager = this.getExtensionManager();
        if (extensionManager != null) {
            extensionManager.sync();
            this.optionalRequestsInstall = new ArrayList<String>(extensionManager.getRequestedInstalls());
            this.optionalRequestsUninstall = new ArrayList<String>(extensionManager.getRequestedUninstalls());
            ArrayList<String> ret = new ArrayList<String>();
            Set<String> uiinstall = extensionManager.getRequestedUninstalls();
            for (String s : extensionManager.getInstalled()) {
                if (uiinstall.contains(s)) continue;
                ret.add(s);
            }
            for (String s : this.optionalRequestsInstall) {
                if (uiinstall.contains(s)) continue;
                ret.add(s);
            }
            this.installedExtensions = ret;
        }
    }

    public <T extends ServerResponseInterface> T getInterface(Class<T> intf) {
        ServerResponseInterface serverResponse = this.serverResponse;
        if (serverResponse != null && intf.isAssignableFrom(serverResponse.getClass())) {
            return (T)serverResponse;
        }
        return null;
    }

    public Pkg(UpdateClient updateClient, PackageResponseInterface response) throws ExtIOException {
        this(updateClient);
        this.serverResponse = response;
        this.responseStatus = response != null ? response.getStatus() : null;
    }

    @Override
    public String buildCustomURL() throws InterruptedException {
        return null;
    }

    protected UpdateOptions getUpdateOptions() {
        return this.updateOptions;
    }

    public DeduplicationMode getDeduplicationMode() {
        UpdateOptions updateOptions = this.getUpdateOptions();
        DeduplicationMode mode = updateOptions != null ? updateOptions.getDeduplicationMode() : null;
        return this.getUpdateClient().getSupportedDeduplicationMode(mode);
    }

    public boolean isJarDiffEnabled() {
        UpdateOptions updateOptions = this.getUpdateOptions();
        return updateOptions == null || updateOptions.isJarDiffEnabled();
    }

    public String toString() {
        return this.getRevUrlParameter() + "->" + this.getDestRevision();
    }

    protected DownloadPackageInfo getDownloadPackageInfo() {
        return this.getUpdateClient().readDownloadPackageInfo(this);
    }

    public String getResumeUrlParameter() {
        DownloadPackageInfo info = this.getDownloadPackageInfo();
        if (info != null) {
            String history = this.getUpdateClient().getPackageInstallationHistory(this.getUpdateClient().getPackageFile());
            return "dst=" + info.getDest() + "&hash=" + info.getHash() + "&length=" + new File(info.getPath()).length() + "&size=" + info.getSize() + "&pkg=" + (info.getPkg() != null) + "&history=" + history;
        }
        return null;
    }

    public String getDedupUrlParameter() {
        return this.getDeduplicationMode().name();
    }

    public Revision getDestRevision() {
        RevisionResponseInterface revisionResponse = this.getInterface(RevisionResponseInterface.class);
        if (revisionResponse != null) {
            ChangeLogResponseInterface changeLogResponse;
            Map<String, String> revisionNames;
            final LocalPackageJsonResponse localPackage = this.getLocalPackageResponse();
            Revision ret = new Revision(revisionResponse.getDestRevision(), revisionResponse.getRevisionName()){
                private final boolean extensionsPackage;
                private final String revisionTag;
                {
                    super(id, name);
                    this.extensionsPackage = Pkg.this.getEipList().size() > 0 || Pkg.this.getEirList().size() > 0;
                    this.revisionTag = localPackage != null ? localPackage.getTag() : null;
                }

                @Override
                public boolean _isNewerThan(Revision revision) {
                    String revisionTag = this.getTag();
                    if (StringUtils.isNotEmpty(revisionTag) && !StringUtils.equals(revisionTag, revision.getTag())) {
                        return true;
                    }
                    if (super._isNewerThan(revision)) {
                        return true;
                    }
                    return this.getId() == revision.getId() && this.extensionsPackage;
                }

                @Override
                public String getTag() {
                    return this.revisionTag;
                }
            };
            ExportRevisionResponseInterface exportRevisionResponseInterface = this.getInterface(ExportRevisionResponseInterface.class);
            if (exportRevisionResponseInterface != null && (revisionNames = exportRevisionResponseInterface.getRevisionNames()) != null) {
                String localizedRevisionName;
                String lng = StringUtils.toLowerCaseOrNull(this.getLngUrlParameter());
                String string = localizedRevisionName = lng != null ? revisionNames.get(lng) : null;
                if (StringUtils.isEmpty(localizedRevisionName) && lng != null && lng.contains("_")) {
                    localizedRevisionName = revisionNames.get(lng.replaceFirst("(_.+)", ""));
                }
                if (StringUtils.isEmpty(localizedRevisionName)) {
                    localizedRevisionName = revisionNames.get("en");
                }
                if (StringUtils.isNotEmpty(localizedRevisionName)) {
                    ret.setName(localizedRevisionName);
                }
            }
            if ((changeLogResponse = this.getInterface(ChangeLogResponseInterface.class)) != null) {
                ret.setChangelog(changeLogResponse.getChangeLogText());
            }
            return ret;
        }
        return null;
    }

    public int getAwfcxzUrlParameter() {
        return 1;
    }

    @Deprecated
    protected String encode(String value) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, UTF8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new WTFException(e);
        }
    }

    public ErrorResponseInterface getErrorResponse() {
        return this.getInterface(ErrorResponseInterface.class);
    }

    public Up2DateResponseInterface getUp2DateResponse() {
        return this.getInterface(Up2DateResponseInterface.class);
    }

    public String getEidUrlParameter() throws ExtIOException {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getEidList()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public List<String> getEidList() throws ExtIOException {
        ArrayList<String> eid = this.installedExtensions;
        if (eid == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(eid);
    }

    public void setInstalledExtensions(ArrayList<String> optionalsToInstall) {
        this.installedExtensions = optionalsToInstall;
    }

    public String getEirUrlParameter() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getEirList()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public List<String> getEirList() {
        ArrayList<String> eir = this.optionalRequestsUninstall;
        if (eir == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(eir);
    }

    public String getEipUrlParameter() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getEipList()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public List<String> getEipList() {
        ArrayList<String> eip = this.optionalRequestsInstall;
        if (eip == null) {
            return new ArrayList<String>(0);
        }
        return new ArrayList<String>(eip);
    }

    public int getDstUrlParameter() {
        return this.dstUrlParameter;
    }

    public String getLngUrlParameter() {
        return TranslationFactory.getDesiredLanguage();
    }

    public int getChlgUrlParameter() {
        return this.getUpdateClient().isChangeLogEnabled() ? 1 : 0;
    }

    public int getJdiffUrlParameter() {
        return this.isJarDiffEnabled() ? 1 : 0;
    }

    public NoChangesResponseInterface getNoChangesResponse() {
        return this.getInterface(NoChangesResponseInterface.class);
    }

    public PackageResponseInterface getPackageResponse() {
        return this.getInterface(PackageResponseInterface.class);
    }

    public LocalPackageJsonResponse getLocalPackageResponse() {
        return this.getInterface(LocalPackageJsonResponse.class);
    }

    @Override
    public Pkg getResponseObject() {
        return this;
    }

    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    public LastChanceResponseInterface getLastChanceResponse() {
        return this.getInterface(LastChanceResponseInterface.class);
    }

    public int getRevUrlParameter() {
        return this.revUrlParameter;
    }

    public UpdateClient getUpdateClient() {
        return this.updateClient;
    }

    public WaitResponseInterface getWaitResponse() {
        return this.getInterface(WaitResponseInterface.class);
    }

    public long getServerTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void parseServerResponse(byte[] buffer) throws TransportException, ExtIOException, InterruptedException {
        try {
            String responseString = new String(buffer, UTF8).trim();
            this.getUpdateClient().getLogger().info("Serverresponse: " + responseString);
            if (responseString.startsWith("{") && responseString.endsWith("}")) {
                try {
                    ServerJsonResponse jsonResponse = JSonStorage.restoreFromString(responseString, DeserializeableServerJsonResponse.TYPE);
                    if (jsonResponse != null) {
                        if (jsonResponse.getTimeStamp() > 0L) {
                            this.timeStamp = jsonResponse.getTimeStamp();
                        }
                        this.responseStatus = jsonResponse.getStatus();
                        if (this.onServerJsonResponse(this.getResponseStatus(), jsonResponse, responseString)) {
                            return;
                        }
                        switch (jsonResponse.getStatus()) {
                            case ERROR: {
                                this.serverResponse = JSonStorage.restoreFromString(responseString, ErrorJsonResponse.TYPEREF);
                                return;
                            }
                            case EMPTY: {
                                this.serverResponse = JSonStorage.restoreFromString(responseString, NoChangesJsonResponse.TYPEREF);
                                return;
                            }
                            case URL: {
                                this.serverResponse = this.replaceIncompleteResumePackageResponseInfo(JSonStorage.restoreFromString(responseString, PackageJsonResponse.TYPEREF));
                                return;
                            }
                            case FILE: {
                                this.serverResponse = JSonStorage.restoreFromString(responseString, LocalPackageJsonResponse.TYPEREF);
                                return;
                            }
                            case OK: {
                                this.serverResponse = JSonStorage.restoreFromString(responseString, Up2DateJsonResponse.TYPEREF);
                                return;
                            }
                            case WAIT: {
                                this.serverResponse = JSonStorage.restoreFromString(responseString, WaitJsonResponse.TYPEREF);
                                return;
                            }
                            case LASTCHANCE: {
                                this.serverResponse = JSonStorage.restoreFromString(responseString, LastChanceJsonResponse.TYPEREF);
                                return;
                            }
                            case SELFUPDATE: {
                                this.serverResponse = SelfUpdateResponse.getInstance();
                                break;
                            }
                        }
                    }
                    throw new TransportException("ServerJsonResponse:" + (Object)((Object)this.getResponseStatus()));
                }
                catch (JSonMapperException e) {
                    throw new TransportException(e);
                }
            }
            if (responseString.matches("^\".*\"$")) {
                responseString = JSonStorage.restoreFromString(responseString, TypeRef.STRING);
            }
            String[] lines = responseString.split("\r\n");
            try {
                this.responseStatus = ResponseStatus.valueOf(lines[0]);
            }
            catch (IllegalArgumentException e) {
                throw new TransportException(e);
            }
            if (this.onServerResonse(this.getResponseStatus(), lines)) {
                return;
            }
            switch (this.getResponseStatus()) {
                case ERROR: {
                    this.serverResponse = new ErrorResponse(lines).toJsonVariant();
                    return;
                }
                case EMPTY: {
                    this.serverResponse = new NoChangesResponse(lines).toJsonVariant();
                    return;
                }
                case URL: {
                    this.serverResponse = this.replaceIncompleteResumePackageResponseInfo(new PackageResponse(lines).toJsonVariant());
                    return;
                }
                case FILE: {
                    throw new TransportException("Unsupported:" + (Object)((Object)this.getResponseStatus()));
                }
                case OK: {
                    this.serverResponse = new Up2DateResponse(lines).toJsonVariant();
                    return;
                }
                case WAIT: {
                    this.serverResponse = new WaitResponse(lines).toJsonVariant();
                    return;
                }
                case LASTCHANCE: {
                    this.serverResponse = new LastChanceResponse(lines).toJsonVariant();
                    return;
                }
                case SELFUPDATE: {
                    this.serverResponse = SelfUpdateResponse.getInstance();
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new TransportException(e);
        }
        catch (NumberFormatException e) {
            throw new TransportException(e);
        }
        catch (MalformedURLException e) {
            throw new TransportException(e);
        }
    }

    protected PackageJsonResponse replaceIncompleteResumePackageResponseInfo(final PackageJsonResponse packageResponse) {
        final DownloadPackageInfo info = this.getDownloadPackageInfo();
        if (packageResponse != null && info != null && info.getPkg() != null && packageResponse.getSize() == info.getSize() && StringUtils.equalsIgnoreCase(packageResponse.getHash(), info.getHash()) && packageResponse.getDestRevision() == info.getDest() && (packageResponse.getUrls() == null || packageResponse.getUrls().size() == 0)) {
            PackageJsonResponse ret = new PackageJsonResponse(new PackageResponseInterface(){
                private final PackageJsonResponse pkg;
                private final long downloadID;
                {
                    this.pkg = info.getPkg();
                    this.downloadID = packageResponse.getDownloadID();
                }

                @Override
                public List<String> getUpdateFlags() {
                    return this.pkg.getUpdateFlags();
                }

                @Override
                public String getRevisionName() {
                    return this.pkg.getRevisionName();
                }

                @Override
                public int getDestRevision() {
                    return this.pkg.getDestRevision();
                }

                @Override
                public DownloadUrlList getChangeLogUrls() {
                    return null;
                }

                @Override
                public long getChangeLogSize() {
                    return -1L;
                }

                @Override
                public String getChangeLogHash() {
                    return null;
                }

                @Override
                public long getChangeLogContentSize() {
                    return -1L;
                }

                @Override
                public Map<String, DiskSpaceChanges> getDiskSpaceChanges() {
                    return this.pkg.getDiskSpaceChanges();
                }

                @Override
                public ResponseStatus getStatus() {
                    return this.pkg.getStatus();
                }

                @Override
                public boolean isEncrypted() {
                    return this.pkg.isEncrypted();
                }

                @Override
                public DownloadUrlList getUrls() {
                    return this.pkg.getUrls();
                }

                @Override
                public long getSize() {
                    return this.pkg.getSize();
                }

                @Override
                public String getHash() {
                    return this.pkg.getHash();
                }

                @Override
                public long getContentSize() {
                    return this.pkg.getContentSize();
                }

                @Override
                public long getDownloadID() {
                    return this.downloadID;
                }

                @Override
                public String getChangeLogText() {
                    return this.pkg.getChangeLogText();
                }

                @Override
                public void setChangeLogText(String text) {
                }
            });
            return ret;
        }
        return packageResponse;
    }

    protected boolean onServerResonse(ResponseStatus status, String[] lines) throws TransportException, ExtIOException, InterruptedException {
        return false;
    }

    protected boolean onServerJsonResponse(ResponseStatus status, ServerJsonResponse jsonResponse, String responseString) throws TransportException, ExtIOException, InterruptedException {
        return false;
    }

    @Override
    public boolean parseJobResponse(JobResponse response) throws ExtIOException, TransportException, InterruptedException {
        try {
            switch (ResponseStatus.valueOf(response.getName())) {
                case ERROR: 
                case EMPTY: 
                case URL: 
                case FILE: 
                case OK: 
                case WAIT: 
                case LASTCHANCE: 
                case SELFUPDATE: {
                    this.parseServerResponse(response.getJson().getBytes(UTF8));
                    return true;
                }
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

