/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.storage.TypeRef;
import org.appwork.storage.converter.SelfJsonConverterForSerialization;
import org.appwork.updatesys.transport.exchange.SyncProviderInterface;

public class SyncedTime
implements Storable,
SelfJsonConverterForSerialization {
    public static final TypeRef<SyncedTime> TYPEREF = new TypeRef<SyncedTime>(SyncedTime.class){};
    protected final Long _sessionNano;
    private volatile AtomicStorage atomic = new AtomicStorage(-1L, SyncType.NONE);

    @StorableAllowPrivateAccessModifier
    private SyncedTime() {
        this._sessionNano = null;
    }

    public SyncedTime(long nanoTime) {
        this._sessionNano = nanoTime;
    }

    public AtomicStorage _getAtomic() {
        return this.atomic;
    }

    public String toString() {
        return this._getAtomic().toString();
    }

    public void _setAtomic(long ms, SyncType type) {
        this._setAtomic(new AtomicStorage(ms, type));
    }

    public void _setAtomic(AtomicStorage atomic) {
        if (atomic == null) {
            throw new IllegalArgumentException();
        }
        this.atomic = atomic;
    }

    public SyncType getType() {
        return this._getAtomic().type;
    }

    public void setType(SyncType type) {
        this.atomic = this._getAtomic().setType(type);
    }

    public long getMs() {
        return this._getAtomic().ms;
    }

    public void setMs(long absolute) {
        this.atomic = this._getAtomic().setMs(absolute);
    }

    public boolean sync(SyncProviderInterface serverTime) {
        AtomicStorage time = this._getAtomic();
        switch (time.getType()) {
            case NONE: {
                this.atomic = this._sessionNano != null ? new AtomicStorage(serverTime.getSessionTime(this._sessionNano), SyncType.SRV) : new AtomicStorage(time.getMs() + serverTime.getMSOffsetServerAheadTime(), SyncType.OFF);
                return true;
            }
            case OFF: {
                if (this._sessionNano != null) {
                    this.atomic = new AtomicStorage(serverTime.getSessionTime(this._sessionNano), SyncType.SRV);
                    return true;
                }
                return false;
            }
            case SRV: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Object convertForSerialization(Object mapperContext) {
        HashMap<String, Object> export = new HashMap<String, Object>();
        AtomicStorage time = this._getAtomic();
        export.put("ms", time.getMs());
        export.put("type", time.getType().name());
        return export;
    }

    public class AtomicStorage {
        final long ms;
        final SyncType type;

        public AtomicStorage(long ms, SyncType type) {
            if (type == null) {
                throw new IllegalArgumentException();
            }
            this.ms = ms;
            this.type = type;
        }

        protected AtomicStorage setMs(long absolute) {
            return new AtomicStorage(absolute, this.type);
        }

        protected AtomicStorage setType(SyncType type) {
            return new AtomicStorage(this.ms, type);
        }

        public long getMs() {
            return this.ms;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.ms, this.type});
        }

        public String toString() {
            return new Date(this.getMs()) + "." + this.getMs() % 1000L + " (" + (Object)((Object)this.getType()) + ")";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof AtomicStorage) {
                AtomicStorage o = (AtomicStorage)obj;
                return this.ms == o.ms && this.type == o.type;
            }
            return false;
        }

        public SyncType getType() {
            return this.type;
        }
    }

    public static enum SyncType {
        SRV,
        OFF,
        NONE;

    }
}

