/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.transport.exchange;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.LEB128;
import org.appwork.utils.awfc.AWFCEntry;
import org.appwork.utils.awfc.AWFCInputStream;
import org.appwork.utils.awfc.AWFCOutputStream;
import org.appwork.utils.crypto.AWSign;
import org.appwork.utils.crypto.SignatureViolationException;
import org.appwork.utils.net.NoClosingInputStream;
import org.appwork.utils.net.NoClosingOutputStream;
import org.appwork.utils.zip.CompressedEntriesIndex;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

public class ZipSignature {
    private static String HASH_V1 = "HASH.1.";
    private static String CATALOG_V1 = "CATALOG.1.";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final File file;
    private final int revision;
    private final String path;

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.path;
    }

    public int getRevision() {
        return this.revision;
    }

    protected COMPRESSION getCompressionMode(String entry) {
        if (entry == null) {
            return COMPRESSION.DEFLATE;
        }
        if (entry.endsWith(".raw")) {
            return COMPRESSION.RAW;
        }
        if (entry.endsWith(".xz")) {
            return COMPRESSION.XZ;
        }
        if (entry.endsWith(".deflate")) {
            return COMPRESSION.DEFLATE;
        }
        return COMPRESSION.RAW;
    }

    public ZipSignature(File f, int revision, String rel) {
        this.file = f;
        this.revision = revision;
        if (rel.endsWith("/")) {
            rel = rel.substring(0, rel.length() - 1);
        }
        this.path = rel;
    }

    public byte[] create(PrivateKey privateKey) throws SignatureViolationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] container = this.createContainer();
            byte[] containerSignature = this.signContainer(privateKey, container);
            LEB128.write(bos, container.length);
            bos.write(container);
            LEB128.write(bos, containerSignature.length);
            bos.write(containerSignature);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new SignatureViolationException(e);
        }
    }

    protected byte[] signContainer(PrivateKey privateKey, byte[] container) throws SignatureViolationException {
        String toSign = this.getRevision() + "\r\n" + this.getPath() + "\r\n" + Hash.getSHA256(container) + "\r\n" + container.length;
        return AWSign.createSign(toSign.getBytes(UTF8), privateKey, true);
    }

    protected void verifyContainerSignature(PublicKey publicKey, byte[] container, byte[] signature) throws SignatureViolationException {
        String toVerify = this.getRevision() + "\r\n" + this.getPath() + "\r\n" + Hash.getSHA256(container) + "\r\n" + container.length;
        try {
            AWSign.verify(toVerify.getBytes(UTF8), publicKey, signature, true);
        }
        catch (SignatureViolationException e) {
            throw new SignatureViolationException("container signature verification failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyContainer(byte[] container) throws SignatureViolationException {
        try {
            ZipFile zipFile = new ZipFile(this.getFile());
            try {
                AWFCEntry containerEntry;
                AWFCInputStream is = new AWFCInputStream(new ByteArrayInputStream(container));
                List<String> signatureContentCatalogV1 = null;
                byte[] signatureContentHashV1 = null;
                while ((containerEntry = is.getNextEntry()) != null) {
                    COMPRESSION compression;
                    if (containerEntry.getPath().startsWith(CATALOG_V1)) {
                        compression = this.getCompressionMode(containerEntry.getPath());
                        signatureContentCatalogV1 = this.parseContentCatalogV1(this.wrapInputStream(is, compression));
                        continue;
                    }
                    if (!containerEntry.getPath().startsWith(HASH_V1)) continue;
                    compression = this.getCompressionMode(containerEntry.getPath());
                    signatureContentHashV1 = this.parseContentHashV1(this.wrapInputStream(is, compression));
                }
                if (signatureContentCatalogV1 != null && signatureContentHashV1 != null && signatureContentHashV1.length == 32) {
                    byte[] freshContentHashV1 = this.calculateContentHashV1(null, zipFile, signatureContentCatalogV1);
                    if (Arrays.equals(signatureContentHashV1, freshContentHashV1)) {
                        return;
                    }
                    throw new SignatureViolationException("content hash v1 verification failed!");
                }
            }
            finally {
                zipFile.close();
            }
            throw new SignatureViolationException("no valid signature found");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureViolationException(e);
        }
        catch (IOException e) {
            throw new SignatureViolationException(e);
        }
    }

    protected InputStream wrapInputStream(InputStream is, COMPRESSION compression) throws IOException {
        NoClosingInputStream raw = new NoClosingInputStream(is);
        return compression.wrap(raw);
    }

    protected OutputStream wrapOutputStream(OutputStream os, COMPRESSION compression) throws IOException {
        NoClosingOutputStream raw = new NoClosingOutputStream(os);
        return compression.wrap(raw);
    }

    protected byte[] parseContentHashV1(InputStream is) throws IOException {
        return IO.readStream(32, is);
    }

    public void verify(PublicKey publicKey) throws SignatureViolationException {
        try {
            byte[] signatureData = this.readSignature();
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(signatureData));
            int containerLength = LEB128.readInt(is, true);
            byte[] container = new byte[containerLength];
            is.readFully(container);
            int signatureLength = LEB128.readInt(is, true);
            byte[] signature = new byte[signatureLength];
            is.readFully(signature);
            this.verifyContainerSignature(publicKey, container, signature);
            this.verifyContainer(container);
        }
        catch (IOException e) {
            throw new SignatureViolationException(e);
        }
    }

    public byte[] readSignature() throws IOException {
        return IO.readFile(new File(this.getFile().getAbsolutePath() + ".zipSignature"));
    }

    protected byte[] createContainer() throws IOException {
        ZipFile zipFile = new ZipFile(this.getFile());
        try {
            ArrayList<String> entries = new ArrayList<String>();
            Enumeration<? extends ZipEntry> enume = zipFile.entries();
            while (enume.hasMoreElements()) {
                ZipEntry zipEntry = enume.nextElement();
                entries.add(zipEntry.getName());
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            AWFCOutputStream os = new AWFCOutputStream(bos, null);
            this.buildContentCatalogV1(os, entries);
            this.calculateContentHashV1(os, zipFile, entries);
            os.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] calculateContentHashV1(AWFCOutputStream addToOutputStream, ZipFile zipFile, List<String> entries) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[Short.MAX_VALUE];
        Iterator<String> it = entries.iterator();
        Enumeration<? extends ZipEntry> enume = zipFile.entries();
        int entryIndex = 0;
        while (enume.hasMoreElements()) {
            String expectedEntry;
            int currentEntryIndex = entryIndex++;
            ZipEntry zipEntry = enume.nextElement();
            String string = expectedEntry = it.hasNext() ? it.next() : null;
            if (expectedEntry == null) {
                throw new IOException("zip file catalog issue at index=" + currentEntryIndex + "|current=" + zipEntry.getName() + " but no more entries are expected!");
            }
            if (!zipEntry.getName().equals(expectedEntry)) {
                throw new IOException("zip file catalog issue at index=" + currentEntryIndex + "|expected=" + expectedEntry + " but current=" + zipEntry.getName());
            }
            if (zipEntry.isDirectory()) {
                md.update("D,".getBytes(UTF8));
                md.update(zipEntry.getName().getBytes(UTF8));
                continue;
            }
            md.update("F,".getBytes(UTF8));
            md.update(zipEntry.getName().getBytes(UTF8));
            InputStream zipEntryInputStream = zipFile.getInputStream(zipEntry);
            try {
                while (true) {
                    int read;
                    if ((read = zipEntryInputStream.read(buffer)) > 0) {
                        md.update(buffer, 0, read);
                        continue;
                    }
                    if (read == -1) break;
                }
            }
            finally {
                zipEntryInputStream.close();
            }
        }
        if (it.hasNext()) {
            throw new IOException("zip file catalog issue|" + (entries.size() - entryIndex) + " missing entries!");
        }
        byte[] ret = md.digest();
        if (addToOutputStream != null) {
            AWFCEntry entry = new AWFCEntry(HASH_V1 + COMPRESSION.RAW.getExtension(), ret.length, null);
            addToOutputStream.putNextEntry(entry);
            addToOutputStream.write(ret);
        }
        return ret;
    }

    protected List<String> parseContentCatalogV1(InputStream is) throws IOException {
        List<String> ret = new CompressedEntriesIndex().uncompress(is);
        is.close();
        return ret;
    }

    protected byte[] buildContentCatalogV1(AWFCOutputStream addToOutputStream, List<String> entries) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        COMPRESSION compression = this.getCompressionMode(null);
        OutputStream os = this.wrapOutputStream(bos, compression);
        new CompressedEntriesIndex().compress(entries, os);
        os.close();
        byte[] ret = bos.toByteArray();
        if (addToOutputStream != null) {
            AWFCEntry entry = new AWFCEntry(CATALOG_V1 + compression.getExtension(), ret.length, null);
            addToOutputStream.putNextEntry(entry);
            addToOutputStream.write(ret);
        }
        return ret;
    }

    public static enum ZIPDIFFSUPPORT {
        NONE,
        V1;

    }

    public static enum COMPRESSION {
        RAW{

            @Override
            protected InputStream wrap(InputStream is) throws IOException {
                return is;
            }

            @Override
            protected OutputStream wrap(OutputStream os) throws IOException {
                return os;
            }

            @Override
            protected String getExtension() {
                return "raw";
            }
        }
        ,
        DEFLATE{

            @Override
            protected InputStream wrap(InputStream is) throws IOException {
                return new InflaterInputStream(is);
            }

            @Override
            protected OutputStream wrap(OutputStream os) throws IOException {
                return new DeflaterOutputStream(os, new Deflater(9));
            }

            @Override
            protected String getExtension() {
                return "deflate";
            }
        }
        ,
        XZ{

            @Override
            protected InputStream wrap(InputStream is) throws IOException {
                return new XZInputStream(is);
            }

            @Override
            protected OutputStream wrap(OutputStream os) throws IOException {
                LZMA2Options lzma2 = new LZMA2Options();
                lzma2.setPreset(7);
                return new XZOutputStream(os, (FilterOptions)lzma2, 0);
            }

            @Override
            protected String getExtension() {
                return "xz";
            }
        };


        protected abstract InputStream wrap(InputStream var1) throws IOException;

        protected abstract OutputStream wrap(OutputStream var1) throws IOException;

        protected abstract String getExtension();
    }
}

