/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.ImageProvider;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.appwork.loggingv3.LogV3;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.storage.config.MinTimeWeakReferenceCleanup;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.images.DisabledIcon;
import org.appwork.utils.images.IconIO;

public class ImageProvider {
    private static final long MIN_LIFETIME = 20000L;
    private static HashMap<String, MinTimeWeakReference<BufferedImage>> IMAGE_CACHE = new HashMap();
    private static MinTimeWeakReferenceCleanup IMAGE_CACHE_CLEANUP = new MinTimeWeakReferenceCleanup(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMinTimeWeakReferenceCleanup(MinTimeWeakReference<?> minTimeWeakReference) {
            Object object = LOCK;
            synchronized (object) {
                IMAGE_CACHE.remove(minTimeWeakReference.getID());
            }
        }
    };
    private static HashMap<String, MinTimeWeakReference<ImageIcon>> IMAGEICON_CACHE = new HashMap();
    private static MinTimeWeakReferenceCleanup IMAGEICON_CACHE_CLEANUP = new MinTimeWeakReferenceCleanup(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMinTimeWeakReferenceCleanup(MinTimeWeakReference<?> minTimeWeakReference) {
            Object object = LOCK;
            synchronized (object) {
                IMAGEICON_CACHE.remove(minTimeWeakReference.getID());
            }
        }
    };
    private static WeakHashMap<Icon, MinTimeWeakReference<Icon>> DISABLED_ICON_CACHE = new WeakHashMap();
    private static Object LOCK = new Object();
    private static final AtomicReference<String> FONTNAME;

    public static BufferedImage convertToGrayScale(Image img) {
        BufferedImage bufferedImage = IconIO.toBufferedImage(img);
        BufferedImage dest = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        for (int y = 0; y < dest.getHeight(); ++y) {
            for (int x = 0; x < dest.getWidth(); ++x) {
                int alpha = bufferedImage.getRGB(x, y) & 0xFF000000;
                Color tmp = new Color(bufferedImage.getRGB(x, y));
                int val = (int)((double)tmp.getRed() * 0.3 + (double)tmp.getGreen() * 0.59 + (double)tmp.getBlue() * 0.11);
                dest.setRGB(x, y, alpha | val | val << 8 & 0xFF00 | val << 16 & 0xFF0000);
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDrawFontName() {
        if (FONTNAME.get() != null) {
            return FONTNAME.get();
        }
        AtomicReference<String> atomicReference = FONTNAME;
        synchronized (atomicReference) {
            if (FONTNAME.get() != null) {
                return FONTNAME.get();
            }
            try {
                String[] availableFontFamilyNames;
                if (!Application.isHeadless() && (availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) != null) {
                    for (String fontFamilyName : availableFontFamilyNames) {
                        if (!"Arial".equals(fontFamilyName)) continue;
                        FONTNAME.set(fontFamilyName);
                        return fontFamilyName;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            FONTNAME.set("Dialog");
            return "Dialog";
        }
    }

    private static Image dereferenceImage(Image image) throws IOException {
        BufferedImage bu = IconIO.createEmptyImage(image.getHeight(null), image.getWidth(null), image);
        Graphics g = bu.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bu;
    }

    public static boolean isBuggyFontEnvironment(Throwable throwable) {
        if (Application.isHeadless()) {
            if (Exceptions.getInstanceof(throwable, NoClassDefFoundError.class) != null) {
                return true;
            }
            if (Exceptions.getInstanceof(throwable, ClassCastException.class) != null) {
                return true;
            }
            if (Exceptions.getInstanceof(throwable, NullPointerException.class) != null || Exceptions.getInstanceof(throwable, InvocationTargetException.class) != null) {
                return true;
            }
            if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                LogV3.log(throwable);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon != null) {
            Object object = LOCK;
            synchronized (object) {
                Icon cachedDisabledIcon;
                MinTimeWeakReference<Icon> cache = DISABLED_ICON_CACHE.get(icon);
                Icon icon2 = cachedDisabledIcon = cache == null ? null : cache.get();
                if (cachedDisabledIcon != null) {
                    return cachedDisabledIcon;
                }
                DisabledIcon disabledIcon = new DisabledIcon(icon);
                DISABLED_ICON_CACHE.put(icon, new MinTimeWeakReference<DisabledIcon>(disabledIcon, 20000L, "disabled icon"));
                return disabledIcon;
            }
        }
        return null;
    }

    public static void writeImage(RenderedImage im, String formatName, File file) throws IOException {
        if (!ImageIO.write(im, formatName, file)) {
            throw new IOException("no appropriate " + formatName + " writer found!");
        }
    }

    public static void writeImage(RenderedImage im, String formatName, OutputStream output) throws IOException {
        if (!ImageIO.write(im, formatName, output)) {
            throw new IOException("no appropriate " + formatName + " writer found!");
        }
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int width, int height, Object hint, boolean higherQuality) {
        int h;
        int w;
        double faktor = Math.max((double)img.getWidth() / (double)width, (double)img.getHeight() / (double)height);
        width = (int)((double)img.getWidth() / faktor);
        height = (int)((double)img.getHeight() / faktor);
        if (faktor == 1.0) {
            return img;
        }
        BufferedImage ret = img;
        if (higherQuality) {
            w = Math.max(width, img.getWidth());
            h = Math.max(height, img.getHeight());
        } else {
            w = width;
            h = height;
        }
        do {
            if (higherQuality && w > width && (w /= 2) < width) {
                w = width;
            }
            if (higherQuality && h > height && (h /= 2) < height) {
                h = height;
            }
            BufferedImage tmp = new BufferedImage(w, h, ret.getType() == 0 ? 6 : ret.getType());
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != width || h != height);
        return ret;
    }

    public static Image merge(Image back, Image front, int xoffset, int yoffset) {
        int yoffsetBottom;
        int yoffsetTop;
        int xoffsetBottom;
        int xoffsetTop;
        if (xoffset >= 0) {
            xoffsetTop = 0;
            xoffsetBottom = xoffset;
        } else {
            xoffsetTop = -xoffset;
            xoffsetBottom = 0;
        }
        if (yoffset >= 0) {
            yoffsetTop = 0;
            yoffsetBottom = yoffset;
        } else {
            yoffsetTop = -yoffset;
            yoffsetBottom = 0;
        }
        return ImageProvider.merge(back, front, xoffsetTop, yoffsetTop, xoffsetBottom, yoffsetBottom);
    }

    public static Image merge(Icon back, Icon front, int xoffsetBack, int yoffsetBack, int xoffsetFront, int yoffsetFront, Composite backComposite, Composite frontComposite) {
        Image backImage = IconIO.toImage(back);
        Image frontImage = IconIO.toImage(front);
        int width = Math.max(xoffsetBack + back.getIconWidth(), xoffsetFront + front.getIconWidth());
        int height = Math.max(yoffsetBack + back.getIconHeight(), yoffsetFront + front.getIconHeight());
        return ImageProvider.merge(backImage, frontImage, xoffsetBack, yoffsetBack, xoffsetFront, yoffsetFront, backComposite, frontComposite, width, height);
    }

    protected static Image merge(Image backVariant, Image frontVariant, int xoffsetBack, int yoffsetBack, int xoffsetFront, int yoffsetFront, Composite backComposite, Composite frontComposite, int width, int height) {
        Composite old;
        BufferedImage target = IconIO.createEmptyImage(width, height);
        Graphics2D g2 = target.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (backComposite != null) {
            old = g2.getComposite();
            g2.setComposite(backComposite);
            g2.drawImage(backVariant, xoffsetBack, yoffsetBack, null);
            g2.setComposite(old);
        } else {
            g2.drawImage(backVariant, xoffsetBack, yoffsetBack, null);
        }
        if (frontComposite != null) {
            old = g2.getComposite();
            g2.setComposite(frontComposite);
            g2.drawImage(frontVariant, xoffsetFront, yoffsetFront, null);
            g2.setComposite(old);
        } else {
            g2.drawImage(frontVariant, xoffsetFront, yoffsetFront, null);
        }
        g2.dispose();
        return target;
    }

    public static Image merge(Icon back, Icon front, int xoffsetBack, int yoffsetBack, int xoffsetFront, int yoffsetFront) {
        return ImageProvider.merge(back, front, xoffsetBack, yoffsetBack, xoffsetFront, yoffsetFront, null, null);
    }

    public static Image merge(Image back, Image front, int xoffsetBack, int yoffsetBack, int xoffsetFront, int yoffsetFront) {
        return ImageProvider.merge(new ImageIcon(back), new ImageIcon(front), xoffsetBack, yoffsetBack, xoffsetFront, yoffsetFront);
    }

    public static BufferedImage read(File input) throws IOException {
        if (!input.canRead()) {
            throw new IIOException("Can't read input file!");
        }
        FileInputStream is = new FileInputStream(input);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        finally {
            is.close();
        }
    }

    @Deprecated
    public static Image scaleBufferedImage(BufferedImage img, int width, int height) {
        return ImageProvider.scaleImage(img, width, height);
    }

    public static Image scaleImage(Image img, int width, int height) {
        if (img == null) {
            return null;
        }
        int imgWidth = img.getWidth(null);
        int imgHeight = img.getHeight(null);
        double faktor = Math.max((double)imgWidth / (double)width, (double)imgHeight / (double)height);
        width = (int)((double)imgWidth / faktor);
        height = (int)((double)imgHeight / faktor);
        if (faktor == 1.0) {
            return img;
        }
        Image image = img.getScaledInstance(width, height, 4);
        try {
            return ImageProvider.dereferenceImage(image);
        }
        catch (IOException e) {
            LogV3.log(e);
            return null;
        }
    }

    public static ImageIcon scaleImageIcon(ImageIcon img, int w, int h) {
        Image dest;
        if (img.getIconHeight() == h && img.getIconWidth() == w) {
            return img;
        }
        if (ReflectionUtils.isInstanceOf("sun.awt.image.ToolkitImage", img.getImage())) {
            dest = IconIO.createEmptyImage(w, h);
            Graphics2D g2 = ((BufferedImage)dest).createGraphics();
            g2.drawImage(img.getImage(), 0, 0, null);
            g2.dispose();
        } else {
            dest = img.getImage();
        }
        return new ImageIcon(ImageProvider.scaleImage(dest, w, h));
    }

    public static ImageIcon toImageIcon(JComponent component, Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return (ImageIcon)icon;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = IconIO.createEmptyImage(w, h);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            icon.paintIcon(component, g, 0, 0);
        }
        catch (NullPointerException e) {
            try {
                e.printStackTrace();
                JFrame frame = new JFrame();
                JButton bt = new JButton();
                frame.getContentPane().add(bt);
                icon.paintIcon(bt, g, 0, 0);
            }
            catch (Throwable ignore) {
                ignore.printStackTrace();
            }
        }
        g.dispose();
        return new ImageIcon(image);
    }

    public static ImageIcon toImageIcon(Icon icon) {
        return ImageProvider.toImageIcon(null, icon);
    }

    static {
        ImageIO.setUseCache(false);
        FONTNAME = new AtomicReference<Object>(null);
    }
}

