/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class Licenser {
    public static String[] getLines(String arg) {
        if (arg == null) {
            return new String[0];
        }
        String[] temp = arg.split("[\r\n]{1,2}");
        int tempLength = temp.length;
        String[] output = new String[tempLength];
        for (int i = 0; i < tempLength; ++i) {
            output[i] = temp[i];
        }
        return output;
    }

    public static void main(String[] args) throws URISyntaxException, IOException {
        Application.setApplication(".licenser");
        File file = new File(new File(Application.class.getResource("Application.class").toURI()).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "/AppWorkUtils/src");
        String license = IO.readFileToString(new File(file.getParentFile(), "/License AppWork Utilities.txt"));
        Licenser.doIt(file, license);
        file = new File(new File(Application.class.getResource("Application.class").toURI()).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile(), "/MyJDownloaderClient/src");
        String newName = "My JDownloader Client";
        license = license.replace("AppWork Utilities", "My JDownloader Client");
        File newFile = new File(file.getParentFile(), "/License " + newName + ".txt");
        newFile.delete();
        IO.writeStringToFile(newFile, license);
        Licenser.doIt(file, license);
    }

    protected static void doIt(File file, String license) {
        final StringBuilder sb = new StringBuilder();
        sb.append("/**");
        for (String line : Licenser.getLines(license)) {
            sb.append("\r\n");
            sb.append(" * ");
            sb.append(line);
        }
        sb.append(" */\r\n");
        System.out.println(file);
        Files.walkThroughStructure(new Files.AbstractHandler<RuntimeException>(){

            @Override
            public void onFile(File f) throws RuntimeException {
                block12: {
                    if (f.isFile() && f.getName().endsWith(".java")) {
                        try {
                            String src = IO.readFileToString(f);
                            int index = src.indexOf("package ");
                            if (index >= 0) {
                                String header = src.substring(0, index);
                                if (header.contains("AppWork GmbH")) {
                                    this.write(sb, f, src, index);
                                    return;
                                }
                                if (header.contains("AppWork UG")) break block12;
                                if ((header = header.replaceAll("[*/\\s]*", "")).trim().length() == 0) {
                                    if (src.toLowerCase().contains("license") || src.toLowerCase().contains("m.i.t") || src.toLowerCase().contains("gpl") || src.toLowerCase().contains("bsd") || src.toLowerCase().contains("apache")) {
                                        try {
                                            Dialog.getInstance().showConfirmDialog(0, "Write " + f);
                                        }
                                        catch (DialogClosedException e) {
                                            return;
                                        }
                                        catch (DialogCanceledException e) {
                                            return;
                                        }
                                    }
                                    this.write(sb, f, src, index);
                                    break block12;
                                }
                                if (header.contains("GNUGeneralPublicLicense") && header.contains("JD-Team")) {
                                    this.write(sb, f, src, index);
                                } else {
                                    System.out.println("??");
                                }
                                break block12;
                            }
                            System.out.println("??");
                        }
                        catch (IOException e) {
                            throw new WTFException(e);
                        }
                    }
                }
            }

            protected void write(StringBuilder sb2, File f, String src, int index) throws IOException {
                f.delete();
                IO.writeStringToFile(f, sb2 + this.clean(src.substring(index, src.length())));
            }

            private String clean(String src) {
                if ((src = src.replaceAll("/\\*\\*\\s*\\*\\s*Copyright.*AppWork UG.*\\* for details.*\\*\\/", "")).contains("AppWork UG")) {
                    System.out.println(src);
                }
                return src;
            }
        }, file);
    }
}

