/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.Joiner;

public class StringUtils {
    private static final String whitespace_chars = "[\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]";
    private static String EMPTY_SPACE_STRING = "                                                                                                                                                                                                                                                             ";
    public static final Pattern NEWLINE = Pattern.compile("[\r\n]{1,2}");
    public static final Pattern DEFAULT_WRAP_BEFORE = Pattern.compile("(\\s)");
    private static final Pattern MATCHES_NEVER;
    public static final Pattern DEFAULT_WRAP_AFTER;

    public static boolean contains(String input, String contains) {
        if (input == null || contains == null) {
            return false;
        }
        return input.contains(contains);
    }

    public static String[] getLines(String arg) {
        if (arg == null) {
            return new String[0];
        }
        String[] splits = arg.split("(\r\n|\r|\n)");
        ArrayList<String> ret = new ArrayList<String>(splits.length);
        for (String split : splits) {
            ret.add(split.trim());
        }
        return ret.toArray(new String[0]);
    }

    public static String formatByPadLength(int padLength, int num) {
        return StringUtils.formatByPadLength(Locale.ROOT, padLength, num);
    }

    public static String formatByPadLength(Locale locale, int padLength, int num) {
        if (locale == null) {
            return String.format(Locale.ROOT, "%0" + padLength + "d", num);
        }
        return String.format(locale, "%0" + padLength + "d", num);
    }

    public static boolean endsWithCaseInsensitive(String name, String endsWith) {
        if (name == null || endsWith == null) {
            return false;
        }
        if (endsWith.length() > name.length()) {
            return false;
        }
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(endsWith)) {
            return false;
        }
        return name.endsWith(endsWith) || name.toLowerCase(Locale.ENGLISH).endsWith(endsWith.toLowerCase(Locale.ENGLISH));
    }

    public static boolean startsWithCaseInsensitive(String name, String startsWith) {
        if (name == null || startsWith == null) {
            return false;
        }
        if (startsWith.length() > name.length()) {
            return false;
        }
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(startsWith)) {
            return false;
        }
        return name.startsWith(startsWith) || name.toLowerCase(Locale.ENGLISH).startsWith(startsWith.toLowerCase(Locale.ENGLISH));
    }

    public static boolean containsIgnoreCase(String input, String contains) {
        if (input == null || contains == null) {
            return false;
        }
        if (contains.length() > input.length()) {
            return false;
        }
        return input.contains(contains) || input.toLowerCase(Locale.ENGLISH).contains(contains.toLowerCase(Locale.ENGLISH));
    }

    public static String trim(String input) {
        if (input != null) {
            return StringUtils.removeBOM(input.replaceAll("^[\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]+", "").replaceAll("[\\u0009\\u000A\\u000B\\u000C\\u000D\\u0020\\u0085\\u00A0\\u1680\\u180E\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200A\\u2028\\u2029\\u202F\\u205F\\u3000]+$", ""));
        }
        return null;
    }

    public static String removeBOM(String input) {
        if (input != null && input.startsWith("\ufeff")) {
            return input.substring(1);
        }
        return input;
    }

    public static String nullOrNonEmpty(String x) {
        if (StringUtils.isNotEmpty(x)) {
            return x;
        }
        return null;
    }

    public static String valueOrEmpty(String x) {
        if (x == null) {
            return "";
        }
        return x;
    }

    public static String nullify(String string) {
        if (string == null || "null".equals(string)) {
            return null;
        }
        return string;
    }

    public static boolean equals(String x, String y) {
        if (x == y) {
            return true;
        }
        if (x == null && y != null) {
            return false;
        }
        if (y == null && x != null) {
            return false;
        }
        return x.equals(y);
    }

    public static boolean equals(String ... values) {
        int len = values.length;
        String first = values[0];
        for (int index = 1; index < len; ++index) {
            if (StringUtils.equals(first, values[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(String x, String y) {
        if (x == y) {
            return true;
        }
        return x != null && x.equalsIgnoreCase(y);
    }

    public static boolean equalsIgnoreCase(String ... values) {
        int len = values.length;
        String first = values[0];
        for (int index = 1; index < len; ++index) {
            if (StringUtils.equalsIgnoreCase(first, values[index])) continue;
            return false;
        }
        return true;
    }

    public static String fillPre(String string, String filler, int minCount) {
        if (string.length() >= minCount) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minCount);
        int missing = minCount - string.length();
        if (" ".equals(filler) && missing <= EMPTY_SPACE_STRING.length()) {
            sb.append(EMPTY_SPACE_STRING, 0, missing);
            sb.append(string);
        } else {
            missing = missing / filler.length() + (missing % filler.length() == 0 ? 0 : 1);
            for (int i = 0; i < missing; ++i) {
                sb.append(filler);
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static String fillPost(String string, String filler, int minCount) {
        if (string.length() >= minCount) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minCount);
        int missing = minCount - string.length();
        if (" ".equals(filler) && missing <= EMPTY_SPACE_STRING.length()) {
            sb.append(string);
            sb.append(EMPTY_SPACE_STRING, 0, missing);
            return sb.toString();
        }
        sb.append(string);
        while (sb.length() < minCount) {
            sb.append(filler);
        }
        return sb.toString();
    }

    @Deprecated
    public static String getCommonalities(String a, String b) {
        return StringUtils.getCommonPrefix(a, b);
    }

    public static String toString(NumberFormat c, long number) {
        if (c instanceof DecimalFormat && ((DecimalFormat)c).getDecimalFormatSymbols().getZeroDigit() != '0') {
            return c.format(number);
        }
        return Long.toString(number);
    }

    public static String toString(NumberFormat c, double number) {
        if (c instanceof DecimalFormat && ((DecimalFormat)c).getDecimalFormatSymbols().getZeroDigit() != '0') {
            return c.format(number);
        }
        return Double.toString(number);
    }

    public static String getCommonPrefix(String a, String b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == b) {
            return a;
        }
        int i = 0;
        int aL = a.length();
        int bL = b.length();
        int max = Math.min(aL, bL);
        for (i = 0; i < max && a.charAt(i) == b.charAt(i); ++i) {
        }
        if (i == 0) {
            return "";
        }
        if (i == bL) {
            return b;
        }
        if (i == aL) {
            return a;
        }
        return a.substring(0, i);
    }

    public static String getCommonPostfix(String a, String b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == b) {
            return a;
        }
        int i = 0;
        int aL = a.length();
        int bL = b.length();
        int max = Math.min(aL, bL);
        for (i = 0; i < max && a.charAt(aL - 1 - i) == b.charAt(bL - 1 - i); ++i) {
        }
        if (i == 0) {
            return "";
        }
        if (i == bL) {
            return b;
        }
        if (i == aL) {
            return a;
        }
        return a.substring(aL - i);
    }

    public static String getCommonPrefix(String ... values) {
        String ret = null;
        for (String value : values) {
            if (ret == null) {
                ret = value;
                continue;
            }
            if ((ret = StringUtils.getCommonPrefix(ret, value)) == null) {
                return null;
            }
            if (ret.length() != 0) continue;
            return "";
        }
        return ret;
    }

    public static String getCommonPostfix(String ... values) {
        String ret = null;
        for (String value : values) {
            if (ret == null) {
                ret = value;
                continue;
            }
            if ((ret = StringUtils.getCommonPostfix(ret, value)) == null) {
                return null;
            }
            if (ret.length() != 0) continue;
            return "";
        }
        return ret;
    }

    public static final boolean isEmpty(String value) {
        return value == null || value.length() == 0 || StringUtils.isEmptyAfterTrim(value);
    }

    public static final boolean isEmptyAfterTrim(String value) {
        int st;
        int len = value.length();
        if (len == 0) {
            return true;
        }
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        return st == len;
    }

    public static final boolean isNotEmpty(String value) {
        return !StringUtils.isEmpty(value);
    }

    public static final boolean isAllEmpty(String ... values) {
        if (values != null) {
            for (String value : values) {
                if (value == null || StringUtils.isEmptyAfterTrim(value)) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isAllNotEmpty(String ... values) {
        if (values != null) {
            for (String value : values) {
                if (!StringUtils.isEmpty(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static String join(Object[] parameters, String separator) {
        return new Joiner(separator){

            @Override
            protected void addSeparator(int index, Object element, Object[] parameters, StringBuilder sb) {
                if (sb.length() > 0) {
                    sb.append(this.getSeparator(index, element, parameters, sb));
                }
            }
        }.join(parameters);
    }

    @Deprecated
    public static String join(String separator, Object ... parameters) {
        return StringUtils.join(parameters, separator);
    }

    @Deprecated
    public static String join(Collection<? extends Object> params, String separator) {
        return StringUtils.join(params.toArray(new Object[0]), separator);
    }

    @Deprecated
    public static <T> String join(Collection<T> params, String separator, final Stringifier<T> stringifier) {
        return new Joiner(separator){

            @Override
            protected String elementToString(Object s) {
                return stringifier.toString(s);
            }

            @Override
            protected boolean skip(Object s) {
                return this.elementToString(s) == null;
            }

            @Override
            protected void addSeparator(int index, Object element, Object[] parameters, StringBuilder sb) {
                if (sb.length() > 0) {
                    sb.append(this.getSeparator(index, element, parameters, sb));
                }
            }
        }.join(params);
    }

    public static List<String> createList(String string, int length) {
        ArrayList<String> ret = new ArrayList<String>(length);
        while (length-- > 0) {
            ret.add(string);
        }
        return ret;
    }

    public static String replaceAllByRegex(String regex, String replacement, String text) {
        if (text == null) {
            return text;
        }
        return text.replaceAll(regex, replacement);
    }

    public static String abr(String defaultMessage, int max, String postfox) {
        if (defaultMessage == null) {
            return null;
        }
        if (defaultMessage.length() <= max) {
            return defaultMessage;
        }
        return defaultMessage.substring(0, max) + postfox;
    }

    public static String toCamelCase(String name, boolean firstUpper) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        boolean firstFlag = true;
        for (String p : name.split("[\\_\\-\\s]+")) {
            if (p.length() <= 0) continue;
            String first = p.substring(0, 1);
            if (firstFlag) {
                if (firstUpper) {
                    sb.append(first.toUpperCase(Locale.ENGLISH));
                } else {
                    sb.append(first.toLowerCase(Locale.ENGLISH));
                }
                firstFlag = false;
            } else {
                sb.append(first.toUpperCase(Locale.ENGLISH));
            }
            sb.append(p, 1, p.length());
        }
        return sb.toString();
    }

    public static String shareAtLeastOne(String[] xArray, String[] yArray, boolean caseInsensitive) {
        if (xArray == null || yArray == null || xArray.length == 0 || yArray.length == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String x : xArray) {
            if (caseInsensitive) {
                set.add(x.toLowerCase(Locale.ENGLISH));
                continue;
            }
            set.add(x);
        }
        for (String y : yArray) {
            boolean contains = caseInsensitive ? set.contains(y.toLowerCase(Locale.ENGLISH)) : set.contains(y);
            if (!contains) continue;
            return y;
        }
        return null;
    }

    public static String[] splitNoEmpty(String value, String delim) {
        if (value == null) {
            return new String[0];
        }
        String[] splits = value.split(delim);
        ArrayList<String> ret = new ArrayList<String>(splits.length);
        for (String split : splits) {
            if (!StringUtils.isNotEmpty(split)) continue;
            ret.add(split);
        }
        return ret.toArray(new String[0]);
    }

    public static String firstNotEmpty(String ... entries) {
        for (String s : entries) {
            if (!StringUtils.isNotEmpty(s)) continue;
            return s;
        }
        return null;
    }

    protected static int getPadLengthFast(int n) {
        if (n < 100000) {
            if (n < 100) {
                if (n < 10) {
                    return 1;
                }
                return 2;
            }
            if (n < 1000) {
                return 3;
            }
            if (n < 10000) {
                return 4;
            }
            return 5;
        }
        if (n < 10000000) {
            if (n < 1000000) {
                return 6;
            }
            return 7;
        }
        if (n < 100000000) {
            return 8;
        }
        if (n < 1000000000) {
            return 9;
        }
        return 10;
    }

    public static int getPadLength(int num) {
        if (num >= 0) {
            return StringUtils.getPadLengthFast(num);
        }
        throw new IllegalArgumentException("num must be >=0!:" + num);
    }

    public static String valueOfOrNull(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static String toUpperCaseOrNull(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.toUpperCase(locale);
    }

    public static String toUpperCaseOrNull(String value) {
        return StringUtils.toUpperCaseOrNull(value, Locale.ENGLISH);
    }

    public static String toLowerCaseOrNull(String value, Locale locale) {
        if (value == null) {
            return null;
        }
        return value.toLowerCase(locale);
    }

    public static String toLowerCaseOrNull(String value) {
        return StringUtils.toLowerCaseOrNull(value, Locale.ENGLISH);
    }

    public static String camelCaseToUnderscore(String key, boolean uppercase) {
        StringBuilder staticKey = new StringBuilder(key.length());
        char lastc = ' ';
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (staticKey.length() > 0 && Character.isUpperCase(c) && Character.isLowerCase(lastc)) {
                staticKey.append('_');
            }
            staticKey.append(uppercase ? Character.toUpperCase(c) : Character.toLowerCase(c));
            lastc = c;
        }
        return staticKey.toString();
    }

    public static ArrayList<CharSequence> camelCaseSplit(CharSequence key) {
        ArrayList<CharSequence> ret = new ArrayList<CharSequence>();
        char lastc = ' ';
        int offset = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isUpperCase(c) && Character.isLowerCase(lastc)) {
                ret.add(key.subSequence(offset, i));
                offset = i;
            }
            lastc = c;
        }
        if (offset < key.length()) {
            ret.add(key.subSequence(offset, key.length()));
        }
        return ret;
    }

    public static String wrapText(String trim, int size) {
        return StringUtils.wrapText(trim, size, null, null, true);
    }

    public static String wrapText(String stringToWrap, int maxCharsPerLine, String patternWrapBefore, String patternWrapAfter, boolean forceWrapLongWords) {
        if (maxCharsPerLine == 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        Pattern patBefore = patternWrapBefore == null ? DEFAULT_WRAP_BEFORE : Pattern.compile(patternWrapBefore);
        Pattern paAfter = patternWrapAfter == null ? DEFAULT_WRAP_AFTER : Pattern.compile(patternWrapAfter);
        return StringUtils.wrap(stringToWrap, maxCharsPerLine, forceWrapLongWords, patBefore, paAfter);
    }

    public static String wrap(String stringToWrap, int maxCharsPerLine, boolean forceWrapLongWords, Pattern patternBefore, Pattern patternAfter) {
        if (maxCharsPerLine == 0) {
            throw new IllegalArgumentException("Size must be > 0");
        }
        ReferencedCharArrayCharSequence value = new ReferencedCharArrayCharSequence(stringToWrap);
        return StringUtils.wrapInternal(value, new StringBuilder(), maxCharsPerLine, forceWrapLongWords, NEWLINE, patternBefore, patternAfter).toString();
    }

    private static StringBuilder wrapInternal(ReferencedCharArrayCharSequence input, StringBuilder output, int maxCharsPerLine, boolean forceWrapLongWords, Pattern patternNewline, Pattern patternBefore, Pattern patternAfter) {
        boolean appendNewLine;
        Matcher newLineMatcherInstance = patternNewline == null ? null : patternNewline.matcher("");
        Matcher matcherBeforeInstance = patternBefore == null ? null : patternBefore.matcher("");
        Matcher matcherAfterInstance = patternAfter == null ? null : patternAfter.matcher("");
        boolean bl = appendNewLine = output.length() > 0;
        while (input.length() > 0) {
            int replaceBeforeLength;
            int last;
            int splitAfterAt;
            int splitBeforeAt;
            block28: {
                if (newLineMatcherInstance != null) {
                    if (newLineMatcherInstance.reset(input).find()) {
                        int start = newLineMatcherInstance.start();
                        if (start <= maxCharsPerLine) {
                            if (appendNewLine) {
                                output.append("\r\n");
                                input.appendTo(output, start);
                            } else {
                                input.appendTo(output, start);
                                appendNewLine = output.length() > 0;
                            }
                        } else {
                            ReferencedCharArrayCharSequence subSequence = input.subSequence(0, start);
                            StringUtils.wrapInternal(subSequence, output, maxCharsPerLine, forceWrapLongWords, null, patternBefore, patternAfter);
                            if (!appendNewLine) {
                                appendNewLine = output.length() > 0;
                            }
                        }
                        input = input.subSequence(newLineMatcherInstance.end(), input.length());
                        continue;
                    }
                    newLineMatcherInstance = null;
                }
                if (input.length() < maxCharsPerLine) {
                    if (appendNewLine) {
                        output.append("\r\n");
                    }
                    input.appendTo(output, input.length);
                    return output;
                }
                splitBeforeAt = 0;
                splitAfterAt = 0;
                last = 0;
                replaceBeforeLength = -1;
                if (matcherBeforeInstance != null) {
                    int start;
                    int end;
                    matcherBeforeInstance.reset(input);
                    do {
                        if (!matcherBeforeInstance.find()) {
                            matcherBeforeInstance = null;
                            break block28;
                        }
                        start = matcherBeforeInstance.start();
                        if (start > maxCharsPerLine) {
                            if (last == 0 && !forceWrapLongWords) {
                                replaceBeforeLength = -1;
                                splitBeforeAt = start;
                            } else {
                                splitBeforeAt = last;
                            }
                            break block28;
                        }
                        replaceBeforeLength = -1;
                        int gc = matcherBeforeInstance.groupCount();
                        for (int i = 1; i < gc + 1; ++i) {
                            int groupStart = matcherBeforeInstance.start(i);
                            int groupEnd = matcherBeforeInstance.end(i);
                            if (groupStart == -1 || groupEnd == -1) continue;
                            replaceBeforeLength = groupEnd - groupStart;
                            break;
                        }
                        last = start;
                    } while ((end = matcherBeforeInstance.end()) != input.length());
                    splitBeforeAt = start;
                }
            }
            splitBeforeAt = last;
            last = 0;
            if (matcherAfterInstance != null && patternAfter != DEFAULT_WRAP_AFTER) {
                matcherAfterInstance.reset(input);
                while (true) {
                    if (!matcherAfterInstance.find()) {
                        matcherAfterInstance = null;
                        break;
                    }
                    int end = matcherAfterInstance.end();
                    if (end > maxCharsPerLine || end == input.length()) {
                        if (last == 0 && !forceWrapLongWords) {
                            splitAfterAt = end;
                            break;
                        }
                        splitAfterAt = last;
                        break;
                    }
                    last = end;
                }
            }
            splitAfterAt = last;
            int splitAT = Math.max(splitAfterAt, splitBeforeAt);
            if (splitAfterAt > maxCharsPerLine && splitBeforeAt <= maxCharsPerLine) {
                splitAT = splitBeforeAt;
            }
            if (splitBeforeAt > maxCharsPerLine && splitAfterAt <= maxCharsPerLine) {
                splitAT = splitAfterAt;
            }
            if (splitAT == 0) {
                splitAT = forceWrapLongWords ? maxCharsPerLine : input.length();
            }
            splitAT = Math.min(splitAT, input.length());
            if (appendNewLine) {
                output.append("\r\n");
                input.appendTo(output, splitAT);
            } else {
                input.appendTo(output, splitAT);
                boolean bl2 = appendNewLine = output.length() > 0;
            }
            if (replaceBeforeLength > 0 && splitAT == splitBeforeAt) {
                splitAT += replaceBeforeLength;
            }
            input = input.subSequence(splitAT, input.length());
        }
        return output;
    }

    public static String multiLineIntend(String text, String ... intends) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = Pattern.compile("(\r\n)|(\r)|(\n)").matcher(text);
        int offset = 0;
        int lineCount = 0;
        while (matcher.find()) {
            sb.append(intends[Math.min(intends.length - 1, lineCount)]);
            sb.append(text, offset, matcher.start());
            sb.append(text, matcher.start(0), matcher.end(0));
            offset = matcher.end();
            ++lineCount;
        }
        sb.append(intends[Math.min(intends.length - 1, lineCount)]);
        sb.append(text, offset, text.length());
        return sb.toString();
    }

    public static String underscoreToCamelCase(String underscore) {
        StringBuilder staticKey = new StringBuilder(underscore.length());
        boolean nextUpper = false;
        for (int i = 0; i < underscore.length(); ++i) {
            char c = underscore.charAt(i);
            if (c == '_') {
                nextUpper = true;
                continue;
            }
            staticKey.append(nextUpper ? Character.toUpperCase(c) : Character.toLowerCase(c));
            nextUpper = false;
        }
        return staticKey.toString();
    }

    public static List<String> listWithoutEmptyStrings(String ... strings) {
        ArrayList<String> ret = new ArrayList<String>(strings.length);
        for (String s : strings) {
            if (!StringUtils.isNotEmpty(s)) continue;
            ret.add(s);
        }
        return ret;
    }

    public static String upperLowerAfterRegex(String pattern, String string, Boolean firstUpper, Boolean restUpper) {
        String[] split = string.split("((?<=" + pattern + "))");
        StringBuilder sb = new StringBuilder(string.length());
        for (String s : split) {
            if (s.length() == 0) continue;
            if (firstUpper == Boolean.TRUE) {
                sb.append(s.substring(0, 1).toUpperCase(Locale.ROOT));
            } else if (firstUpper == Boolean.FALSE) {
                sb.append(s.substring(0, 1).toLowerCase(Locale.ROOT));
            } else {
                sb.append(s, 0, 1);
            }
            if (s.length() <= 1) continue;
            if (restUpper == Boolean.TRUE) {
                String upperCase = s.toUpperCase(Locale.ROOT);
                sb.append(upperCase, 1, upperCase.length());
                continue;
            }
            if (restUpper == Boolean.FALSE) {
                String lowerCase = s.toLowerCase(Locale.ROOT);
                sb.append(lowerCase, 1, lowerCase.length());
                continue;
            }
            sb.append(s, 1, s.length());
        }
        return sb.toString();
    }

    public static int indexOf(String input, String regex) {
        return StringUtils.indexOf(input, Pattern.compile(regex));
    }

    public static int indexOf(String input, int fromIndex, Pattern regex) {
        if (fromIndex >= input.length()) {
            return -1;
        }
        Matcher matcher = regex.matcher(input);
        if (fromIndex <= 0) {
            fromIndex = 0;
        }
        if (!matcher.find(fromIndex)) {
            return -1;
        }
        int ret = matcher.start();
        return ret;
    }

    public static int indexOf(String input, Pattern regex) {
        return StringUtils.indexOf(input, 0, regex);
    }

    public static int damerauLevenshtein(CharSequence source, CharSequence target) {
        int i;
        if (source == null || target == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        int sourceLength = source.length();
        int targetLength = target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        int[][] dist = new int[sourceLength + 1][targetLength + 1];
        for (i = 0; i < sourceLength + 1; ++i) {
            dist[i][0] = i;
        }
        for (int j = 0; j < targetLength + 1; ++j) {
            dist[0][j] = j;
        }
        for (i = 1; i < sourceLength + 1; ++i) {
            for (int j = 1; j < targetLength + 1; ++j) {
                int cost = source.charAt(i - 1) == target.charAt(j - 1) ? 0 : 1;
                dist[i][j] = Math.min(Math.min(dist[i - 1][j] + 1, dist[i][j - 1] + 1), dist[i - 1][j - 1] + cost);
                if (i <= 1 || j <= 1 || source.charAt(i - 1) != target.charAt(j - 2) || source.charAt(i - 2) != target.charAt(j - 1)) continue;
                dist[i][j] = Math.min(dist[i][j], dist[i - 2][j - 2] + cost);
            }
        }
        return dist[sourceLength][targetLength];
    }

    public static int levenshtein(String strA, String strB, boolean caseINsensitive) {
        int i;
        if (caseINsensitive) {
            strA = strA.toLowerCase(Locale.ROOT);
            strB = strB.toLowerCase(Locale.ROOT);
        }
        int[] costs = new int[strB.length() + 1];
        for (i = 0; i < costs.length; ++i) {
            costs[i] = i;
        }
        for (i = 1; i <= strA.length(); ++i) {
            int weigther = i - 1;
            costs[0] = i;
            for (int ii = 1; ii <= strB.length(); ++ii) {
                int cj = Math.min(1 + Math.min(costs[ii], costs[ii - 1]), strA.charAt(i - 1) == strB.charAt(ii - 1) ? weigther : weigther + 1);
                weigther = costs[ii];
                costs[ii] = cj;
            }
        }
        return costs[strB.length()];
    }

    public static String joinNonEmpty(String separator, String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String s : parts) {
            if (StringUtils.isEmpty(s)) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static int getMaxLength(String ... strings) {
        int ret = 0;
        for (String s : strings) {
            ret = Math.max(s.length(), ret);
        }
        return ret;
    }

    public static String firstUp(String join) {
        if (join == null) {
            return null;
        }
        if ((join = join.trim()).length() == 0) {
            return join;
        }
        if (Character.isUpperCase(join.charAt(0))) {
            return join;
        }
        return join.substring(0, 1).toUpperCase(Locale.ROOT) + join.substring(1);
    }

    static {
        DEFAULT_WRAP_AFTER = MATCHES_NEVER = Pattern.compile("$^");
    }

    private static final class ReferencedCharArrayCharSequence
    implements CharSequence {
        private final char[] value;
        private final int offset;
        private final int length;

        private ReferencedCharArrayCharSequence(CharSequence charSequence) {
            int length = charSequence.length();
            this.value = new char[length];
            charSequence.toString().getChars(0, length, this.value, 0);
            this.offset = 0;
            this.length = length;
        }

        private ReferencedCharArrayCharSequence(int offset, int start, int end, char[] value) {
            this.value = value;
            this.offset = offset + start;
            this.length = end - start;
        }

        @Override
        public final int length() {
            return this.length;
        }

        protected final void appendTo(StringBuilder sb, int length) {
            sb.append(this.value, this.offset, length);
        }

        @Override
        public final String toString() {
            return new String(this.value, this.offset, this.length);
        }

        @Override
        public final char charAt(int index) {
            return this.value[index + this.offset];
        }

        @Override
        public final ReferencedCharArrayCharSequence subSequence(int start, int end) {
            return new ReferencedCharArrayCharSequence(this.offset, start, end, this.value);
        }
    }

    public static interface Stringifier<T> {
        public String toString(T var1);
    }
}

