/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

public class HTTPHeader {
    public static final byte[] DELIMINATOR = ": ".getBytes();
    public static final HTTPHeader CONTENT_TYPE_TEXT_UTF8 = new HTTPHeader("Content-Type", "text; charset=utf-8");
    private final String key;
    private final String value;
    private final boolean allowOverwrite;

    public HTTPHeader(String key, String value) {
        this(key, value, true);
    }

    public HTTPHeader(String key, String value, boolean overwriteAllowed) {
        this.key = key;
        this.value = value;
        this.allowOverwrite = overwriteAllowed;
    }

    public boolean contains(String string) {
        String local = this.getValue();
        return local != null && local.contains(string);
    }

    public boolean matches(String matches) {
        String local = this.getValue();
        return local != null && local.matches(matches);
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKey());
        sb.append(": ");
        sb.append(this.getValue());
        return sb.toString();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAllowOverwrite() {
        return this.allowOverwrite;
    }

    public String toString() {
        return "HTTP Header: " + this.getKey() + "= " + this.getValue();
    }
}

