/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import org.appwork.utils.ByteArrayUtils;

public enum RequestMethod {
    NOTIFY(true),
    MSEARCH("M-SEARCH", false),
    SUBSCRIBE(false),
    UNSUBSCRIBE(false),
    PUT(true),
    DELETE(false),
    OPTIONS(false),
    GET(false),
    POST(true),
    HEAD(false),
    PROPFIND(true),
    TRACE(false),
    CONNECT(false),
    PATCH(true),
    PROPPATCH(true),
    MKCOL(false),
    COPY(false),
    MOVE(false),
    LOCK(true),
    UNLOCK(false),
    UNKNOWN(false);

    public final boolean mayHavePostBody;
    private final byte[] requestMethodBytes;

    private RequestMethod(boolean requiresOutputStream) {
        this(null, requiresOutputStream);
    }

    private RequestMethod(String methodName, boolean requiresOutputStream) {
        this.mayHavePostBody = requiresOutputStream;
        String methodNameString = methodName != null ? methodName : this.name();
        byte[] bytes = null;
        try {
            bytes = methodNameString.getBytes("ISO-8859-1");
        }
        catch (Throwable e) {
            bytes = methodNameString.getBytes();
        }
        this.requestMethodBytes = bytes;
    }

    private boolean isRequestMethod(byte[] input) {
        byte nextByte;
        if (input == null) {
            return false;
        }
        if (!ByteArrayUtils.contains(input, 0, this.requestMethodBytes)) {
            return false;
        }
        return input.length <= this.requestMethodBytes.length || (nextByte = input[this.requestMethodBytes.length]) == 32 || nextByte == 9 || nextByte == 13 || nextByte == 10;
    }

    public static RequestMethod get(byte[] guessProtocolBuffer) {
        if (guessProtocolBuffer == null || guessProtocolBuffer.length == 0) {
            return UNKNOWN;
        }
        for (RequestMethod method : RequestMethod.values()) {
            if (method == UNKNOWN || !method.isRequestMethod(guessProtocolBuffer)) continue;
            return method;
        }
        return UNKNOWN;
    }
}

