/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.HeaderCollection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpserver.EmptyRequestException;
import org.appwork.utils.net.httpserver.HttpConnectionExceptionHandler;
import org.appwork.utils.net.httpserver.HttpConnectionRunnable;
import org.appwork.utils.net.httpserver.HttpServer;
import org.appwork.utils.net.httpserver.OutputStreamIsAlreadyInUseException;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.handler.ExtendedHttpRequestHandler;
import org.appwork.utils.net.httpserver.handler.HttpProxyHandler;
import org.appwork.utils.net.httpserver.handler.HttpRequestHandler;
import org.appwork.utils.net.httpserver.requests.ConnectRequest;
import org.appwork.utils.net.httpserver.requests.DeleteRequest;
import org.appwork.utils.net.httpserver.requests.GetRequest;
import org.appwork.utils.net.httpserver.requests.HeadRequest;
import org.appwork.utils.net.httpserver.requests.HttpRequest;
import org.appwork.utils.net.httpserver.requests.KeyValuePair;
import org.appwork.utils.net.httpserver.requests.OptionsRequest;
import org.appwork.utils.net.httpserver.requests.PostRequest;
import org.appwork.utils.net.httpserver.requests.PutRequest;
import org.appwork.utils.net.httpserver.responses.HttpResponse;

public class HttpConnection
implements HttpConnectionRunnable,
RawHttpConnectionInterface {
    protected final HttpServer server;
    protected final Socket clientSocket;
    protected boolean outputStreamInUse = false;
    protected HttpResponse response = null;
    protected final InputStream is;
    protected final OutputStream os;
    protected HttpRequest request;
    private static final Pattern METHOD = Pattern.compile("(GET|POST|HEAD|OPTIONS|CONNECT)");
    private static final Pattern REQUESTLINE = Pattern.compile("\\s+(.+)\\s+HTTP/");
    public static final Pattern REQUESTURL = Pattern.compile("^(/.*?)($|\\?)");
    public static final Pattern REQUESTPARAM = Pattern.compile("^/.*?\\?(.+)");
    private ConnectionHook hook;

    public static List<KeyValuePair> parseParameterList(String requestedParameters) throws IOException {
        LinkedList<KeyValuePair> requestedURLParameters = new LinkedList<KeyValuePair>();
        if (!StringUtils.isEmpty(requestedParameters)) {
            String[] parameters;
            for (String parameter : parameters = requestedParameters.split("\\&(?!#)", -1)) {
                String[] params = parameter.split("=", 2);
                if (params.length == 1) {
                    requestedURLParameters.add(new KeyValuePair(null, URLDecoder.decode(params[0], "UTF-8")));
                    continue;
                }
                if ("_".equals(params[0])) continue;
                requestedURLParameters.add(new KeyValuePair(URLDecoder.decode(params[0], "UTF-8"), URLDecoder.decode(params[1], "UTF-8")));
            }
        }
        return requestedURLParameters;
    }

    protected HttpConnection(HttpServer server, Socket clientSocket, InputStream is, OutputStream os) throws IOException {
        this.server = server;
        this.clientSocket = clientSocket;
        this.is = is == null ? clientSocket.getInputStream() : is;
        this.os = os == null ? clientSocket.getOutputStream() : os;
        if (clientSocket != null) {
            this.clientSocket.setSoTimeout(60000);
        }
    }

    @Override
    public Socket getClientSocket() {
        return this.clientSocket;
    }

    protected HttpConnection() {
        this.server = null;
        this.clientSocket = null;
        this.is = null;
        this.os = null;
    }

    public HttpConnection(HttpServer server, Socket clientSocket) throws IOException {
        this(server, clientSocket, null, null);
    }

    protected HttpRequest buildGetRequest() throws IOException {
        return new GetRequest(this);
    }

    protected HttpRequest buildHeadRequest() throws IOException {
        return new HeadRequest(this);
    }

    protected HttpRequest buildOptionsRequest() throws IOException {
        return new OptionsRequest(this);
    }

    protected HttpRequest buildConnectRequest() throws IOException {
        return new ConnectRequest(this);
    }

    protected HttpRequest buildPostRequest() throws IOException {
        return new PostRequest(this);
    }

    protected HttpRequest buildPutRequest() throws IOException {
        return new PutRequest(this);
    }

    protected HttpRequest buildDeleteRequest() throws IOException {
        return new DeleteRequest(this);
    }

    protected HttpRequest buildRequest() throws IOException {
        HttpRequest request;
        String requestLine = this.parseRequestLine();
        if (StringUtils.isEmpty(requestLine)) {
            throw new EmptyRequestException();
        }
        HttpConnectionType connectionType = this.parseConnectionType(requestLine);
        if (connectionType == HttpConnectionType.UNKNOWN) {
            throw new IOException("Unsupported " + requestLine);
        }
        String requestedURL = new Regex(requestLine, REQUESTLINE).getMatch(0);
        String requestedPath = new Regex(requestedURL, REQUESTURL).getMatch(0);
        List<KeyValuePair> requestedURLParameters = this.parseRequestURLParams(requestedURL);
        HeaderCollection requestHeaders = this.parseRequestHeaders();
        switch (connectionType) {
            case CONNECT: {
                request = this.buildConnectRequest();
                break;
            }
            case POST: {
                request = this.buildPostRequest();
                break;
            }
            case GET: {
                request = this.buildGetRequest();
                break;
            }
            case OPTIONS: {
                request = this.buildOptionsRequest();
                break;
            }
            case HEAD: {
                request = this.buildHeadRequest();
                break;
            }
            case PUT: {
                request = this.buildPutRequest();
                break;
            }
            case DELETE: {
                request = this.buildDeleteRequest();
                break;
            }
            default: {
                throw new IOException("Unsupported " + requestLine);
            }
        }
        if (request == null) {
            throw new IOException("Unsupported " + requestLine);
        }
        request.setBridge(this.server);
        request.setRemoteAddress(this.getRemoteAddress(requestHeaders));
        request.setRequestedURLParameters(requestedURLParameters);
        request.setRequestedPath(requestedPath);
        request.setRequestedURL(requestedURL);
        request.setRequestHeaders(requestHeaders);
        return request;
    }

    protected HttpResponse buildResponse() throws IOException {
        return new HttpResponse(this);
    }

    @Override
    public boolean closableStreams() {
        return this.clientSocket == null;
    }

    @Override
    public void close() {
    }

    @Override
    public void closeConnection() {
        if (this.clientSocket != null) {
            try {
                this.clientSocket.shutdownOutput();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.clientSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected boolean deferRequest(HttpRequest request) throws Exception {
        return false;
    }

    public List<HttpRequestHandler> getHandler() {
        return this.server.getHandler();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getRawInputStream();
    }

    @Override
    public OutputStream getOutputStream(boolean sendResponseHeaders) throws IOException {
        if (sendResponseHeaders) {
            this.openOutputStream();
        }
        return this.getRawOutputStream();
    }

    protected InputStream getRawInputStream() throws IOException {
        if (this.is == null) {
            throw new IllegalStateException("no RawInputStream available!");
        }
        return this.is;
    }

    protected OutputStream getRawOutputStream() throws IOException {
        if (this.os == null) {
            throw new IllegalStateException("no RawOutputStream available!");
        }
        return this.os;
    }

    protected List<String> getRemoteAddress(HeaderCollection requestHeaders) {
        HTTPHeader forwardedFor;
        ArrayList<String> remoteAddress = new ArrayList<String>();
        if (this.clientSocket != null) {
            remoteAddress.add(this.clientSocket.getInetAddress().getHostAddress());
        }
        if ((forwardedFor = requestHeaders.get("X-Forwarded-For")) != null && !StringUtils.isEmpty(forwardedFor.getValue())) {
            String[] addresses;
            for (String ip : addresses = forwardedFor.getValue().split(", ")) {
                remoteAddress.add(ip.trim());
            }
        }
        return remoteAddress;
    }

    @Override
    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public boolean isOutputStreamInUse() {
        return this.outputStreamInUse;
    }

    public boolean onException(Throwable e, HttpRequest request, HttpResponse response) throws IOException {
        if (Exceptions.containsInstanceOf(e, SocketException.class, ClosedChannelException.class)) {
            return true;
        }
        if (e instanceof HttpConnectionExceptionHandler) {
            return ((HttpConnectionExceptionHandler)((Object)e)).handle(response);
        }
        if (request != null) {
            this.response = new HttpResponse(this);
            this.response.setResponseCode(HTTPConstants.ResponseCode.SERVERERROR_INTERNAL);
            byte[] bytes = Exceptions.getStackTrace(e).getBytes("UTF-8");
            this.response.getResponseHeaders().add(new HTTPHeader("Content-Type", "text; charset=UTF-8"));
            this.response.getResponseHeaders().add(new HTTPHeader("Content-Length", bytes.length + ""));
            this.response.getOutputStream(true).write(bytes);
            this.response.getOutputStream(true).flush();
            return true;
        }
        return true;
    }

    protected void onUnhandled(HttpRequest request, HttpResponse response) throws IOException {
        response.setResponseCode(HTTPConstants.ResponseCode.SERVERERROR_NOT_IMPLEMENTED);
    }

    protected HttpConnectionType parseConnectionType(String requestLine) throws IOException {
        String method = new Regex(requestLine, METHOD).getMatch(0);
        try {
            return HttpConnectionType.valueOf(method);
        }
        catch (Exception e) {
            return HttpConnectionType.UNKNOWN;
        }
    }

    protected HeaderCollection parseRequestHeaders() throws IOException {
        String[] headerStrings;
        ByteBuffer headers = this.readRequestHeaders();
        if (headers.hasArray()) {
            headerStrings = new String(headers.array(), headers.arrayOffset(), headers.limit(), "ISO-8859-1").split("(\r\n)|(\n)");
        } else {
            byte[] bytesHeaders = new byte[headers.limit()];
            headers.get(bytesHeaders);
            headerStrings = new String(bytesHeaders, "ISO-8859-1").split("(\r\n)|(\n)");
        }
        HeaderCollection requestHeaders = new HeaderCollection();
        for (String line : headerStrings) {
            String key = null;
            String value = null;
            int index = 0;
            index = line.indexOf(": ");
            if (index > 0) {
                key = line.substring(0, index);
                value = line.substring(index + 2);
            } else {
                index = line.indexOf(":");
                if (index > 0) {
                    key = line.substring(0, index);
                    value = line.substring(index + 1);
                } else {
                    key = null;
                    value = line;
                }
            }
            requestHeaders.add(new HTTPHeader(key, value));
        }
        return requestHeaders;
    }

    protected String parseRequestLine() throws IOException {
        ByteBuffer header = this.readRequestLine();
        if (header.hasArray()) {
            return this.preProcessRequestLine(new String(header.array(), header.arrayOffset(), header.limit(), "ISO-8859-1").trim());
        }
        byte[] bytesRequestLine = new byte[header.limit()];
        header.get(bytesRequestLine);
        return this.preProcessRequestLine(new String(bytesRequestLine, "ISO-8859-1").trim());
    }

    protected List<KeyValuePair> parseRequestURLParams(String requestURL) throws IOException {
        return HttpConnection.parseParameterList(new Regex(requestURL, REQUESTPARAM).getMatch(0));
    }

    protected String preProcessRequestLine(String requestLine) throws IOException {
        return requestLine;
    }

    protected ByteBuffer readRequestHeaders() throws IOException {
        return HTTPConnectionUtils.readheader(this.getInputStream(), false);
    }

    protected ByteBuffer readRequestLine() throws IOException {
        return HTTPConnectionUtils.readheader(this.getInputStream(), true);
    }

    protected boolean isProxyRequest(HttpRequest request) {
        if (request != null) {
            return request instanceof ConnectRequest || StringUtils.startsWithCaseInsensitive(request.getRequestedURL(), "http://") || StringUtils.startsWithCaseInsensitive(request.getRequestedURL(), "https://");
        }
        return false;
    }

    protected boolean isPostRequest(HttpRequest request) {
        return request instanceof PostRequest;
    }

    protected boolean isGetRequest(HttpRequest request) {
        return request instanceof GetRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean closeConnection = true;
        try {
            HttpRequest request;
            if (this.request == null) {
                this.request = this.buildRequest();
            }
            if (this.response == null) {
                this.response = this.buildResponse();
            }
            if (this.deferRequest(request = this.request)) {
                closeConnection = false;
            } else {
                boolean handled = false;
                boolean isPostRequest = this.isPostRequest(request);
                boolean isGetRequest = this.isGetRequest(request);
                boolean isProxyRequest = this.isProxyRequest(request);
                HttpResponse response = this.response;
                for (HttpRequestHandler handler : this.getHandler()) {
                    ExtendedHttpRequestHandler extendedHandler = handler instanceof ExtendedHttpRequestHandler ? (ExtendedHttpRequestHandler)((Object)handler) : null;
                    try {
                        if (extendedHandler != null) {
                            extendedHandler.onBeforeRequest(request, response);
                        }
                        if (isPostRequest) {
                            handled = handler.onPostRequest((PostRequest)request, response);
                        } else if (isGetRequest) {
                            handled = handler.onGetRequest((GetRequest)request, response);
                        } else if (isProxyRequest) {
                            handled = ((HttpProxyHandler)handler).onProxyConnectRequest(request, response);
                        }
                        if (extendedHandler != null) {
                            extendedHandler.onAfterRequest(request, response, handled);
                        }
                        if (!handled) continue;
                        break;
                    }
                    catch (Throwable e) {
                        if (extendedHandler != null) {
                            extendedHandler.onAfterRequestException(request, response, e);
                        }
                        throw e;
                    }
                }
                if (!handled) {
                    this.onUnhandled(request, response);
                }
                response.getOutputStream(true);
            }
        }
        catch (Throwable e) {
            try {
                closeConnection = this.onException(e, this.request, this.response);
            }
            catch (Throwable nothing) {
                e.printStackTrace();
                nothing.printStackTrace();
            }
        }
        finally {
            if (closeConnection) {
                this.closeConnection();
                this.close();
            }
        }
    }

    @Override
    public ConnectionHook getHook() {
        return this.hook;
    }

    @Override
    public void setHook(ConnectionHook hook) {
        this.hook = hook;
    }

    protected void openOutputStream() throws IOException {
        if (this.isOutputStreamInUse()) {
            throw new OutputStreamIsAlreadyInUseException("OutputStream is already in use!");
        }
        if (this.response != null) {
            try {
                OutputStream out = this.getRawOutputStream();
                ConnectionHook lHook = this.hook;
                if (lHook != null) {
                    lHook.onBeforeSendHeaders(this.response);
                }
                this.openOutputStream(out, this.response);
            }
            finally {
                this.setOutputStreamInUse(true);
            }
        }
    }

    protected void openOutputStream(OutputStream out, HttpResponse response) throws IOException {
        out.write(HttpResponse.HTTP11);
        out.write(response.getResponseCode().getBytes());
        out.write(HttpResponse.NEWLINE);
        for (HTTPHeader h : this.response.getResponseHeaders()) {
            if (h.getValue() == null) continue;
            out.write(h.getKey().getBytes("ISO-8859-1"));
            out.write(HTTPHeader.DELIMINATOR);
            out.write(h.getValue().getBytes("ISO-8859-1"));
            out.write(HttpResponse.NEWLINE);
        }
        out.write(HttpResponse.NEWLINE);
        out.flush();
    }

    protected void setOutputStreamInUse(boolean outputStreamInUse) {
        this.outputStreamInUse = outputStreamInUse;
    }

    public String toString() {
        if (this.clientSocket != null) {
            return "HttpConnectionThread: " + this.clientSocket.toString();
        }
        return "HttpConnectionThread: IS and OS";
    }

    public static interface ConnectionHook {
        public void onBeforeSendHeaders(HttpResponse var1);
    }

    public static enum HttpConnectionType {
        DELETE,
        CONNECT,
        PUT,
        HEAD,
        GET,
        POST,
        OPTIONS,
        UNKNOWN;

        private final byte[] requestTypeBytes;

        private HttpConnectionType() {
            byte[] bytes = null;
            try {
                bytes = this.name().getBytes("ISO-8859-1");
            }
            catch (Throwable e) {
                bytes = this.name().getBytes();
            }
            this.requestTypeBytes = bytes;
        }

        public final boolean isRequestType(byte[] input) {
            if (input.length < this.requestTypeBytes.length) {
                return false;
            }
            for (int i = 0; i < this.requestTypeBytes.length; ++i) {
                if (this.requestTypeBytes[i] == input[i]) continue;
                return false;
            }
            return true;
        }

        public static HttpConnectionType get(byte[] input) {
            for (HttpConnectionType type : HttpConnectionType.values()) {
                if (!type.isRequestType(input)) continue;
                return type;
            }
            return UNKNOWN;
        }

        public final int length() {
            return this.requestTypeBytes.length;
        }
    }
}

