/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.tests;

import org.appwork.testframework.AWTest;
import org.appwork.utils.Application;
import org.appwork.utils.net.PublicSuffixList;

public class PublicSuffixListTest
extends AWTest {
    public static void main(String[] args) {
        PublicSuffixListTest.run();
    }

    @Override
    public void runTest() throws Exception {
        PublicSuffixList suffixList = PublicSuffixList.getInstance();
        PublicSuffixListTest.assertNotNull(Application.getRessourceURL("org/appwork/utils/net/effective_tld_names.dat"));
        PublicSuffixListTest.assertEquals("example.net", suffixList.getDomain("example.net"));
        PublicSuffixListTest.assertEquals("example.net", suffixList.getDomain("www.example.net"));
        PublicSuffixListTest.assertEquals("www", suffixList.getSubDomain("www.example.net"));
        PublicSuffixListTest.assertEquals("example.co.uk", suffixList.getDomain("example.co.uk"));
        PublicSuffixListTest.assertEquals("example.co.uk", suffixList.getDomain("www.example.co.uk"));
        PublicSuffixListTest.assertEquals("www", suffixList.getSubDomain("www.example.co.uk"));
        PublicSuffixListTest.assertEquals("\u98df\u72ee.com.cn", suffixList.getDomain("\u98df\u72ee.com.cn"));
        PublicSuffixListTest.assertEquals("xn--85x722f.com.cn", suffixList.getDomain("xn--85x722f.com.cn"));
        PublicSuffixListTest.assertEquals("my", suffixList.getSubDomain("my.jdownloader.org"));
        PublicSuffixListTest.assertEquals(null, suffixList.getSubDomain("jdownloader.org"));
        PublicSuffixListTest.assertEquals("127-0-0-1.mydns", suffixList.getSubDomain("127-0-0-1.mydns.jdownloader.org"));
    }
}

