/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.throttledconnection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;
import org.appwork.utils.speedmeter.AverageSpeedMeter;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class SimpleThrottledConnectionHandler
implements ThrottledConnectionHandler {
    protected Thread watchDog = null;
    protected List<ThrottledConnection> connections = new ArrayList<ThrottledConnection>();
    protected volatile int limit = 0;
    protected int updateSpeed = 2000;
    protected volatile int bandwidth = 0;
    protected SpeedMeterInterface speedMeter = new AverageSpeedMeter(10);
    protected volatile long traffic = 0L;
    private final Object watchDogLOCK = new Object();
    private final String name;

    public SimpleThrottledConnectionHandler(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addThrottledConnection(ThrottledConnection con) {
        if (this.connections.contains(con)) {
            return;
        }
        SimpleThrottledConnectionHandler simpleThrottledConnectionHandler = this;
        synchronized (simpleThrottledConnectionHandler) {
            ArrayList<ThrottledConnection> newConnections = new ArrayList<ThrottledConnection>(this.connections);
            newConnections.add(con);
            this.connections = newConnections;
        }
        con.setHandler(this);
        con.setLimit(10);
        this.startWatchDog();
    }

    @Override
    public List<ThrottledConnection> getConnections() {
        return this.connections;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getSpeed() {
        return this.bandwidth;
    }

    public SpeedMeterInterface getSpeedMeter() {
        return this.speedMeter;
    }

    @Override
    public long getTraffic() {
        return this.traffic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThrottledConnection(ThrottledConnection con) {
        if (!this.connections.contains(con)) {
            return;
        }
        SimpleThrottledConnectionHandler simpleThrottledConnectionHandler = this;
        synchronized (simpleThrottledConnectionHandler) {
            ArrayList<ThrottledConnection> newConnections = new ArrayList<ThrottledConnection>(this.connections);
            newConnections.remove(con);
            this.connections = newConnections;
        }
        con.setHandler(null);
    }

    @Override
    public void setLimit(int limit) {
        this.limit = Math.max(0, limit);
    }

    @Override
    public int size() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWatchDog() {
        Object object = this.watchDogLOCK;
        synchronized (object) {
            if (this.watchDog != null && this.watchDog.isAlive()) {
                return;
            }
            this.watchDog = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<ThrottledConnection> lConnections;
                    this.setName(SimpleThrottledConnectionHandler.this.name);
                    SimpleThrottledConnectionHandler.this.speedMeter.resetSpeedmeter();
                    HashMap<ThrottledConnection, SpeedAssignHelp> speedAssignHelpMap = new HashMap<ThrottledConnection, SpeedAssignHelp>();
                    while ((lConnections = SimpleThrottledConnectionHandler.this.connections).size() != 0) {
                        SpeedAssignHelp helper;
                        long sleepTime = Math.max(1000, SimpleThrottledConnectionHandler.this.updateSpeed);
                        try {
                            Thread.sleep(sleepTime);
                        }
                        catch (InterruptedException e) {
                            LogV3.log(e);
                        }
                        long lastTraffic = 0L;
                        int newBandwidth = 0;
                        long lastRound = 0L;
                        long lastRoundTraffic = 0L;
                        for (ThrottledConnection con : lConnections) {
                            SpeedAssignHelp helper2 = (SpeedAssignHelp)speedAssignHelpMap.get(con);
                            if (helper2 == null) {
                                helper2 = new SpeedAssignHelp();
                                speedAssignHelpMap.put(con, helper2);
                                helper2.lastTraffic = con.transfered();
                                helper2.lastTimeStamp = System.currentTimeMillis();
                                continue;
                            }
                            long sleepTimeCon = System.currentTimeMillis() - helper2.lastTimeStamp;
                            lastTraffic = con.transfered();
                            helper2.lastTimeStamp = System.currentTimeMillis();
                            lastRound = lastTraffic - helper2.lastTraffic;
                            SimpleThrottledConnectionHandler.this.traffic += lastRound;
                            helper2.lastTraffic = lastTraffic;
                            lastRoundTraffic += helper2.lastTraffic;
                            helper2.lastSpeed = (int)(lastRound * 1000L / sleepTimeCon);
                            newBandwidth = (int)((long)newBandwidth + helper2.lastSpeed);
                        }
                        SimpleThrottledConnectionHandler.this.bandwidth = newBandwidth;
                        SimpleThrottledConnectionHandler.this.speedMeter.putBytes(lastRoundTraffic, sleepTime);
                        int left = lConnections.size();
                        int limitLeft = SimpleThrottledConnectionHandler.this.limit;
                        for (ThrottledConnection con : lConnections) {
                            helper = (SpeedAssignHelp)speedAssignHelpMap.get(con);
                            helper.lastLimit = helper.newLimit;
                            helper.newLimit = limitLeft / left;
                            --left;
                            limitLeft -= helper.newLimit;
                        }
                        for (ThrottledConnection con : lConnections) {
                            helper = (SpeedAssignHelp)speedAssignHelpMap.get(con);
                            con.setLimit(helper.newLimit);
                        }
                    }
                    Object object = SimpleThrottledConnectionHandler.this.watchDogLOCK;
                    synchronized (object) {
                        SimpleThrottledConnectionHandler.this.watchDog = null;
                        SimpleThrottledConnectionHandler.this.bandwidth = 0;
                        SimpleThrottledConnectionHandler.this.speedMeter.resetSpeedmeter();
                    }
                }
            };
            this.watchDog.setDaemon(false);
            this.watchDog.start();
        }
    }

    private static class SpeedAssignHelp {
        protected long lastLimit = 0L;
        protected int newLimit = 0;
        protected long lastDifference = 0L;
        protected long lastSpeed = 0L;
        protected long lastTraffic = 0L;
        protected long lastTimeStamp = 0L;

        private SpeedAssignHelp() {
        }
    }
}

