/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import java.util.EventListener;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.Eventsender;

public class StandbyDetector {
    private Eventsender<StandbyDetectorListener, StandbyDetectedEvent> eventSender = new Eventsender<StandbyDetectorListener, StandbyDetectedEvent>(){

        @Override
        protected void fireEvent(StandbyDetectorListener listener, StandbyDetectedEvent event) {
            if (StandbyDetector.this.isStandByDetectorEnabled()) {
                listener.onStandbyDetected(event.getPossibleStandByTime());
            }
        }
    };
    private final AtomicReference<Thread> standbyDetectorThread = new AtomicReference<Object>(null);
    private final long standbyDetectionTimeout;

    public final Eventsender<StandbyDetectorListener, StandbyDetectedEvent> getEventSender() {
        return this.eventSender;
    }

    public final long getStandbyDetectionTimeout() {
        return this.standbyDetectionTimeout;
    }

    public StandbyDetector(long standbyDetectionTimeout) {
        this.standbyDetectionTimeout = Math.max(10000L, standbyDetectionTimeout);
    }

    private final boolean isStandByDetectorEnabled() {
        return Thread.currentThread() == this.standbyDetectorThread.get();
    }

    public synchronized void start() {
        Thread thread = this.standbyDetectorThread.get();
        if (thread == null || !thread.isAlive()) {
            thread = new Thread("StandbyDetector"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        block7: while (true) {
                            while (StandbyDetector.this.isStandByDetectorEnabled()) {
                                long lastTimeStamp = System.currentTimeMillis();
                                try {
                                    Thread.sleep(StandbyDetector.this.getStandbyDetectionTimeout());
                                }
                                catch (InterruptedException e) {
                                    break block9;
                                }
                                long timeStampGap = System.currentTimeMillis() - lastTimeStamp;
                                if (timeStampGap <= StandbyDetector.this.getStandbyDetectionTimeout()) continue;
                                try {
                                    StandbyDetector.this.eventSender.fireEvent(new StandbyDetectedEvent(StandbyDetector.this, timeStampGap));
                                    continue block7;
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                            break block9;
                            {
                                continue block7;
                                break;
                            }
                            break;
                        }
                        finally {
                            StandbyDetector.this.standbyDetectorThread.compareAndSet(Thread.currentThread(), null);
                        }
                    }
                }
            };
            thread.setDaemon(true);
            this.standbyDetectorThread.set(thread);
            thread.start();
        }
    }

    public final synchronized boolean isRunning() {
        Thread thread = this.standbyDetectorThread.get();
        return thread != null && thread.isAlive();
    }

    public final synchronized void stop() {
        this.standbyDetectorThread.getAndSet(null);
    }

    public static interface StandbyDetectorListener
    extends EventListener {
        public void onStandbyDetected(long var1);
    }

    private class StandbyDetectedEvent
    extends DefaultEvent {
        private final long possibleStandByTime;

        public final long getPossibleStandByTime() {
            return this.possibleStandByTime;
        }

        public StandbyDetectedEvent(Object caller, long possibleStandByTime) {
            super(caller);
            this.possibleStandByTime = possibleStandByTime;
        }
    }
}

