/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os.mime;

import java.io.IOException;
import java.util.HashMap;
import javax.swing.Icon;
import org.appwork.resources.AWIcon;
import org.appwork.resources.AWUTheme;
import org.appwork.utils.os.mime.Mime;

public class MimeDefault
implements Mime {
    private static final HashMap<String, String> DESCRIPTION_CACHE = new HashMap();

    protected Icon getCacheIcon(String iconKey) {
        return AWUTheme.I().getCached(iconKey);
    }

    @Override
    public Icon getFileIcon(String extension, int width, int height) throws IOException {
        return AWIcon.MIME_fileIcon.get(width);
    }

    protected String getIconKey(String extension, int width, int height) {
        StringBuilder sb = new StringBuilder();
        sb.append(extension);
        sb.append("_");
        sb.append(width);
        sb.append("x");
        sb.append(height);
        return sb.toString();
    }

    @Override
    public String getMimeDescription(String mimetype) {
        return mimetype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMimeDescriptionCache(String mimetype) {
        HashMap<String, String> hashMap = DESCRIPTION_CACHE;
        synchronized (hashMap) {
            return DESCRIPTION_CACHE.get(mimetype);
        }
    }

    protected void saveIconCache(String iconKey, Icon icon) {
        AWUTheme.I().cache(icon, iconKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMimeDescriptionCache(String mimetype, String description) {
        HashMap<String, String> hashMap = DESCRIPTION_CACHE;
        synchronized (hashMap) {
            DESCRIPTION_CACHE.put(mimetype, description);
        }
    }
}

