/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.appwork.resources.AWUTheme;
import org.appwork.uio.ExceptionDialogInterface;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.Exceptions;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;

public class ExceptionDialog
extends AbstractDialog<Integer>
implements ExceptionDialogInterface {
    private final String message;
    private JTextPane textField;
    private final Throwable exception;
    private JTextArea logField;
    private JScrollPane scrollPane;
    private JLabel logLabel;
    private JButton more;
    private boolean expanded = false;
    private String moreString;
    public static final int EXPANDED = 0x100000;

    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public boolean isRemoteAPIEnabled() {
        return true;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public ExceptionDialog(int flag, String title, String message, Throwable exception, String okOption, String cancelOption) {
        super(flag, title, null, okOption, cancelOption);
        this.getLogger().fine("Dialog    [" + okOption + "][" + cancelOption + "]\r\nflag:  " + Integer.toBinaryString(flag) + "\r\ntitle: " + title + "\r\nmsg:   \r\n" + message);
        this.message = message;
        this.exception = exception;
        this.expanded = BinaryLogic.containsAll(flag, 0x100000);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    protected void addButtons(JPanel buttonBar) {
        this.more = new JButton(_AWU.T.ExceptionDialog_layoutDialogContent_more_button());
        this.more.setCursor(Cursor.getPredefinedCursor(12));
        this.more.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExceptionDialog.this.expand();
            }
        });
        this.more.setHorizontalAlignment(4);
        if (this.expanded) {
            this.expand();
        } else {
            buttonBar.add((Component)this.more, "hidemode 3");
        }
    }

    @Override
    protected Integer createReturnValue() {
        return this.getReturnmask();
    }

    @Override
    public String getDontShowAgainKey() {
        return "ABSTRACTDIALOG_DONT_SHOW_AGAIN_" + this.exception.hashCode() + "_" + this.toString();
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public JComponent layoutDialogContent() {
        JPanel cp = new JPanel(new MigLayout("ins 0,wrap 1", "[fill]", "[][]"));
        this.textField = new JTextPane(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return !BinaryLogic.containsAll(ExceptionDialog.this.flagMask, 64);
            }
        };
        Font font = this.textField.getFont();
        if (BinaryLogic.containsAll(this.flagMask, 128)) {
            this.textField.setContentType("text/html");
            this.textField.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        CrossSystem.openURL(e.getURL());
                    }
                }
            });
        } else {
            this.textField.setContentType("text/plain");
        }
        this.textField.setFont(font);
        this.textField.setText(this.message);
        this.textField.setEditable(false);
        this.textField.setBackground(null);
        this.textField.setOpaque(false);
        this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.textField.setCaretPosition(0);
        cp.add((Component)new JLabel(AWUTheme.I().getIcon(Dialog.ICON_ERROR, 32)), "width 32!,split 2");
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            cp.add((Component)new JScrollPane(this.textField), "pushx,growx");
        } else {
            cp.add((Component)this.textField, "pushx,growx");
        }
        this.logField = new JTextArea();
        this.logField.setLineWrap(false);
        this.logField.setEditable(true);
        this.logField.setAutoscrolls(true);
        this.scrollPane = new JScrollPane(this.logField);
        this.scrollPane.setVisible(false);
        this.logField.setEditable(true);
        this.logField.setAutoscrolls(true);
        this.logField.setForeground(Color.RED);
        this.logLabel = new JLabel(_AWU.T.ExceptionDialog_layoutDialogContent_logLabel());
        this.logLabel.setVisible(false);
        cp.add((Component)this.logLabel, "hidemode 3,gaptop 5");
        cp.add((Component)this.scrollPane, "hidemode 3,height 100:300:n,width 200:600:n,pushx,growx,pushy,growy");
        CrossSystem.playErrorSound();
        return cp;
    }

    @Override
    public String toString() {
        return ("dialog-" + this.getTitle() + "_" + this.message).replaceAll("\\W", "_");
    }

    public void expand() {
        this.scrollPane.setVisible(true);
        if (this.moreString != null) {
            this.logField.setText(this.moreString);
        } else {
            this.logField.setText(this.stacktraceToString());
        }
        this.logLabel.setVisible(true);
        this.more.setVisible(false);
        this.setResizable(true);
        this.pack();
    }

    protected String stacktraceToString() {
        return Exceptions.getStackTrace(this.exception);
    }

    public void setMore(String string) {
        this.moreString = string;
    }

    @Override
    public String getStacktrace() {
        return this.stacktraceToString();
    }
}

