/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtPasswordField;
import org.appwork.swing.components.ExtTextField;
import org.appwork.swing.components.TextComponentInterface;
import org.appwork.uio.InputDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;

public class InputDialog
extends AbstractDialog<String>
implements KeyListener,
MouseListener,
InputDialogInterface {
    protected String defaultMessage;
    protected String message;
    protected TextComponentInterface input;
    protected JTextPane bigInput;
    protected JTextPane textField;

    @Override
    public InputDialogInterface show() {
        return UIOManager.I().show(InputDialogInterface.class, this);
    }

    @Override
    public boolean isRemoteAPIEnabled() {
        return true;
    }

    public InputDialog(int flag, String title, String message, String defaultMessage, Icon icon, String okOption, String cancelOption) {
        super(flag, title, icon, okOption, cancelOption);
        this.getLogger().fine("Dialog    [" + okOption + "][" + cancelOption + "]\r\nflag:  " + Integer.toBinaryString(flag) + "\r\ntitle: " + title + "\r\nmsg:   \r\n" + message + "\r\ndef:   \r\n" + StringUtils.abr(defaultMessage, 50, "[...]"));
        this.defaultMessage = defaultMessage;
        this.message = message;
    }

    public InputDialog(int flag, String title, String message, String defaultMessage) {
        this(flag, title, message, defaultMessage, null, null, null);
    }

    @Override
    protected String createReturnValue() {
        return this.getReturnID();
    }

    @Override
    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getReturnID() {
        if ((this.getReturnmask() & 0x22) == 0) {
            return null;
        }
        if (this.input == null) {
            if (this.bigInput == null || this.bigInput.getText() == null) {
                return null;
            }
            return this.bigInput.getText();
        }
        if (this.input == null || this.input.getText() == null) {
            return null;
        }
        if (this.input instanceof JPasswordField) {
            return new String(((JPasswordField)((Object)this.input)).getPassword());
        }
        return this.input.getText();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.cancel();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            CrossSystem.openURL(e.getURL());
        }
    }

    @Override
    public JComponent layoutDialogContent() {
        MigPanel contentpane = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[][]");
        if (!StringUtils.isEmpty(this.message)) {
            this.textField = new JTextPane(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean getScrollableTracksViewportWidth() {
                    return !BinaryLogic.containsAll(InputDialog.this.flagMask, 64);
                }

                @Override
                public boolean getScrollableTracksViewportHeight() {
                    return true;
                }
            };
            Font font = this.textField.getFont();
            if (BinaryLogic.containsAll(this.flagMask, 128)) {
                this.textField.setContentType("text/html");
                this.textField.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        InputDialog.this.hyperlinkUpdate(e);
                    }
                });
            } else {
                this.textField.setContentType("text/plain");
            }
            this.textField.setFont(font);
            this.textField.setText(this.message);
            this.textField.setEditable(false);
            this.textField.setForeground(new JLabel().getForeground());
            this.textField.setBackground(null);
            this.textField.setOpaque(false);
            this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
            this.textField.setCaretPosition(0);
            if (BinaryLogic.containsAll(this.flagMask, 64)) {
                contentpane.add(new JScrollPane(this.textField));
            } else {
                contentpane.add(this.textField);
            }
            this.textField.setPreferredSize(this.textField.getPreferredSize());
        }
        if (BinaryLogic.containsAll(this.flagMask, 64)) {
            this.bigInput = this.getLargeInputComponent();
            this.bigInput.setText(this.defaultMessage);
            this.bigInput.addKeyListener(this);
            this.bigInput.addMouseListener(this);
            contentpane.add((Component)new JScrollPane(this.bigInput), "height 20:60:n,pushy,growy,w 450");
        } else {
            this.input = this.getSmallInputComponent();
            this.input.setText(this.defaultMessage);
            contentpane.add((Component)((JComponent)((Object)this.input)), "w 450");
        }
        return contentpane;
    }

    protected JTextPane getLargeInputComponent() {
        return new JTextPane();
    }

    protected TextComponentInterface getSmallInputComponent() {
        if (BinaryLogic.containsAll(this.flagMask, 512)) {
            ExtPasswordField pw = new ExtPasswordField();
            pw.addKeyListener(this);
            pw.addMouseListener(this);
            return pw;
        }
        ExtTextField ttx = new ExtTextField();
        ttx.addKeyListener(this);
        ttx.addMouseListener(this);
        return ttx;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.cancel();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected void packed() {
    }

    @Override
    protected void initFocus(JComponent focus) {
        if (this.input != null) {
            this.input.selectAll();
            this.input.requestFocusInWindow();
        }
        if (this.bigInput != null) {
            this.bigInput.selectAll();
            this.bigInput.requestFocusInWindow();
        }
    }

    public void setDefaultMessage(final String defaultMessage) {
        this.defaultMessage = defaultMessage;
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                if (InputDialog.this.input != null) {
                    InputDialog.this.input.setText(defaultMessage);
                }
                if (InputDialog.this.bigInput != null) {
                    InputDialog.this.bigInput.setText(defaultMessage);
                }
            }
        };
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getText() {
        if (Application.isHeadless()) {
            if (this.input != null) {
                return this.input.getText();
            }
            if (this.bigInput != null) {
                return this.bigInput.getText();
            }
            return null;
        }
        return (String)new EDTHelper<String>(){

            @Override
            public String edtRun() {
                if (InputDialog.this.input != null) {
                    return InputDialog.this.input.getText();
                }
                if (InputDialog.this.bigInput != null) {
                    return InputDialog.this.bigInput.getText();
                }
                return null;
            }
        }.getReturnValue();
    }
}

