/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.dialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.ExtJDialog;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogIcon;

public class InternDialog<T>
extends ExtJDialog {
    private final AbstractDialog<T> dialogModel;
    private static final long serialVersionUID = 1L;
    protected static boolean REQUESTUSERATTENTION_SUPPORTED = true;

    @Override
    public void setVisible(boolean b) {
        this.dialogModel.onSetVisible(b);
        super.setVisible(b);
    }

    protected InternDialog(AbstractDialog<T> abstractDialog, Dialog.ModalityType modality) {
        super(abstractDialog.getOwner(), modality);
        this.dialogModel = abstractDialog;
        this.setLayout(new MigLayout("ins 5", "[]", "[fill,grow][]"));
        List<? extends Image> iconlist = Dialog.getInstance().getIconList();
        if (iconlist == null) {
            iconlist = this.dialogModel.getIconList();
        }
        if (iconlist != null) {
            this.setIconImages(iconlist);
        } else if (this.getOwner() == null) {
            ArrayList<Image> l = new ArrayList<Image>();
            l.add(DialogIcon.DIALOG_INFO.image(16));
            l.add(DialogIcon.DIALOG_INFO.image(32));
            this.setIconImages(l);
        }
        if (REQUESTUSERATTENTION_SUPPORTED && CrossSystem.isMac()) {
            try {
                Object application = ReflectionUtils.invoke("com.apple.eawt.Application", "getApplication", null, Class.forName("com.apple.eawt.Application"), new Class[0], new Object[0]);
                ReflectionUtils.invoke("com.apple.eawt.Application", "requestUserAttention", application, Void.TYPE, new Class[]{Boolean.TYPE}, new Object[]{true});
            }
            catch (NoSuchMethodError ignore) {
                REQUESTUSERATTENTION_SUPPORTED = false;
            }
            catch (IllegalAccessError ignore) {
                REQUESTUSERATTENTION_SUPPORTED = false;
            }
            catch (ClassNotFoundException e) {
                REQUESTUSERATTENTION_SUPPORTED = false;
            }
            catch (SecurityException e) {
                REQUESTUSERATTENTION_SUPPORTED = false;
            }
            catch (InvocationTargetException e) {
                REQUESTUSERATTENTION_SUPPORTED = false;
            }
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.setName(title);
    }

    public AbstractDialog<T> getDialogModel() {
        return this.dialogModel;
    }

    @Override
    public void dispose() {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                try {
                    AbstractDialog dialogModel = InternDialog.this.getDialogModel();
                    if (dialogModel != null) {
                        dialogModel.setDisposed(true);
                        dialogModel.dispose();
                    }
                }
                finally {
                    InternDialog.this.realDispose();
                }
            }
        }.waitForEDT();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dialogModel.getPreferredSize();
    }

    public Dimension getRawPreferredSize() {
        return super.getPreferredSize();
    }

    protected void realDispose() {
        super.dispose();
    }
}

