/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing.tests;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.appwork.exceptions.WTFException;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.TestDependency;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDT;

@TestDependency(value={"org.appwork.utils.swing.EDT"})
public class EDTTest
extends AWTest {
    public static void main(String[] args) {
        EDTTest.run();
    }

    @Override
    public void runTest() throws Exception {
        if (!Application.isHeadless()) {
            EDTTest.test_InvokeLater();
            EDTTest.test_RunTest();
            EDTTest.test_Exception();
            EDTTest.test_Interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test_Interrupt() throws Exception {
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        final Object LOCK = new Object();
        try {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        new EDT<Void, Exception>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected Void runInEDT() throws Exception {
                                Object object = LOCK;
                                synchronized (object) {
                                    LOCK.wait();
                                }
                                return null;
                            }
                        }.waitFor();
                        throw new Exception();
                    }
                    catch (Exception e) {
                        exception.set(e);
                        return;
                    }
                }
            };
            thread.start();
            thread.join(100L);
            thread.interrupt();
            thread.join(100L);
            EDTTest.assertTrue(exception.get() instanceof InterruptedException);
        }
        finally {
            Object object = LOCK;
            synchronized (object) {
                LOCK.notifyAll();
            }
        }
    }

    private static void test_Exception() throws Exception {
        try {
            new EDT<Void, Exception>(){

                @Override
                protected Void runInEDT() throws Exception {
                    throw new IllegalStateException();
                }
            }.waitFor();
            throw new WTFException();
        }
        catch (IllegalStateException illegalStateException) {
            try {
                EDT<Void, Exception> edt = new EDT<Void, Exception>(){

                    @Override
                    protected Void runInEDT() throws Exception {
                        throw new IllegalStateException();
                    }
                };
                edt.invokeLater().waitFor();
                throw new WTFException();
            }
            catch (IllegalStateException illegalStateException2) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test_RunTest() throws Exception {
        final CopyOnWriteArrayList ret = new CopyOnWriteArrayList();
        final AtomicBoolean done = new AtomicBoolean(false);
        new EDT<Void, Exception>(){

            @Override
            protected Void runInEDT() throws Exception {
                for (int index = 0; index < 100; ++index) {
                    final int num = index;
                    EDT.run(new Runnable(){

                        @Override
                        public void run() {
                            ret.add(num);
                        }
                    });
                    AWTest.assertTrue(ret.size() == index + 1);
                }
                EDT.run(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicBoolean atomicBoolean = done;
                        synchronized (atomicBoolean) {
                            done.set(true);
                            done.notifyAll();
                        }
                    }
                });
                return null;
            }
        }.waitFor();
        while (!done.get()) {
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                done.wait();
            }
        }
        for (int index = 0; index < 100; ++index) {
            EDTTest.assertEquals(ret.get(index), index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test_InvokeLater() throws Exception {
        final CopyOnWriteArrayList ret = new CopyOnWriteArrayList();
        final AtomicBoolean done = new AtomicBoolean(false);
        new EDT<Void, Exception>(){

            @Override
            protected Void runInEDT() throws Exception {
                for (int index = 0; index < 100; ++index) {
                    final int num = index;
                    EDT.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ret.add(num);
                        }
                    });
                    AWTest.assertTrue(ret.size() == 0);
                }
                EDT.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicBoolean atomicBoolean = done;
                        synchronized (atomicBoolean) {
                            done.set(true);
                            done.notifyAll();
                        }
                    }
                });
                return null;
            }
        }.waitFor();
        while (!done.get()) {
            AtomicBoolean atomicBoolean = done;
            synchronized (atomicBoolean) {
                done.wait();
            }
        }
        for (int index = 0; index < 100; ++index) {
            EDTTest.assertEquals(ret.get(index), index);
        }
    }
}

