/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.tests;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.appwork.storage.TypeRef;
import org.appwork.testframework.AWTest;
import org.appwork.utils.ReflectionUtils;

public class ReflectionUtilsTest
extends AWTest {
    public static void main(String[] args) {
        ReflectionUtilsTest.run();
    }

    @Override
    public void runTest() throws Exception {
        Object retA = ReflectionUtils.getEnumValues(((Object)((Object)TestEnum.A)).getClass());
        Object retB = ReflectionUtils.getEnumValues(((Object)((Object)TestEnum.B)).getClass());
        ReflectionUtilsTest.assertEqualsDeep(retA, retB);
        ReflectionUtilsTest.assertNotNull(retA);
        retA = ReflectionUtils.getEnumValueOf(((Object)((Object)TestEnum.A)).getClass(), "A");
        retB = ReflectionUtils.getEnumValueOf(((Object)((Object)TestEnum.B)).getClass(), "A");
        ReflectionUtilsTest.assertEqualsDeep(retA, retB);
        ReflectionUtilsTest.assertNotNull(retA);
        if (ReflectionUtils.getComponentClass(new TypeRef<Set<String>>(){}.getType()) != String.class) {
            throw new Exception("getComponentClass Test Failed");
        }
        if (ReflectionUtils.getComponentClass(new TypeRef<List<Boolean>>(){}.getType()) != Boolean.class) {
            throw new Exception("getComponentClass Test Failed");
        }
        if (ReflectionUtils.getComponentClass(new TypeRef<Map<String, Integer>>(){}.getType()) != Integer.class) {
            throw new Exception("getComponentClass Test Failed");
        }
        if (ReflectionUtils.getComponentClass(new TypeRef<String>(){}.getType()) != null) {
            throw new Exception("getComponentClass Test Failed");
        }
        ReflectionUtilsTest.assertFalse(ReflectionUtils.isListOrArray(Collection.class));
        ReflectionUtilsTest.assertFalse(ReflectionUtils.isListOrArray(HashSet.class));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isFloatRange(3.4028234E38));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isFloatRange(Float.valueOf(Float.MIN_VALUE)));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isFloatRange(Float.valueOf(Float.MAX_VALUE)));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isFloatRange(Float.valueOf(-3.4028235E38f)));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isFloatRange(3.4028235E38));
        ReflectionUtilsTest.assertFalse(ReflectionUtils.isFloatRange(3.4028236E38));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isDoubleRange(Double.MAX_VALUE));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isDoubleRange(Double.MAX_VALUE));
        ReflectionUtilsTest.assertTrue(ReflectionUtils.isDoubleRange(-1.7976931348623157E308));
    }

    public static enum TestEnum {
        A,
        B{};

    }
}

