/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.tests;

import org.appwork.storage.JSonStorage;
import org.appwork.testframework.AWTest;
import org.appwork.utils.StringUtils;

public class StringUtilsTest
extends AWTest {
    @Override
    public void runTest() throws Exception {
        StringUtilsTest.assertEquals(StringUtils.upperLowerAfterRegex("(^|\\s+|-|/|_)", "mein", true, false), "Mein");
        StringUtilsTest.assertEquals(StringUtils.upperLowerAfterRegex("(^|\\s+|-|/|_)", "mEiN", null, null), "mEiN");
        StringUtilsTest.assertEquals(StringUtils.upperLowerAfterRegex("(^|\\s+|-|/|_)", "mein Text-min_zeug", true, false), "Mein Text-Min_Zeug");
        StringUtilsTest.assertEquals(StringUtils.toCamelCase("mein Text-min_zeug", true), "MeinTextMinZeug");
        StringUtilsTest.assertEquals(StringUtils.toCamelCase("mein Text-min_zeug", false), "meinTextMinZeug");
        String before = "a\rb\nc\r\nd";
        String string = StringUtils.multiLineIntend(before, " * ", "   ");
        StringUtilsTest.assertThat(string).is(" * a\r   b\n   c\r\n   d");
        before = "\r\na\rb\n\r\nc\r\nd\r\n";
        String string2 = StringUtils.multiLineIntend(before, " * ", "   ");
        StringUtilsTest.assertThat(string2).is(" * \r\n   a\r   b\n   \r\n   c\r\n   d\r\n   ");
        before = "split                                                                                                       something at end";
        String string3 = StringUtils.wrapText(before, 40, "([\\s]+)", null, true);
        StringUtilsTest.assertThat(string3).is("split\r\nsomething at end");
        before = "split                                                                                                       ";
        String string4 = StringUtils.wrapText(before, 40, "([\\s]+)", null, true);
        StringUtilsTest.assertThat(string4).is("split");
        before = "split a text with many space at end                                                                                                       ";
        String string5 = StringUtils.wrapText(before, 40, null, null, true);
        StringUtilsTest.assertThat(string5).is("split a text with many space at end     \r\n                                        \r\n                                        \r\n               ");
        before = "     split\r\n     longtext at spaces, but keep extra spaces";
        String string6 = StringUtils.wrapText(before, 20, null, null, true);
        StringUtilsTest.assertThat(string6).is("     split\r\n     longtext at\r\nspaces, but keep\r\nextra spaces");
        before = "longtext to split at space or othersa. replace space split at whitespace oroooanyother";
        String string7 = StringUtils.wrapText(before, 24, "([\\s]{1,})|(ooo)|oth|(irgendwas)", null, true);
        StringUtilsTest.assertThat(string7).is("longtext to split at\r\nspace or othersa.\r\nreplace space split at\r\nwhitespace oroooany\r\nother");
        before = "     string with\r\n         \t spaces and wrapping";
        String string8 = StringUtils.wrapText(before, 60, null, null, true);
        StringUtilsTest.assertThat(string8).is(before);
        StringUtilsTest.assertTrue(StringUtils.isEmptyAfterTrim(" "));
        StringUtilsTest.assertTrue(StringUtils.isEmptyAfterTrim("  "));
        StringUtilsTest.assertFalse(StringUtils.isEmptyAfterTrim(" 1"));
        StringUtilsTest.assertFalse(StringUtils.isEmptyAfterTrim(" 1 "));
        StringUtilsTest.assertFalse(StringUtils.isEmptyAfterTrim("1 "));
        for (int minCount = 1; minCount < 30; ++minCount) {
            for (String fill : new String[]{"a", " ", "!"}) {
                StringUtilsTest.assertEquals(StringUtils.fillPost("test", fill, minCount), "test" + (minCount > "test".length() ? String.format("%0" + (minCount - "test".length()) + "d", 0).replace("0", fill) : ""));
                StringUtilsTest.assertEquals(StringUtils.fillPre("test", fill, minCount), (minCount > "test".length() ? String.format("%0" + (minCount - "test".length()) + "d", 0).replace("0", fill) : "") + "test");
            }
        }
        StringUtilsTest.assertTrue(StringUtils.isAllEmpty(" "));
        StringUtilsTest.assertFalse(StringUtils.isAllNotEmpty(" "));
        StringUtilsTest.assertTrue(StringUtils.isAllNotEmpty("1"));
        StringUtilsTest.assertFalse(StringUtils.isAllEmpty("1"));
        StringUtilsTest.assertTrue(StringUtils.isAllEmpty(" ", " "));
        StringUtilsTest.assertFalse(StringUtils.isAllNotEmpty(" ", " "));
        StringUtilsTest.assertTrue(StringUtils.isAllNotEmpty("1", "2"));
        StringUtilsTest.assertFalse(StringUtils.isAllEmpty("1", "2"));
        String textWithLongWordAtEnd = "Nihil corporis consequatur harum porro. Soluta quod dolores consectetur fugiat ipsa. Qui nostrum eos veritatis est sunt quia. Perspiciatis alias aut enim harum et officiis. Ipsam est atque libero quam eos impedit. Modi occaecati autem cumque deleniti quo itaque. dasisteinsehrlangeswordohnespaceundsowasichkannesnurschwerrrennen";
        String string9 = StringUtils.wrapText(textWithLongWordAtEnd, 30, null, null, true);
        StringUtilsTest.assertEquals("Nihil corporis consequatur\r\nharum porro. Soluta quod\r\ndolores consectetur fugiat\r\nipsa. Qui nostrum eos\r\nveritatis est sunt quia.\r\nPerspiciatis alias aut enim\r\nharum et officiis. Ipsam est\r\natque libero quam eos impedit.\r\nModi occaecati autem cumque\r\ndeleniti quo itaque.\r\ndasisteinsehrlangeswordohnespa\r\nceundsowasichkannesnurschwerrr\r\nennen", string9);
        String string10 = StringUtils.wrapText(textWithLongWordAtEnd, 30, null, null, false);
        StringUtilsTest.assertEquals("Nihil corporis consequatur\r\nharum porro. Soluta quod\r\ndolores consectetur fugiat\r\nipsa. Qui nostrum eos\r\nveritatis est sunt quia.\r\nPerspiciatis alias aut enim\r\nharum et officiis. Ipsam est\r\natque libero quam eos impedit.\r\nModi occaecati autem cumque\r\ndeleniti quo itaque.\r\ndasisteinsehrlangeswordohnespaceundsowasichkannesnurschwerrrennen", string10);
        String string11 = StringUtils.wrapText(textWithLongWordAtEnd + "  ", 30, null, null, true);
        StringUtilsTest.assertEquals("Nihil corporis consequatur\r\nharum porro. Soluta quod\r\ndolores consectetur fugiat\r\nipsa. Qui nostrum eos\r\nveritatis est sunt quia.\r\nPerspiciatis alias aut enim\r\nharum et officiis. Ipsam est\r\natque libero quam eos impedit.\r\nModi occaecati autem cumque\r\ndeleniti quo itaque.\r\ndasisteinsehrlangeswordohnespa\r\nceundsowasichkannesnurschwerrr\r\nennen  ", string11);
        String string12 = StringUtils.wrapText(textWithLongWordAtEnd + "  ", 30, null, null, false);
        StringUtilsTest.assertEquals("Nihil corporis consequatur\r\nharum porro. Soluta quod\r\ndolores consectetur fugiat\r\nipsa. Qui nostrum eos\r\nveritatis est sunt quia.\r\nPerspiciatis alias aut enim\r\nharum et officiis. Ipsam est\r\natque libero quam eos impedit.\r\nModi occaecati autem cumque\r\ndeleniti quo itaque.\r\ndasisteinsehrlangeswordohnespaceundsowasichkannesnurschwerrrennen  ", string12);
        String string13 = StringUtils.wrapText("  " + textWithLongWordAtEnd + ".", 30, null, null, true);
        StringUtilsTest.assertEquals("  Nihil corporis consequatur\r\nharum porro. Soluta quod\r\ndolores consectetur fugiat\r\nipsa. Qui nostrum eos\r\nveritatis est sunt quia.\r\nPerspiciatis alias aut enim\r\nharum et officiis. Ipsam est\r\natque libero quam eos impedit.\r\nModi occaecati autem cumque\r\ndeleniti quo itaque.\r\ndasisteinsehrlangeswordohnespa\r\nceundsowasichkannesnurschwerrr\r\nennen.", string13);
        String string14 = StringUtils.wrapText("  " + textWithLongWordAtEnd + ".", 30, null, null, false);
        StringUtilsTest.assertEquals("  Nihil corporis consequatur\r\nharum porro. Soluta quod\r\ndolores consectetur fugiat\r\nipsa. Qui nostrum eos\r\nveritatis est sunt quia.\r\nPerspiciatis alias aut enim\r\nharum et officiis. Ipsam est\r\natque libero quam eos impedit.\r\nModi occaecati autem cumque\r\ndeleniti quo itaque.\r\ndasisteinsehrlangeswordohnespaceundsowasichkannesnurschwerrrennen.", string14);
        String string15 = StringUtils.wrapText(",  .", 30, null, null, false);
        StringUtilsTest.assertEquals(",  .", string15);
        String string16 = StringUtils.wrapText("397238n94ufhdknfm498curlfhgafdlcnnmsdfhjdasiasifsbsafsdhfjkabmnvbcdfshdjhsmdhdbduHRTJBH", 30, null, null, false);
        StringUtilsTest.assertEquals("397238n94ufhdknfm498curlfhgafdlcnnmsdfhjdasiasifsbsafsdhfjkabmnvbcdfshdjhsmdhdbduHRTJBH", string16);
        String string17 = StringUtils.wrapText("397238n94ufhdknfm498curlfhgafdlcnnmsdfhjdasiasifsbsafsdhfjkabmnvbcdfshdjhsmdhdbduHRTJBH", 30, null, null, true);
        System.out.println(JSonStorage.serializeToJson(string17));
        StringUtilsTest.assertEquals("397238n94ufhdknfm498curlfhgafd\r\nlcnnmsdfhjdasiasifsbsafsdhfjka\r\nbmnvbcdfshdjhsmdhdbduHRTJBH", string17);
        String string18 = StringUtils.wrapText("Dieses Element ist nur in Connect Client/Server/Admintool Builds verf\u00fcgbar, die \u00e4lter sind als 2022-06-27T17:42:00+0200.\r\nBitte sicherstellen, dass #minimumTargetCodeBase entsprechend gesetzt ist.", 98, null, null, true);
        System.out.println(JSonStorage.serializeToJson(string18));
        StringUtilsTest.assertEquals("Dieses Element ist nur in Connect Client/Server/Admintool Builds verf\u00fcgbar, die \u00e4lter sind als\r\n2022-06-27T17:42:00+0200.\r\nBitte sicherstellen, dass #minimumTargetCodeBase entsprechend gesetzt ist.", string18);
    }

    public static void main(String[] args) {
        StringUtilsTest.run();
    }
}

