/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update;

import java.awt.Window;
import javax.swing.Icon;
import org.appwork.console.AbstractConsole;
import org.appwork.console.ConsoleDialog;
import org.appwork.resources.AWUTheme;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.ExceptionDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.locale._AWU;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.jdownloader.update.gui.UpdateGui;

public class DialogHook {
    public static void showConfirmDialog(int flags, String title, String msg, Icon iconByText, String yes, String no) throws DialogClosedException, DialogCanceledException {
        try {
            ConfirmDialog dialog = new ConfirmDialog(flags, title, msg, iconByText, yes, no){

                @Override
                protected Window getDesiredRootFrame() {
                    for (Window w : Window.getWindows()) {
                        if (!(w instanceof UpdateGui) || !w.isVisible()) continue;
                        return w;
                    }
                    return null;
                }
            };
            ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, dialog)).throwCloseExceptions();
        }
        catch (DialogCanceledException e) {
            throw e;
        }
        catch (DialogClosedException e) {
            throw e;
        }
        catch (Throwable e) {
            System.err.println("Exception During confirmation. continue");
            e.printStackTrace();
        }
    }

    public static void showErrorDialog(int flag, String title, String msg) {
        try {
            DialogHook.showConfirmDialog(flag, title, msg, AWUTheme.I().getIcon(Dialog.ICON_ERROR, 32), null, null);
        }
        catch (DialogClosedException e2) {
            LoggerFactory.getDefaultLogger().log(e2);
        }
        catch (DialogCanceledException e2) {
            LoggerFactory.getDefaultLogger().log(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showExceptionDialog(int flags, String title, String message, Throwable e) {
        if (Application.isHeadless()) {
            AbstractConsole console = AbstractConsole.newInstance();
            if (console != null) {
                Object object = AbstractConsole.LOCK;
                synchronized (object) {
                    ConsoleDialog cd = new ConsoleDialog(console, "Exception Occured");
                    cd.start();
                    try {
                        cd.println(title);
                        cd.printLines(message);
                        cd.println("Stacktrace:");
                        cd.printLines(Exceptions.getStackTrace(e));
                        cd.waitToContinue();
                    }
                    finally {
                        cd.end();
                    }
                }
            }
        } else {
            ExceptionDialog dialog = new ExceptionDialog(flags, title, message, e, null, null){

                @Override
                protected Window getDesiredRootFrame() {
                    for (Window w : Window.getWindows()) {
                        if (!(w instanceof UpdateGui) || !w.isVisible()) continue;
                        return w;
                    }
                    return null;
                }
            };
            try {
                UIOManager.I().show(ExceptionDialogInterface.class, dialog);
                dialog.throwCloseExceptions();
            }
            catch (DialogClosedException e2) {
                LoggerFactory.getDefaultLogger().log(e2);
            }
            catch (DialogCanceledException e2) {
                LoggerFactory.getDefaultLogger().log(e2);
            }
        }
    }

    public static void showMessageDialog(String message) {
        try {
            DialogHook.showConfirmDialog(20, _AWU.T.DIALOG_MESSAGE_TITLE(), message, Dialog.getIconByText(message), null, null);
        }
        catch (DialogClosedException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        catch (DialogCanceledException e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
    }
}

