/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSink;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;
import org.jdownloader.update.SelfUpdateException;
import org.jdownloader.update.UpdateManager;
import org.jdownloader.update.lastchance.LastChanceManager;
import org.jdownloader.update.launcher.Timeout;
import org.jdownloader.update.locale.T;

public class SelfTest {
    private final UpdateManager updManager;
    private final File pollFile;
    private final File jdownloaderJar;
    private final LogSource logger = LogController.getInstance().getLogger(SelfTest.class.getName());
    private AtomicBoolean primaryLastChanceOkay = new AtomicBoolean(false);
    private AtomicBoolean secondaryLastChanceOkay = new AtomicBoolean(false);

    public SelfTest(UpdateManager updManager, File root, String relPath) {
        this.updManager = updManager;
        this.pollFile = new File(root, relPath);
        this.jdownloaderJar = new File(root, updManager.getJarName());
    }

    public void run() {
        block6: {
            this.copyOptionalLAf("libs/laf/synthetica.jar");
            this.copyOptionalLAf("libs/laf/syntheticaJDCustom.jar");
            this.copyOptionalLAf("libs/laf/syntheticaSimple2D.jar");
            this.pollFile.getParentFile().mkdirs();
            this.pollFile.delete();
            try {
                this.runSelfTest();
                try {
                    this.onSelfTestOK(this.pollFile, this.jdownloaderJar);
                }
                catch (Exception e) {
                    this.logger.log(e);
                    if (!this.updManager.isRestartEnabled()) break block6;
                    try {
                        this.updManager.start(this.jdownloaderJar.getParentFile(), this.jdownloaderJar, "-selfupdateerror", Exceptions.getStackTrace(e));
                    }
                    catch (IOException e1) {
                        this.updManager.lastChance(e1);
                    }
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
                this.onSelfTestFailed(e.getMessage());
            }
        }
        LogController.getInstance().flushSinks(LogSink.FLUSH.FORCE);
        System.exit(1);
    }

    private void copyOptionalLAf(String string) {
        try {
            File src = new File(this.jdownloaderJar.getParentFile(), string);
            File dst = Application.getResource(string);
            this.logger.info("Copy " + src + " to " + dst);
            if (src.exists()) {
                dst.delete();
            }
            dst.getParentFile().mkdirs();
            IO.copyFile(src, dst);
        }
        catch (FileNotFoundException e) {
            this.logger.info("Could not copy LAF. This is not serious!");
        }
        catch (Exception e) {
            this.logger.log(e);
        }
    }

    public boolean isPrimaryLastChanceSuccessfully() {
        return this.primaryLastChanceOkay.get();
    }

    public boolean isSecondaryLastChanceSuccessfully() {
        return this.secondaryLastChanceOkay.get();
    }

    public void setPrimaryLastChanceSuccessfully(boolean b) {
        System.out.println("PrimaryLastChanceSuccessfully: " + b);
        this.primaryLastChanceOkay.set(b);
    }

    public void setSecondaryLastChanceSuccessfully(boolean b) {
        System.out.println("SecondaryLastChanceSuccessfully: " + b);
        this.secondaryLastChanceOkay.set(b);
    }

    public void runSelfTest() throws Throwable {
        LastChanceManager.getInstance().setSelfTest(true);
        if (!LastChanceManager.getInstance().isStarted()) {
            new Thread("LastChanceSelfTest"){

                @Override
                public void run() {
                    LastChanceManager.getInstance().run();
                }
            }.start();
        }
        while (!LastChanceManager.getInstance().isFinished()) {
            Thread.sleep(1000L);
        }
        if (LastChanceManager.getInstance().getException() != null) {
            throw LastChanceManager.getInstance().getException();
        }
        if (!LastChanceManager.getInstance().isSelfTestLastChanceFlag()) {
            throw new Exception("Selftest Last Chance Failed");
        }
    }

    private void onSelfTestFailed(String reason) {
        try {
            IO.writeStringToFile(this.pollFile, "FAILED " + reason);
            boolean exists = true;
            Timeout timeout = new Timeout(30000);
            while (exists) {
                Thread.sleep(1000L);
                exists = this.pollFile.exists();
                if (!timeout.hasTimedOut()) continue;
                throw new Exception(this.pollFile + " still available. " + timeout);
            }
        }
        catch (Exception e) {
            this.updManager.lastChance(e);
        }
    }

    public void onSelfTestOK(File pollFile, File dest) throws Exception {
        this.logger.info("Write PollFile: " + pollFile);
        IO.writeStringToFile(pollFile, "OK");
        boolean exists = true;
        Timeout timeout = new Timeout(Math.max(60000, this.updManager.getSettings().getSelftestPollTimeout()));
        while (exists) {
            Thread.sleep(50L);
            exists = pollFile.exists();
            if (!timeout.hasTimedOut()) continue;
            throw new Exception(pollFile + " still available. " + timeout);
        }
        timeout = new Timeout(Math.max(60000, this.updManager.getSettings().getSelftestWriteTimeout()));
        while (!this.isWritable(dest)) {
            Thread.sleep(500L);
            if (!timeout.hasTimedOut()) continue;
            throw new Exception(dest + " is not writeable. " + timeout);
        }
        this.logger.info("PollFile Deletion detected: " + pollFile);
        this.updManager.setGuiVisible(true, true);
        this.updManager.getGui().setCancelText(null);
        this.updManager.getGui().setProgress(-1.0);
        this.updManager.getGui().setText(T.T.installframe_statusmsg_selfupdate_validating());
        File orgFile = Application.getResource(this.jdownloaderJar.getName());
        if (!Application.isJared(SelfTest.class)) {
            orgFile = new File(this.jdownloaderJar.getName());
        }
        if (!orgFile.exists()) {
            throw new SelfUpdateException("I do not exist! " + orgFile);
        }
        File destRev = new File(dest.getParentFile(), "update/versioninfo/JDU/rev");
        File backup = this.createBackup(dest);
        File revBackup = this.createBackup(destRev);
        this.logger.info("Rev Backup: " + revBackup + " exists: " + (revBackup != null && revBackup.exists()) + "( org-> " + destRev);
        this.logger.info("Jar Backup: " + backup + " exists: " + (backup != null && backup.exists()) + "( org-> " + dest);
        this.logger.info("Jar: " + dest + " exists: " + dest.exists());
        if (backup == null || !backup.exists()) {
            throw new SelfUpdateException("Could Not create Jar Backup");
        }
        File srcRev = Application.getResource("rev");
        if (!Application.isJared(SelfTest.class)) {
            srcRev = new File("rev");
        }
        try {
            if (srcRev.exists()) {
                this.logger.info(srcRev + " > " + destRev);
                destRev.delete();
                destRev.getParentFile().mkdirs();
                IO.copyFile(srcRev, destRev);
            }
            this.logger.info("Copy Logs");
            try {
                for (String name : Application.getTemp().getParentFile().list()) {
                    if (!name.startsWith("self_") || !name.endsWith(".log")) continue;
                    this.logger.info("Copy LogFile " + Application.getResource(name));
                    File dstFile = new File(dest.getParentFile(), "logs/updatehistory/" + name);
                    this.delete(dstFile, 10000);
                    dstFile.getParentFile().mkdirs();
                    IO.copyFile(Application.getResource(name), dstFile);
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            this.logger.info("Delete " + dest);
            this.delete(dest, 10000);
            this.logger.info("Copy " + orgFile + " to " + dest);
            this.copyFile(orgFile, dest, 30000);
        }
        catch (IOException e) {
            this.logger.log(e);
            try {
                if (backup.exists()) {
                    dest.delete();
                    this.renameTo(backup, dest, 300000);
                }
            }
            catch (Throwable e2) {
                throw new SelfUpdateException(e, "Revert Failed: " + e2.getMessage());
            }
            throw new SelfUpdateException(e);
        }
        finally {
            boolean ok = false;
            this.logger.info("Finally");
            if (this.equals(Hash.getMD5(orgFile), Hash.getMD5(dest))) {
                this.logger.info("Jar Hash OK");
                if (this.equals(Hash.getMD5(srcRev), Hash.getMD5(destRev))) {
                    this.logger.info("REV Hash OK");
                    if (revBackup != null) {
                        revBackup.delete();
                    }
                    if (backup != null) {
                        backup.delete();
                    }
                    ok = true;
                }
            }
            if (!ok) {
                this.logger.info("REVERT");
                if (backup != null && backup.exists()) {
                    this.logger.info("REVERT " + dest);
                    this.delete(dest, 10000);
                    this.renameTo(backup, dest, 60000);
                }
                this.delete(destRev, 10000);
                if (revBackup != null) {
                    this.logger.info("REVERT " + destRev);
                    this.renameTo(revBackup, destRev, 60000);
                }
            }
            if (!dest.exists()) {
                // empty if block
            }
        }
        if (this.updManager.isRestartEnabled()) {
            this.logger.info("Restart " + this.jdownloaderJar.getParentFile() + " - " + this.jdownloaderJar);
            this.updManager.start(this.jdownloaderJar.getParentFile(), this.jdownloaderJar, "-afterupdate");
        } else {
            this.logger.info("No Restart");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isWritable(File dest) {
        boolean bl;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest, true);
            bl = true;
        }
        catch (Throwable e) {
            try {
                this.logger.log(e);
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            fos.close();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    private boolean equals(String a, String b) {
        return StringUtils.equals(a, b);
    }

    protected File createBackup(File dest) throws IOException, InterruptedException {
        this.logger.info("Create backup: " + dest);
        if (!dest.exists()) {
            this.logger.info("Does not exist: " + dest);
            return null;
        }
        int i = 1;
        File backup = new File(dest.getAbsolutePath() + ".backup." + i);
        while (backup.exists()) {
            backup.delete();
            if (!backup.exists()) continue;
            backup = new File(dest.getAbsolutePath() + ".backup." + ++i);
        }
        this.logger.info("Create backup at: " + backup);
        this.renameTo(dest, backup, 30000);
        return backup;
    }

    private void copyFile(File from, File to, int msTimeout) throws IOException, InterruptedException {
        Timeout timeout = new Timeout(msTimeout);
        if (!from.exists()) {
            throw new IOException("Could not copy " + from + " to " + to + " Source does not exist ");
        }
        if (to.exists()) {
            throw new IOException("Could not copy " + from + " to " + to + " Dest exists ");
        }
        String hash = Hash.getMD5(from);
        while (!to.exists()) {
            if (timeout.hasTimedOut()) {
                throw new IOException("Could not copy " + from + " to " + to + " timeout " + timeout);
            }
            if (!from.exists()) {
                throw new IOException("Could not copy " + from + " to " + to + " Source does not exist FATAL!");
            }
            if (to.exists()) {
                throw new IOException("Could not copy " + from + " to " + to + " Dest exists  FATAL!");
            }
            IO.copyFile(from, to);
            if (to.exists()) {
                if (!hash.equals(Hash.getMD5(to))) {
                    throw new IOException("Could not copy " + from + " to " + to + " MD5 Missmatch");
                }
                return;
            }
            Thread.sleep(500L);
        }
    }

    private void renameTo(File from, File to, int msTimeout) throws IOException, InterruptedException {
        this.logger.info("Rename " + from + " to " + to);
        Timeout timeout = new Timeout(msTimeout);
        if (!from.exists()) {
            throw new IOException("Could not move " + from + " to " + to + " Source does not exist ");
        }
        if (to.exists()) {
            throw new IOException("Could not move " + from + " to " + to + " Dest exists ");
        }
        while (from.exists() || !to.exists()) {
            if (timeout.hasTimedOut()) {
                throw new IOException("Could not move " + from + " to " + to + " timeout " + timeout);
            }
            if (!from.exists()) {
                throw new IOException("Could not move " + from + " to " + to + " Source does not exist FATAL!");
            }
            if (to.exists()) {
                throw new IOException("Could not move " + from + " to " + to + " Dest exists  FATAL!");
            }
            boolean renameOK = from.renameTo(to);
            this.logger.info("Rename Success: " + renameOK);
            this.logger.info("From Exists " + from.exists() + " (" + from + ")");
            this.logger.info("To Exists " + to.exists() + " (" + to + ")");
            if (!renameOK) {
                Thread.sleep(500L);
                this.logger.info("Retry");
                if (!timeout.hasTimedOut()) continue;
                throw new IOException("Could not move " + from + " to " + to + " timeout " + timeout);
            }
            while (from.exists() || !to.exists()) {
                Thread.sleep(500L);
                if (!timeout.hasTimedOut()) continue;
                throw new IOException("Could not move " + from + " to " + to + " timeout " + timeout);
            }
            return;
        }
    }

    private void delete(File file, int ms) throws IOException, InterruptedException {
        if (file == null) {
            return;
        }
        this.logger.info("Delete " + file);
        if (!file.exists()) {
            this.logger.info("Delete OK " + file);
            return;
        }
        Timeout timeout = new Timeout(ms);
        while (file.exists()) {
            if (timeout.hasTimedOut()) {
                throw new IOException("Could not delete " + file + " timeout " + timeout);
            }
            file.delete();
            if (!file.exists()) {
                this.logger.info("Delete OK " + file);
                return;
            }
            if (!file.exists()) continue;
            Thread.sleep(500L);
        }
    }
}

