/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2.gui;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.updatev2.gui.DefaultEmptyLookAndFeelExtension;
import org.jdownloader.updatev2.gui.DefaultFlatLAFExtension;
import org.jdownloader.updatev2.gui.DefaultLookAndFeelExtension;
import org.jdownloader.updatev2.gui.LAFSettings;
import org.jdownloader.updatev2.gui.LookAndFeelExtension;

public class LAFOptions {
    public static BooleanKeyHandler TABLE_ALTERNATE_ROW_HIGHLIGHT_ENABLED;
    public static IntegerKeyHandler CUSTOM_TABLE_ROW_HEIGHT;
    private static LAFOptions INSTANCE;
    private final LAFSettings cfg;
    private final String path;
    private static LookAndFeelExtension LAFEXTENSION;
    private static HashMap<String, Color> CACHE;

    public static LAFOptions getInstance() {
        if (INSTANCE == null) {
            throw new WTFException("LAFOptions Not initialized yet");
        }
        return INSTANCE;
    }

    public static LookAndFeelExtension getLookAndFeelExtension() {
        return LAFEXTENSION;
    }

    public LAFSettings getCfg() {
        return this.cfg;
    }

    public String getPath() {
        return this.path;
    }

    private LAFOptions(String laf) {
        int i = laf.lastIndexOf(".");
        String name = i >= 0 ? laf.substring(i + 1) : laf;
        this.path = "cfg/laf/" + name;
        LookAndFeelExtension ext = null;
        if (!"org.jdownloader.gui.laf.jddefault.JDDefaultLookAndFeel".equals(laf)) {
            try {
                Class<?> clz = Class.forName(laf + "Extension");
                Constructor<?> con = clz.getDeclaredConstructor(String.class);
                ext = (LookAndFeelExtension)con.newInstance(laf);
            }
            catch (ClassNotFoundException clz) {
            }
            catch (Throwable e) {
                LoggerFactory.getDefaultLogger().log(e);
            }
        }
        if (ext == null) {
            ext = DebugMode.TRUE_IN_IDE_ELSE_FALSE ? (laf != null && (laf.startsWith("de.javasoft.plaf.synthetica") || laf.startsWith("org.jdownloader.gui.laf.jddefault.JDDefaultLookAndFeel")) ? new DefaultLookAndFeelExtension(laf) : (laf != null && laf.startsWith("com.formdev.flatlaf") ? new DefaultFlatLAFExtension(laf) : new DefaultEmptyLookAndFeelExtension(laf))) : new DefaultLookAndFeelExtension(laf);
        }
        LAFEXTENSION = ext;
        this.cfg = JsonConfig.create(Application.getResource(this.path), LAFSettings.class);
    }

    public LookAndFeelExtension getExtension() {
        return LAFEXTENSION;
    }

    public static synchronized void init(String laf) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new LAFOptions(laf);
        CUSTOM_TABLE_ROW_HEIGHT = INSTANCE.getCfg()._getStorageHandler().getKeyHandler("CustomTableRowHeight", IntegerKeyHandler.class);
        TABLE_ALTERNATE_ROW_HIGHLIGHT_ENABLED = INSTANCE.getCfg()._getStorageHandler().getKeyHandler("TableAlternateRowHighlightEnabled", BooleanKeyHandler.class);
    }

    private static String hex(int alpha) {
        String ret = Integer.toHexString(alpha);
        while (ret.length() < 2) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static String toHex(Color c) {
        return LAFOptions.hex(c.getAlpha()) + LAFOptions.hex(c.getRed()) + LAFOptions.hex(c.getGreen()) + LAFOptions.hex(c.getBlue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color createColor(String str) {
        HashMap<String, Color> hashMap = CACHE;
        synchronized (hashMap) {
            Color ret = CACHE.get(str);
            if (ret != null) {
                return ret;
            }
            try {
                if (str == null) {
                    return null;
                }
                if ((str = str.toLowerCase(Locale.ENGLISH)).startsWith("0x")) {
                    str = str.substring(2);
                }
                if (str.startsWith("#")) {
                    str = str.substring(1);
                }
                if (str.length() < 6) {
                    return null;
                }
                while (str.length() < 8) {
                    str = "F" + str;
                }
                long rgb = Long.parseLong(str, 16);
                ret = new Color((int)rgb, true);
                CACHE.put(str, ret);
                return ret;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public void applyConfigDescriptionTextColor(JLabel lbl) {
        Color c = LAFOptions.createColor(this.cfg.getColorForConfigPanelDescriptionText());
        if (c != null) {
            lbl.setForeground(c);
        }
    }

    public boolean applyConfigLabelEnabledTextColor(JLabel lbl) {
        Color c = LAFOptions.createColor(this.cfg.getConfigLabelEnabledTextColor());
        if (c != null) {
            lbl.setForeground(c);
            return true;
        }
        return false;
    }

    public boolean applyConfigLabelDisabledTextColor(JLabel lbl) {
        Color c = LAFOptions.createColor(this.cfg.getConfigLabelDisabledTextColor());
        if (c != null) {
            lbl.setForeground(c);
            return true;
        }
        return false;
    }

    public void applyConfigHeaderTextColor(JLabel lbl) {
        Color c = LAFOptions.createColor(this.cfg.getColorForConfigHeaderTextColor());
        if (c != null) {
            lbl.setForeground(c);
        }
    }

    public void applyBackground(String color, JComponent field) {
        Color col = LAFOptions.createColor(color);
        if (col != null) {
            LAFOptions.applyBackground(col, field);
        }
    }

    public void applyPanelBackground(JComponent rightPanel) {
        this.applyBackground(this.cfg.getColorForPanelBackground(), rightPanel);
    }

    public Color getColorForPanelHeaderBackground() {
        return LAFOptions.createColor(this.cfg.getColorForPanelHeaderBackground());
    }

    public Color getColorForPanelBackground() {
        return LAFOptions.createColor(this.cfg.getColorForPanelBackground());
    }

    public static void applyBackground(Color color, JComponent field) {
        field.setBackground(color);
        field.setOpaque(true);
    }

    public Color getColorForTooltipForeground() {
        return LAFOptions.createColor(this.cfg.getColorForTooltipForeground());
    }

    public boolean isPaintStatusbarTopBorder() {
        return this.cfg.isPaintStatusbarTopBorder();
    }

    public Color getColorForErrorForeground() {
        return LAFOptions.createColor(this.cfg.getColorForErrorForeground());
    }

    public Color getColorForTableSelectedRowsForeground() {
        return LAFOptions.createColor(this.cfg.getColorForTableSelectedRowsForeground());
    }

    public Color getColorForTableSelectedRowsBackground() {
        return LAFOptions.createColor(this.cfg.getColorForTableSelectedRowsBackground());
    }

    public Color getColorForTableMouseOverRowForeground() {
        return LAFOptions.createColor(this.cfg.getColorForTableMouseOverRowForeground());
    }

    public Color getColorForTableMouseOverRowBackground() {
        return LAFOptions.createColor(this.cfg.getColorForTableMouseOverRowBackground());
    }

    public Color getColorForTableAlternateRowForeground() {
        return LAFOptions.createColor(this.cfg.getColorForTableAlternateRowForeground());
    }

    public Color getColorForTableAlternateRowBackground() {
        return LAFOptions.createColor(this.cfg.getColorForTableAlternateRowBackground());
    }

    public Color getColorForScrollbarsNormalState() {
        return LAFOptions.createColor(this.cfg.getColorForScrollbarsNormalState());
    }

    public Color getColorForScrollbarsMouseOverState() {
        return LAFOptions.createColor(this.cfg.getColorForScrollbarsMouseOverState());
    }

    public Color getColorForTableSortedColumnView() {
        return LAFOptions.createColor(this.cfg.getColorForTableSortedColumnView());
    }

    public Color getColorForTableFilteredView() {
        return LAFOptions.createColor(this.cfg.getColorForTableFilteredView());
    }

    public Color getColorForTablePackageRowForeground() {
        return LAFOptions.createColor(this.cfg.getColorForTablePackageRowForeground());
    }

    public Color getColorForTablePackageRowBackground() {
        return LAFOptions.createColor(this.cfg.getColorForTablePackageRowBackground());
    }

    public Color getColorForPanelHeaderForeGround() {
        return LAFOptions.createColor(this.cfg.getColorForPanelHeaderForeground());
    }

    public Color getColorForSpeedMeterAverage() {
        return LAFOptions.createColor(this.cfg.getColorForSpeedMeterAverage());
    }

    public Color getColorForSpeedMeterText() {
        return LAFOptions.createColor(this.cfg.getColorForSpeedMeterText());
    }

    public Color getColorForSpeedMeterAverageText() {
        return LAFOptions.createColor(this.cfg.getColorForSpeedMeterAverageText());
    }

    public Color getColorForSpeedmeterCurrentBottom() {
        return LAFOptions.createColor(this.cfg.getColorForSpeedmeterCurrentBottom());
    }

    public Color getColorForSpeedmeterCurrentTop() {
        return LAFOptions.createColor(this.cfg.getColorForSpeedmeterCurrentTop());
    }

    public Color getColorForSpeedmeterLimiterBottom() {
        return LAFOptions.createColor(this.cfg.getColorForSpeedmeterLimiterBottom());
    }

    public Color getColorForSpeedmeterLimiterTop() {
        return LAFOptions.createColor(this.cfg.getColorForSpeedmeterLimiterTop());
    }

    public Color getColorForTableAccountErrorRowForeground() {
        return LAFOptions.createColor(this.cfg.getColorForTableAccountErrorRowForeground());
    }

    public Color getColorForTableAccountErrorRowBackground() {
        return LAFOptions.createColor(this.cfg.getColorForTableAccountErrorRowBackground());
    }

    public Color getColorForTableAccountTempErrorRowForeground() {
        return LAFOptions.createColor(this.cfg.getColorForTableAccountTempErrorRowForeground());
    }

    public Color getColorForTableAccountTempErrorRowBackground() {
        return LAFOptions.createColor(this.cfg.getColorForTableAccountTempErrorRowBackground());
    }

    public Color getColorForProgressbar1() {
        return LAFOptions.createColor(this.cfg.getColorForProgressbarForeground1());
    }

    public Color getColorForProgressbar2() {
        return LAFOptions.createColor(this.cfg.getColorForProgressbarForeground2());
    }

    public Color getColorForProgressbar3() {
        return LAFOptions.createColor(this.cfg.getColorForProgressbarForeground3());
    }

    public Color getColorForProgressbar4() {
        return LAFOptions.createColor(this.cfg.getColorForProgressbarForeground4());
    }

    public Color getColorForProgressbar5() {
        return LAFOptions.createColor(this.cfg.getColorForProgressbarForeground5());
    }

    public Color getColorForLinkgrabberDupeHighlighter() {
        return LAFOptions.createColor(this.cfg.getColorForLinkgrabberDupeHighlighter());
    }

    public Color getColorForTableRowGap() {
        return LAFOptions.createColor(this.cfg.getColorForTableRowGap());
    }

    public Color getColorForPanelBorders() {
        return LAFOptions.createColor(this.cfg.getColorForPanelBorders());
    }

    static {
        CACHE = new HashMap();
    }
}

