/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2.restart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.appwork.utils.StringUtils;
import org.jdownloader.updatev2.restart.LinuxRestarter;

public class MacRestarter
extends LinuxRestarter {
    @Override
    protected File getRunInDirectory(File root) {
        File app = this.getApp(root);
        if (app.exists()) {
            return app.getParentFile();
        }
        return super.getRunInDirectory(root);
    }

    @Override
    protected List<String> getApplicationStartCommands(File root) {
        ArrayList<String> lst = new ArrayList<String>();
        File app = this.getApp(root);
        if (app.exists()) {
            lst.add("open");
            lst.add("-n");
            lst.add(app.getAbsolutePath());
            lst.add("--args");
            this.getLogger().info(lst + "");
            return lst;
        }
        this.getLogger().warning("MAX " + app + " is missing");
        return super.getApplicationStartCommands(root);
    }

    private File getApp(File root) {
        File ret;
        String moduleName = System.getProperty("exe4j.moduleName");
        if (StringUtils.isNotEmpty(moduleName) && moduleName.endsWith(".app") && (ret = new File(moduleName)).exists()) {
            this.getLogger().info("Found Modulename: " + moduleName);
            return ret;
        }
        ret = new File(root, "JDownloader2.app");
        if (ret.exists()) {
            this.getLogger().info("Found Launcher " + ret);
            return ret;
        }
        ret = new File(root, "JDownloader 2.app");
        if (ret.exists()) {
            this.getLogger().info("Found Launcher " + ret);
            return ret;
        }
        String appname = "JDownloader.app";
        File apppath = new File(root, "../../../../");
        try {
            this.getLogger().info("Look in " + apppath + " - " + apppath.getCanonicalPath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            HashSet<File> loopMap = new HashSet<File>();
            while (root != null && loopMap.add(root)) {
                this.getLogger().info(root.getCanonicalPath());
                if (root.getName().endsWith(".app")) {
                    apppath = root.getParentFile();
                    appname = root.getName();
                    this.getLogger().info("Found App: " + apppath);
                    break;
                }
                root = root.getParentFile();
            }
            if (root != null) {
                this.getLogger().info("APPNAME " + appname + " - " + root.getCanonicalPath());
            }
        }
        catch (IOException e) {
            this.getLogger().log(e);
        }
        return new File(apppath, appname);
    }
}

