/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.pac;

import com.btr.proxy.selector.pac.JavaxPacScriptParser;
import com.btr.proxy.selector.pac.PACScriptEngineFactory;
import com.btr.proxy.selector.pac.PacScriptParser;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.ProxyEvaluationException;
import com.btr.proxy.selector.pac.RhinoPacScriptParser;
import com.btr.proxy.selector.pac.ScriptAvailability;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.ProxyUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PacProxySelector
extends ProxySelector {
    public static PACScriptEngineFactory SCRIPT_ENGINE_FACTORY = new PACScriptEngineFactory(){
        private final boolean javaXEngineAvailable = ScriptAvailability.isJavaxScriptingAvailable();

        @Override
        public PacScriptParser selectEngine(PacProxySelector pacProxySelector, PacScriptSource pacSource) throws ProxyEvaluationException {
            if (this.javaXEngineAvailable) {
                Logger.log(this.getClass(), Logger.LogLevel.INFO, "Using javax.script JavaScript engine.", new Object[0]);
                return new JavaxPacScriptParser(pacSource);
            }
            Logger.log(this.getClass(), Logger.LogLevel.INFO, "Using Rhino JavaScript engine.", new Object[0]);
            return new RhinoPacScriptParser(pacSource);
        }
    };
    private static final String PAC_SOCKS = "SOCKS";
    private static final String PAC_DIRECT = "DIRECT";
    private PacScriptParser pacScriptParser;
    private static volatile boolean enabled = true;

    public PacProxySelector(PacScriptSource pacSource) {
        this.selectEngine(pacSource);
    }

    public static void setEnabled(boolean enable) {
        enabled = enable;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private void selectEngine(PacScriptSource pacSource) {
        try {
            this.pacScriptParser = SCRIPT_ENGINE_FACTORY.selectEngine(this, pacSource);
        }
        catch (Exception e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "PAC parser error.", e);
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI must not be null.");
        }
        if (!enabled) {
            return ProxyUtil.noProxyList();
        }
        return this.findProxy(uri);
    }

    private List<Proxy> findProxy(URI uri) {
        try {
            String[] proxyDefinitions;
            ArrayList<Proxy> proxies = new ArrayList<Proxy>();
            String parseResult = this.pacScriptParser.evaluate(uri.toString(), uri.getHost());
            for (String proxyDef : proxyDefinitions = parseResult.split("[;]")) {
                if (proxyDef.trim().length() <= 0) continue;
                proxies.add(this.buildProxyFromPacResult(proxyDef));
            }
            return proxies;
        }
        catch (ProxyEvaluationException e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "PAC resolving error.", e);
            return ProxyUtil.noProxyList();
        }
    }

    private Proxy buildProxyFromPacResult(String pacResult) {
        if (pacResult == null || pacResult.trim().length() < 6) {
            return Proxy.NO_PROXY;
        }
        String proxyDef = pacResult.trim();
        if (proxyDef.toUpperCase().startsWith(PAC_DIRECT)) {
            return Proxy.NO_PROXY;
        }
        Proxy.Type type = Proxy.Type.HTTP;
        if (proxyDef.toUpperCase().startsWith(PAC_SOCKS)) {
            type = Proxy.Type.SOCKS;
        }
        String host = proxyDef.substring(6);
        Integer port = 80;
        int indexOfPort = host.indexOf(58);
        int index2 = host.lastIndexOf(93);
        if (indexOfPort != -1 && index2 < indexOfPort) {
            port = Integer.parseInt(host.substring(indexOfPort + 1).trim());
            host = host.substring(0, indexOfPort).trim();
        }
        InetSocketAddress adr = InetSocketAddress.createUnresolved(host, port);
        return new Proxy(type, adr);
    }
}

