/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import org.appwork.controlling.State;
import org.appwork.controlling.StateEvent;
import org.appwork.controlling.StateEventListener;
import org.appwork.controlling.StateExceptionException;
import org.appwork.controlling.StateMachine;

public class StateLocker
implements StateEventListener {
    private StateMachine[] stateMachines;
    private int counter;
    private State waitState;
    private State[] exceptions;
    private State interruptState = null;
    private StateMachine interruptStatemachine;

    public StateLocker(StateMachine ... machines) {
        this.stateMachines = (StateMachine[])machines.clone();
        this.counter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockUntilAllHavePassed(State state, State ... exceptions) throws InterruptedException, StateExceptionException {
        this.waitState = state;
        this.exceptions = exceptions;
        if (this.stateMachines == null || this.stateMachines.length == 0) {
            return;
        }
        try {
            for (StateMachine st : this.stateMachines) {
                for (State e : exceptions) {
                    if (!st.hasPassed(e)) continue;
                    throw new StateExceptionException(st, e);
                }
                if (st.hasPassed(state)) {
                    this.increaseCounter();
                    continue;
                }
                st.addListener(this);
            }
            block8: while (this.counter < this.stateMachines.length) {
                StateLocker stateLocker = this;
                synchronized (stateLocker) {
                    this.wait(2000L);
                }
                if (this.interruptState != null) {
                    throw new StateExceptionException(this.interruptStatemachine, this.interruptState);
                }
                for (StateMachine st : this.stateMachines) {
                    if (!st.hasPassed(state)) continue block8;
                }
                break;
            }
        }
        finally {
            for (StateMachine st : this.stateMachines) {
                st.removeListener(this);
            }
        }
    }

    private synchronized int increaseCounter() {
        return ++this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStateChange(StateEvent event) {
        if (event.getNewState() == this.waitState) {
            if (this.increaseCounter() == this.stateMachines.length) {
                StateLocker stateLocker = this;
                synchronized (stateLocker) {
                    this.notify();
                }
                event.getStateMachine().removeListener(this);
            }
        } else {
            for (State s : this.exceptions) {
                if (event.getNewState() != s) continue;
                this.interruptState = s;
                this.interruptStatemachine = event.getStateMachine();
                StateLocker stateLocker = this;
                synchronized (stateLocker) {
                    this.notify();
                }
                return;
            }
        }
    }

    @Override
    public void onStateUpdate(StateEvent event) {
    }
}

