/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.streams.signature;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.appwork.io.streams.signature.SignatureMismatchException;

public class HoldBackInputStream
extends InputStream {
    private byte[] single;
    private byte[] tail;
    private int tailLength;
    private InputStream in;
    private byte[] readBuffer;
    private long rawBytesLoaded;
    private long payloadBytesLoaded;
    private boolean closed;
    private int bufferedBytes;
    private int extraBufferLength;
    private boolean eof;

    public byte[] getTail() {
        return this.tail;
    }

    public long getPayloadBytesLoaded() {
        return this.payloadBytesLoaded;
    }

    public HoldBackInputStream(InputStream is, int tailLength, int extraBufferLength) {
        this.in = is;
        this.single = new byte[1];
        this.tailLength = tailLength;
        this.extraBufferLength = extraBufferLength;
        this.readBuffer = new byte[128 + tailLength + extraBufferLength];
        this.rawBytesLoaded = 0L;
    }

    @Override
    public long skip(long n) throws IOException {
        int ret;
        if (n <= 0L) {
            return 0L;
        }
        long remaining = n;
        byte[] buff = new byte[2000];
        while (n > 0L && (ret = this.internalRead(buff, 0, (int)Math.min((long)buff.length, remaining))) >= 0) {
            remaining -= (long)ret;
        }
        return n - remaining;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        int ret;
        while ((ret = this.internalRead(this.single, 0, 1)) == 0) {
        }
        if (ret < 0) {
            return -1;
        }
        return this.single[0] & 0xFF;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.internalRead(b, off, len);
    }

    protected int internalRead(byte[] b, int off, int len) throws IOException, UnsupportedEncodingException, SignatureMismatchException {
        if (this.closed) {
            return -1;
        }
        if (this.tail != null) {
            return -1;
        }
        if (this.eof) {
            return this.onEOF(b, off, len);
        }
        int totalBuffer = this.tailLength + this.extraBufferLength;
        if (this.bufferedBytes < totalBuffer) {
            int ret = this.in.read(this.readBuffer, this.bufferedBytes, totalBuffer - this.bufferedBytes);
            if (ret >= 0) {
                this.rawBytesLoaded += (long)ret;
                this.bufferedBytes += ret;
            } else {
                throw new EOFException("Expected at least " + this.tailLength + 4 + " bytes");
            }
            return 0;
        }
        if (len > this.readBuffer.length) {
            System.arraycopy(this.readBuffer, 0, b, off, totalBuffer);
            int read = this.in.read(b, off + totalBuffer, len - totalBuffer);
            if (read == 0) {
                return 0;
            }
            if (read < 0) {
                return this.onEOF(b, off, len);
            }
            this.rawBytesLoaded += (long)read;
            System.arraycopy(b, off + read, this.readBuffer, 0, totalBuffer);
            this.payloadBytesLoaded += (long)read;
            return read;
        }
        int read = this.in.read(this.readBuffer, totalBuffer, Math.min(len, this.readBuffer.length - totalBuffer));
        if (read < 0) {
            return this.onEOF(b, off, len);
        }
        if (read > 0) {
            this.rawBytesLoaded += (long)read;
            System.arraycopy(this.readBuffer, 0, b, off, read);
            System.arraycopy(this.readBuffer, read, this.readBuffer, 0, totalBuffer);
            this.payloadBytesLoaded += (long)read;
        }
        return read;
    }

    protected int onEOF(byte[] b, int off, int len) {
        this.eof = true;
        int ret = -1;
        if (this.bufferedBytes > this.tailLength) {
            ret = Math.min(this.bufferedBytes - this.tailLength, len);
            System.arraycopy(this.readBuffer, 0, b, off, ret);
            System.arraycopy(this.readBuffer, ret, this.readBuffer, 0, this.tailLength);
            this.payloadBytesLoaded += (long)ret;
            this.bufferedBytes -= ret;
        }
        if (this.tail == null && this.bufferedBytes <= this.tailLength) {
            this.tail = new byte[Math.min(this.bufferedBytes, this.tailLength)];
            System.arraycopy(this.readBuffer, 0, this.tail, 0, Math.min(this.bufferedBytes, this.tailLength));
            this.bufferedBytes = 0;
        }
        if (this.tail != null) {
            this.closed = true;
        }
        return ret;
    }

    public long getRawBytesLoaded() {
        return this.rawBytesLoaded;
    }

    public void readFromBuffer(byte[] buffer) throws IOException {
        if (this.bufferedBytes < buffer.length) {
            throw new IOException("Not enough buffered bytes available");
        }
        System.arraycopy(this.readBuffer, 0, buffer, 0, buffer.length);
        if (buffer.length == this.bufferedBytes) {
            this.bufferedBytes = 0;
        } else {
            System.arraycopy(this.readBuffer, buffer.length, this.readBuffer, 0, buffer.length);
            this.bufferedBytes -= buffer.length;
        }
    }
}

