/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.moncompare;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.moncompare.AggregationException;
import org.appwork.moncompare.AggregationResult;
import org.appwork.moncompare.CannotGetValueException;
import org.appwork.moncompare.CompareException;
import org.appwork.moncompare.ConditionObjectValueView;
import org.appwork.moncompare.ConditionResult;
import org.appwork.moncompare.Operator;
import org.appwork.moncompare.Scope;
import org.appwork.remoteapi.annotations.ApiDoc;
import org.appwork.remoteapi.annotations.ApiDocExample;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableExample;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.InvalidPathException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.typemapper.DateMapper;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.simplejson.mapper.Getter;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.DebugMode;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.duration.InvalidTimeSpanException;
import org.appwork.utils.duration.TimeSpan;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.reflection.Clazz;

@ApiDoc(value="A Condition Object. See the WIKI for more details.")
@StorableExample(value="{\"$eq\":\"MyValue\"}")
public class Condition<MatcherType>
extends LinkedHashMap<String, Object>
implements Storable {
    public static final String CASE_INSENSITIVE = "caseInsensitive";
    private static final String $KEY = "\u00a7key";
    public static final String FILTER_ROOT = "filterRoot";
    public static final String $PROJECT = "\u00a7project";
    public static final String $$CURRENT = "\u00a7\u00a7CURRENT";
    @StorableDoc(value="Path Modifier: References the root document, i.e. the top-level document.")
    public static final String $$ROOT = "\u00a7\u00a7ROOT";
    @ApiDoc(value="Path Modifier:  \u00a7\u00a7THIS references the current scope object or field. Note: All field identifiers that start with \u00a7\u00a7 are absolute identifiers and MUST be places as first key element")
    @ApiDocExample(value="{'c':{'\u00a7gt':[{'\u00a7sum':['\u00a7\u00a7this',1]},0}}  '\u00a7\u00a7this' references to the field c, adds 1 and checks if the result is greater than 0")
    public static final String $$THIS = "\u00a7\u00a7THIS";
    public static final String $ADD = "\u00a7add";
    public static final String $AND = "\u00a7and";
    public static final String $ANY = "\u00a7any";
    @ApiDoc(value="Aggregation OP: concat all values to a single string")
    private static final String $CONCAT = "\u00a7concat";
    public static final String $DIVIDE = "\u00a7divide";
    public static final String $EACH = "\u00a7each";
    public static final String $EQ = "\u00a7eq";
    public static final String $EXISTS = "\u00a7exists";
    public static final String $GT = "\u00a7gt";
    public static final String $GTE = "\u00a7gte";
    public static final String $IGNORE_GETTER_EXCEPTIONS = "\u00a7ignoreGetterErrors";
    public static final String $IN = "\u00a7in";
    @ApiDoc(value="Path modifier. a.\u00a7keys returns all keys of the map a or all indizes of the list a")
    @ApiDocExample(value="a.\u00a7keys")
    public static final String $KEYS = "\u00a7keys";
    public static final String $LT = "\u00a7lt";
    public static final String $LTE = "\u00a7lte";
    public static final String $MAX = "\u00a7max";
    public static final String $MIN = "\u00a7min";
    public static final String $MULTIPLY = "\u00a7multiply";
    public static final String $NE = "\u00a7ne";
    public static final String $NIN = "\u00a7nin";
    public static final String $NOT = "\u00a7not";
    public static final String $NOW = "\u00a7\u00a7NOW";
    public static final String $OPTIONS = "\u00a7options";
    public static final String $OR = "\u00a7or";
    @ApiDoc(value="Path traversal identifier. Used to access parent fields in the matcher object - relative to the current scope. Usage is like ../../ in directory pathes")
    public static final String $PARENT = "\u00a7PARENT";
    public static final String $REGEX = "\u00a7regex";
    @ApiDoc(value="Aggregation OP: find a match in a string via regex\r\nParam 1:string\r\nParam 2:regex\r\nParam 3: matching group index(optional)")
    public static final String $REGEX_FIND_ONE = "\u00a7regexFindOne";
    @ApiDoc(value="Virtual field identifier. a.\u00a7size references length of an array, string, map or other objects")
    @ApiDocExample(value="a.\u00a7size")
    public static final String $SIZE = "\u00a7size";
    public static final String $SUBTRACT = "\u00a7subtract";
    public static final String $SUM = "\u00a7sum";
    @ApiDoc(value="Virtual field identifier. a.\u00a7type references the ClassName of 'a'")
    @ApiDocExample(value="a.\u00a7type")
    public static final String $TYPE = "\u00a7type";
    private static final Class[] EMPTY = new Class[0];
    protected static final EqOp EQOP = new EqOp();
    private static HashSet<String> IGNORE = new HashSet();
    private static final Object KEY_DOES_NOT_EXIST = new Object(){

        public String toString() {
            return "KEY_DOES_NOT_EXIST";
        }
    };
    private static final ThreadLocal<Long> now = new ThreadLocal();
    private static final ThreadLocal<Condition> ROOT_CONDITION = new ThreadLocal();
    public static final ThreadLocal<Map<String, OpHandler>> OPERATIONS = new ThreadLocal();
    private static final HashMap<String, Operator> OPS = new HashMap();
    @ApiDoc(value="Set this option to true to force all operators in the same layer to work in aggregation mode.")
    @ApiDocExample(value="{\u00a7eq:['\u00a7a',1],\u00a7options:{'aggregate':true}}")
    public static final String OPTIONS_AGGREGATE = "aggregate";
    public static final ThreadLocal<Map<String, PathHandler>> PATH_HANDLERS = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    public static final TypeRef<Condition> TYPE = new TypeRef<Condition>(Condition.class){};
    protected volatile HashMap<KeyOnClass, AccessMethod> accessCache = new HashMap();
    protected volatile HashMap<Object, Object> cache = new HashMap();
    protected HashMap<String, PathHandler> customPathhandlers;
    protected final boolean useAccessCache = true;
    private LogInterface logger;
    public static final String $FIRST = "\u00a7first";
    private boolean debug = false;
    public static final ThreadLocal<Boolean> THREAD_DEBUG;
    public static final ThreadLocal<LogInterface> THREAD_LOGGER;

    public static OpHandler putThreadOPHandler(String key, OpHandler handler) {
        Map<String, OpHandler> map = OPERATIONS.get();
        if (map == null) {
            map = new HashMap<String, OpHandler>();
        }
        return map.put(key, handler);
    }

    public Object unwrap(Object resolve) {
        if (resolve instanceof ConditionResult) {
            return ((ConditionResult)resolve).getValue();
        }
        return resolve;
    }

    public Date toDate(Object expression) throws CompareException {
        if (expression == null) {
            return null;
        }
        if (expression instanceof Date) {
            return (Date)expression;
        }
        if (expression instanceof String) {
            try {
                return DateMapper.parseJsonDefault(String.valueOf(expression));
            }
            catch (FlexiMapperException e) {
                throw new CompareException(e);
            }
        }
        if (expression instanceof Number) {
            return new Date(((Number)expression).longValue());
        }
        throw new CompareException("Cannot compare " + expression + " to a Date instance");
    }

    public TimeSpan toTimeSpan(Object expression) throws CompareException {
        if (expression == null) {
            return null;
        }
        if (expression instanceof TimeSpan) {
            return ((TimeSpan)expression).withFallbackAverageYearContext();
        }
        if (expression instanceof String) {
            try {
                return TimeSpan.parse(String.valueOf(expression)).withFallbackAverageYearContext();
            }
            catch (InvalidTimeSpanException e) {
                throw new CompareException(e);
            }
        }
        if (expression instanceof Number) {
            return TimeSpan.fromMillis(((Number)expression).longValue()).withFallbackAverageYearContext();
        }
        throw new CompareException("Cannot compare " + expression + " to a TimeSpan instance");
    }

    public static <Input, Output> OpHandler putThreadResolver(String key, ConditionResolver<Input, Output> resolver) {
        Map<String, OpHandler> map = OPERATIONS.get();
        if (map == null) {
            map = new HashMap<String, OpHandler>();
        }
        OpHandler ret = map.put(key, new ResolverOPHandler<Input, Output>(key, resolver));
        OPERATIONS.set(map);
        return ret;
    }

    private static boolean removeThreadOPHandler(String key) {
        Map<String, OpHandler> map = OPERATIONS.get();
        if (map == null) {
            return false;
        }
        if (map.remove(key) != null) {
            OPERATIONS.set(map);
        }
        return false;
    }

    public static boolean removeThreadResolver(String key) {
        return Condition.removeThreadOPHandler(key);
    }

    public LogInterface _getLogger() {
        return this.logger;
    }

    public void _setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public Condition() {
    }

    public Condition(Map<String, Object> condition) {
        super(condition);
    }

    public Condition(String key, Object o) {
        this.append(key, o);
    }

    public Condition append(String key, Object o) {
        this.put(key, o);
        return this;
    }

    @Override
    public void clear() {
        this.clearCache();
        super.clear();
    }

    protected void clearCache() {
        if (this.cache.size() > 0) {
            this.cache = new HashMap();
        }
        if (this.accessCache.size() > 0) {
            this.accessCache = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equalsDeep(Condition container, Object expression, Object matcherValue, Scope scope) throws CompareException {
        if (expression == matcherValue) {
            return true;
        }
        if (expression == null && matcherValue != null) {
            return false;
        }
        if (matcherValue == null) {
            return false;
        }
        if (this.equalsShallow(container, expression, matcherValue, scope)) {
            return true;
        }
        if (ReflectionUtils.isListOrArray(expression) && ReflectionUtils.isListOrArray(matcherValue)) {
            List<Object> listExpression = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
            List<Object> listMatcher = ReflectionUtils.wrapUnmodifiableList(matcherValue, Object.class);
            if (listExpression.size() != listMatcher.size()) {
                return false;
            }
            ListIterator<Object> e1 = listExpression.listIterator();
            ListIterator<Object> e2 = listMatcher.listIterator();
            int i = 0;
            while (e1.hasNext() && e2.hasNext()) {
                Object o2;
                Object o1 = e1.next();
                if (o1 == (o2 = e2.next())) continue;
                scope.add(o2, i++);
                try {
                    if (o1 instanceof Condition) {
                        Object result = ((Condition)o1).evaluateInternal(scope);
                        if (!this.isFalse(result)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    if (this.equalsDeep(container, o1, o2, scope)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    scope.removeLast();
                }
            }
            return true;
        }
        if (expression instanceof Condition) {
            Object result = ((Condition)expression).evaluateInternal(scope);
            return ((Condition)expression).isTrue(result);
        }
        if (expression instanceof Map && matcherValue instanceof Map) {
            DebugMode.debugger();
            if (((Map)expression).size() != ((Map)matcherValue).size()) {
                return false;
            }
            if (!CompareUtils.equals(((Map)expression).keySet(), ((Map)matcherValue).keySet())) {
                return false;
            }
            for (Map.Entry es : ((Map)expression).entrySet()) {
                if (this.equalsDeep(container, es.getValue(), ((Map)matcherValue).get(es.getKey()), scope)) continue;
                return false;
            }
            return true;
        }
        if (expression.getClass() == matcherValue.getClass()) {
            if (Clazz.isPrimitive(expression.getClass()) || Clazz.isEnum(expression.getClass()) || Clazz.isString(expression.getClass())) {
                return false;
            }
            try {
                ClassCache cc = ClassCache.getClassCache(expression.getClass());
                for (Getter c : cc.getGetter()) {
                    if (this.equalsDeep(container, c.getValue(expression), c.getValue(matcherValue), scope)) continue;
                    return false;
                }
                return true;
            }
            catch (SecurityException e) {
                throw new WTFException(e);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            catch (IllegalArgumentException e) {
                throw new WTFException(e);
            }
            catch (IllegalAccessException e) {
                throw new WTFException(e);
            }
            catch (InvocationTargetException e) {
                throw new WTFException(e);
            }
        }
        return expression.equals(matcherValue);
    }

    public boolean equalsShallow(Condition container, Object expression, Object matcherValue, Scope scope) throws CompareException {
        Object options;
        if (expression == matcherValue) {
            return true;
        }
        if (expression == null || matcherValue == null) {
            return false;
        }
        Object resolvedExpression = this.resolveValue(container, expression, scope, false);
        if (resolvedExpression == matcherValue) {
            DebugMode.debugger();
            return true;
        }
        if (resolvedExpression instanceof AggregationResult && (AggregationResult)resolvedExpression == matcherValue) {
            DebugMode.debugger();
            return true;
        }
        if (resolvedExpression instanceof Number && matcherValue instanceof Number) {
            return CompareUtils.equalsNumber((Number)resolvedExpression, (Number)matcherValue);
        }
        if (matcherValue.getClass().isEnum() && resolvedExpression instanceof String) {
            return StringUtils.equals(matcherValue.toString(), (String)resolvedExpression);
        }
        if (resolvedExpression instanceof String && matcherValue instanceof String && (options = this.get($OPTIONS)) != null && options instanceof Map && Boolean.TRUE.equals(((Condition)options).get(CASE_INSENSITIVE))) {
            return StringUtils.equalsIgnoreCase((String)resolvedExpression, (String)matcherValue);
        }
        if (resolvedExpression instanceof ConditionResult) {
            resolvedExpression = container.unwrap(resolvedExpression);
        }
        return CompareUtils.equals(matcherValue, resolvedExpression);
    }

    public Object evaluate(Object matcher) throws CompareException {
        return this.unwrap(this.evaluateInternal(new Scope(matcher)));
    }

    /*
     * Exception decompiling
     */
    public Object evaluateInternal(Scope scope) throws CompareException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean isFalse(Object lastResult) {
        if (lastResult instanceof ConditionResult) {
            return ((ConditionResult)lastResult).isFalse();
        }
        return lastResult == Boolean.FALSE;
    }

    protected void fixInternalMapToCondition() throws CompareException {
        for (Map.Entry entry : this.entrySet()) {
            if (!(entry.getValue() instanceof Map) || entry.getValue() instanceof Condition) continue;
            Condition condition = this.newInstance();
            condition.putAll((Map)entry.getValue());
            this.replace((String)entry.getKey(), entry.getValue(), (Object)condition);
            entry.setValue(condition);
        }
    }

    protected AccessMethod getAccessMethod(KeyOnClass key) {
        return this.accessCache.get(key);
    }

    protected Object getCache(Object key) {
        return this.cache.get(key);
    }

    private boolean isForbiddenField(Field field) {
        return !Modifier.isPublic(field.getModifiers());
    }

    private boolean isForbiddenMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return true;
        }
        return Clazz.isVoid(method.getReturnType());
    }

    public Scope resolveKeyPath(Scope scope, JSPath keyPath) throws CompareException {
        Scope ret = scope.copy();
        block27: for (Object keyOrg : keyPath.getElements()) {
            KeyOnClass cacheKey;
            AccessMethod accessMethod;
            Map<String, PathHandler> threadPathHandlers;
            if (keyOrg instanceof Condition) {
                Condition filter = (Condition)keyOrg;
                ret.add(filter.evaluateInternal(ret), keyOrg);
                continue;
            }
            String key = StringUtils.valueOfOrNull(keyOrg);
            if (this.customPathhandlers != null) {
                for (Map.Entry<String, PathHandler> es : this.customPathhandlers.entrySet()) {
                    Scope r;
                    if (es.getKey() != null && !((String)es.getKey()).equalsIgnoreCase(key) || (r = ((PathHandler)es.getValue()).resolve(scope, ret, keyOrg)) == null) continue;
                    ret = r;
                    continue block27;
                }
            }
            if ((threadPathHandlers = PATH_HANDLERS.get()) != null) {
                Map.Entry<String, PathHandler> es;
                es = threadPathHandlers.entrySet().iterator();
                while (es.hasNext()) {
                    Scope r;
                    Map.Entry es2 = (Map.Entry)es.next();
                    if (es2.getKey() != null && !((String)es2.getKey()).equalsIgnoreCase(key) || (r = ((PathHandler)es2.getValue()).resolve(scope, ret, keyOrg)) == null) continue;
                    ret = r;
                    continue block27;
                }
            }
            if ($$ROOT.equalsIgnoreCase(key)) {
                if (key != keyPath.getFirst()) {
                    throw new CompareException("PathLink \u00a7\u00a7... must always be the first key element");
                }
                ret = new Scope(scope.getFirst());
                continue;
            }
            if ($$THIS.equalsIgnoreCase(key) || $$CURRENT.equalsIgnoreCase(key)) {
                if (key != keyPath.getFirst()) {
                    throw new CompareException("PathLink \u00a7\u00a7... must always be the first key element");
                }
                ret.add(scope.getLast(), keyOrg);
                continue;
            }
            if ($PARENT.equalsIgnoreCase(key)) {
                if ((ret = ret.getParent()) != null) continue;
                ret = new Scope(KEY_DOES_NOT_EXIST);
                this.onKeyDoesNotExist(scope, keyPath, ret);
                return ret;
            }
            if ($NOW.equalsIgnoreCase(key)) {
                ret = new Scope(now.get());
                continue;
            }
            if ($TYPE.equalsIgnoreCase(key)) {
                ret.add(ret.getLast().getClass().getName(), key);
                continue;
            }
            if ($KEYS.equalsIgnoreCase(key)) {
                ret.add(this.listKeys(ret.getLast()), keyOrg);
                continue;
            }
            if ($KEY.equalsIgnoreCase(key)) {
                List<Object> loop = ret.getPath().getElements();
                for (int backlog = 0; backlog < loop.size(); ++backlog) {
                    Object el = loop.get(loop.size() - backlog - 1);
                    if (el instanceof String && OPS.containsKey(el)) {
                        continue;
                    }
                    ret.add(el, keyOrg);
                    continue block27;
                }
                continue;
            }
            if ($FIRST.equalsIgnoreCase(key)) {
                if (ReflectionUtils.isListOrArray(ret.getLast())) {
                    if (ReflectionUtils.getListLength(ret.getLast()) == 0) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        continue;
                    }
                    ret.add(ReflectionUtils.getListElement(ret.getLast(), 0), keyOrg);
                    continue;
                }
                if (ret.getLast() instanceof Collection) {
                    Iterator it = ((Collection)ret.getLast()).iterator();
                    if (!it.hasNext()) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        continue;
                    }
                    ret.add(it.next(), keyOrg);
                    continue;
                }
                if (ret.getLast() instanceof Map) {
                    if (((Map)ret.getLast()).size() == 0) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        continue;
                    }
                    ret.add(((Map)ret.getLast()).values().iterator().next(), keyOrg);
                    continue;
                }
                ret.add(ret.getLast(), keyOrg);
                continue;
            }
            if ($SIZE.equalsIgnoreCase(key)) {
                if (ReflectionUtils.isListOrArray(ret.getLast())) {
                    ret.add(ReflectionUtils.getListLength(ret.getLast()), keyOrg);
                    continue;
                }
                if (ret.getLast() instanceof Collection) {
                    int i = 0;
                    for (Object e : (Collection)ret.getLast()) {
                        ++i;
                    }
                    ret.add(i, keyOrg);
                    continue;
                }
                if (ret.getLast() instanceof Map) {
                    ret.add(((Map)ret.getLast()).size(), keyOrg);
                    continue;
                }
                if (ret.getLast() instanceof String) {
                    ret.add(((String)ret.getLast()).length(), keyOrg);
                    continue;
                }
                ret.add(this.listKeys(ret.getLast()).size(), keyOrg);
                continue;
            }
            if (ret.getLast() == null) {
                ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                this.onKeyDoesNotExist(scope, keyPath, ret);
                return ret;
            }
            if (key != null && key.startsWith("\u00a7")) {
                key = key.substring(1);
            }
            if ((accessMethod = this.getAccessMethod(cacheKey = new KeyOnClass(ret.getLast().getClass(), key))) != null) {
                try {
                    ret.add(accessMethod.getValue(ret.getLast(), key), keyOrg);
                    if (ret.getLast() != KEY_DOES_NOT_EXIST) continue;
                    this.onKeyDoesNotExist(scope, keyPath, ret);
                    continue;
                }
                catch (CannotGetValueException e) {
                    DebugMode.debugger();
                    if (Boolean.TRUE.equals(this.get($IGNORE_GETTER_EXCEPTIONS))) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        if (ret.getLast() == KEY_DOES_NOT_EXIST) {
                            this.onKeyDoesNotExist(scope, keyPath, ret);
                        }
                        return ret;
                    }
                    throw new CompareException(e);
                }
            }
            if (ret.getLast() instanceof ConditionObjectValueView) {
                ConditionObjectValueView view = (ConditionObjectValueView)ret.getLast();
                Object newValue = view.getConditionObjectValue(key);
                if (newValue == null) {
                    if (view.containsConditionObjectKey(key)) {
                        System.out.println("Check of we can return here 1");
                        ret.add(null, keyOrg);
                        return ret;
                    }
                    if (!view.isConditionObjectVisible()) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        this.onKeyDoesNotExist(scope, keyPath, ret);
                        return ret;
                    }
                } else {
                    ret.add(newValue, keyOrg);
                    if (ret.getLast() != KEY_DOES_NOT_EXIST) continue;
                    this.onKeyDoesNotExist(scope, keyPath, ret);
                    continue;
                }
            }
            if (ret.getLast() instanceof Map) {
                accessMethod = new AccessMapElement();
                this.putAccessMethod(cacheKey, accessMethod);
                try {
                    ret.add(accessMethod.getValue(ret.getLast(), key), keyOrg);
                    if (ret.getLast() != KEY_DOES_NOT_EXIST) continue;
                    this.onKeyDoesNotExist(scope, keyPath, ret);
                    continue;
                }
                catch (CannotGetValueException e) {
                    if (Boolean.TRUE.equals(this.get($IGNORE_GETTER_EXCEPTIONS))) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        this.onKeyDoesNotExist(scope, keyPath, ret);
                        return ret;
                    }
                    throw new CompareException(e);
                }
            }
            if (ReflectionUtils.isListOrArray(ret.getLast())) {
                Class<?> raw = ReflectionUtils.getRaw(ret.getLast().getClass());
                accessMethod = raw.isArray() ? new AccessArrayElement() : new AccessListElement();
                this.putAccessMethod(cacheKey, accessMethod);
                try {
                    ret.add(accessMethod.getValue(ret.getLast(), key), keyOrg);
                    if (ret.getLast() != KEY_DOES_NOT_EXIST) continue;
                    this.onKeyDoesNotExist(scope, keyPath, ret);
                    continue;
                }
                catch (CannotGetValueException e) {
                    if (Boolean.TRUE.equals(this.get($IGNORE_GETTER_EXCEPTIONS))) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        this.onKeyDoesNotExist(scope, keyPath, ret);
                        return ret;
                    }
                    throw new CompareException(e);
                }
            }
            if (ret.getLast() instanceof Collection) {
                accessMethod = new AccessCollectionElement();
                this.putAccessMethod(cacheKey, accessMethod);
                try {
                    ret.add(accessMethod.getValue(ret.getLast(), key), keyOrg);
                    if (ret.getLast() != KEY_DOES_NOT_EXIST) continue;
                    this.onKeyDoesNotExist(scope, keyPath, ret);
                    continue;
                }
                catch (CannotGetValueException e) {
                    if (Boolean.TRUE.equals(this.get($IGNORE_GETTER_EXCEPTIONS))) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        this.onKeyDoesNotExist(scope, keyPath, ret);
                        return ret;
                    }
                    throw new CompareException(e);
                }
            }
            Class<?> cls = ret.getLast().getClass();
            Method method = null;
            try {
                ClassCache cc = ClassCache.getClassCache(cls);
                Getter getter = cc.getGetter(key);
                if (getter != null && !this.isForbiddenMethod(getter.method)) {
                    method = getter.method;
                }
            }
            catch (SecurityException e) {
                throw new CompareException("Cannot get value", e);
            }
            catch (NoSuchMethodException e) {
                throw new CompareException("Cannot get value", e);
            }
            if (method == null) {
                method = null;
                String methodKey = Character.toUpperCase(key.charAt(0)) + key.substring(1);
                while (cls != null) {
                    try {
                        method = cls.getDeclaredMethod("is" + methodKey, EMPTY);
                        if (!this.isForbiddenMethod(method)) break;
                        method = null;
                    }
                    catch (SecurityException e) {
                        throw new CompareException("Cannot get value", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new CompareException("Cannot get value", e);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    try {
                        method = cls.getDeclaredMethod("get" + methodKey, EMPTY);
                        if (!this.isForbiddenMethod(method)) break;
                        method = null;
                    }
                    catch (SecurityException e) {
                        throw new CompareException("Cannot get value", e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new CompareException("Cannot get value", e);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                    cls = cls.getSuperclass();
                }
            }
            if (method != null) {
                method.setAccessible(true);
                accessMethod = new AccessByMethod(method);
                this.putAccessMethod(cacheKey, accessMethod);
                try {
                    ret.add(accessMethod.getValue(ret.getLast(), key), keyOrg);
                    if (ret.getLast() != KEY_DOES_NOT_EXIST) continue;
                    this.onKeyDoesNotExist(scope, keyPath, ret);
                    continue;
                }
                catch (CannotGetValueException e) {
                    if (Boolean.TRUE.equals(this.get($IGNORE_GETTER_EXCEPTIONS))) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        this.onKeyDoesNotExist(scope, keyPath, ret);
                        return ret;
                    }
                    throw new CompareException(e);
                }
            }
            Field field = null;
            for (cls = ret.getLast().getClass(); cls != null; cls = cls.getSuperclass()) {
                try {
                    field = cls.getDeclaredField(key);
                    if (!this.isForbiddenField(field)) break;
                    field = null;
                    continue;
                }
                catch (SecurityException e) {
                    throw new CompareException("Cannot get value", e);
                }
                catch (IllegalArgumentException e) {
                    throw new CompareException("Cannot get value", e);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            if (field != null) {
                field.setAccessible(true);
                accessMethod = new AccessByField(field);
                this.putAccessMethod(cacheKey, accessMethod);
                try {
                    ret.add(accessMethod.getValue(ret.getLast(), key), keyOrg);
                    if (ret.getLast() != KEY_DOES_NOT_EXIST) continue;
                    this.onKeyDoesNotExist(scope, keyPath, ret);
                    continue;
                }
                catch (CannotGetValueException e) {
                    if (Boolean.TRUE.equals(this.get($IGNORE_GETTER_EXCEPTIONS))) {
                        ret.add(KEY_DOES_NOT_EXIST, keyOrg);
                        this.onKeyDoesNotExist(scope, keyPath, ret);
                        return ret;
                    }
                    throw new CompareException(e);
                }
            }
            this.putAccessMethod(cacheKey, new AccessNotFound());
            ret.add(KEY_DOES_NOT_EXIST, keyOrg);
            this.onKeyDoesNotExist(scope, keyPath, ret);
            return ret;
        }
        return ret;
    }

    protected void onKeyDoesNotExist(Scope scope, JSPath keyPath, Scope ret) {
        if (this._isDebug()) {
            this.log(ret.getPath(), "Key Does not Exist: " + scope.getPath().toPathString(false) + " + " + keyPath.toPathString(false));
        }
    }

    public List<String> listKeys(Object obj) throws CompareException {
        if (obj == null || Clazz.isPrimitive(obj.getClass()) || obj instanceof String) {
            return Arrays.asList(new String[0]);
        }
        if (obj instanceof ConditionObjectValueView) {
            ConditionObjectValueView view = (ConditionObjectValueView)obj;
            return view.listConditionKeys();
        }
        if (obj instanceof Map) {
            return new ArrayList<String>(((Map)obj).keySet());
        }
        if (ReflectionUtils.isListOrArray(obj)) {
            int length = ReflectionUtils.getListLength(obj);
            ArrayList<String> ret = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                ret.add(String.valueOf(i));
            }
            return ret;
        }
        if (obj instanceof Collection) {
            int i = 0;
            ArrayList<String> ret = new ArrayList<String>(0);
            for (Object o : (Collection)obj) {
                ret.add(String.valueOf(i++));
            }
            return ret;
        }
        HashSet<String> ret = new HashSet<String>();
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                for (Method method : cls.getDeclaredMethods()) {
                    if (ClassCache.getParameterCount(method) > 0 || this.isForbiddenMethod(method)) continue;
                    ret.add(method.getName());
                    if (method.getName().startsWith("is")) {
                        ret.add(method.getName().substring(2, 3).toLowerCase(Locale.ROOT) + method.getName().substring(3));
                        continue;
                    }
                    if (!method.getName().startsWith("get")) continue;
                    ret.add(method.getName().substring(3, 4).toLowerCase(Locale.ROOT) + method.getName().substring(4));
                }
                for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                    if (this.isForbiddenField((Field)accessibleObject)) continue;
                    ret.add(((Field)accessibleObject).getName());
                }
                continue;
            }
            catch (SecurityException e) {
                throw new CompareException("Cannot get value", e);
            }
            catch (IllegalArgumentException e) {
                throw new CompareException("Cannot get value", e);
            }
        }
        return new ArrayList<String>(ret);
    }

    public boolean matches(MatcherType obj) throws CompareException {
        if (this._isDebug()) {
            this.log(new JSPath(), "Run " + this + ".matches(" + obj + ")");
        }
        Object result = this.evaluateInternal(new Scope(obj));
        return this.isTrue(result);
    }

    private boolean isTrue(Object result) {
        if (result instanceof ConditionResult) {
            return ((ConditionResult)result).isTrue();
        }
        return Boolean.TRUE == result;
    }

    private void log(JSPath path, String string) {
        if (this.logger != null) {
            this.logger.info(path.toPathString(false) + " : " + string);
        } else {
            Condition root = ROOT_CONDITION.get();
            if (root != null && root != this && root.logger != null) {
                root.log(path, string);
                return;
            }
        }
        LogInterface log = THREAD_LOGGER.get();
        if (log != null) {
            log.info(path.toPathString(false) + " : " + string);
        }
    }

    public boolean _isDebug() {
        if (this.debug) {
            return true;
        }
        Condition root = ROOT_CONDITION.get();
        if (root != null && root != this && root._isDebug()) {
            return true;
        }
        return THREAD_DEBUG.get() == Boolean.TRUE;
    }

    public void _setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean matchesWithoutExceptions(MatcherType test) {
        try {
            return this.matches(test);
        }
        catch (CompareException e) {
            LogV3.log(e);
            return false;
        }
    }

    public Condition newInstance() {
        return new Condition<MatcherType>();
    }

    @Override
    public Object put(String key, Object value) {
        key = this.correctKey(key);
        this.clearCache();
        return super.put(key, value);
    }

    public String correctKey(String key) {
        if (key.startsWith("$$")) {
            key = "\u00a7\u00a7" + key.substring(2);
        } else if (key.startsWith("$")) {
            key = "\u00a7" + key.substring(1);
        }
        return key;
    }

    protected void putAccessMethod(KeyOnClass key, AccessMethod method) {
        HashMap<KeyOnClass, AccessMethod> newCache = new HashMap<KeyOnClass, AccessMethod>(this.accessCache);
        newCache.put(key, method);
        this.accessCache = newCache;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> es : m.entrySet()) {
            this.put(es.getKey(), es.getValue());
        }
    }

    protected void putCache(Object key, Object object) {
        HashMap<Object, Object> newCache = new HashMap<Object, Object>(this.cache);
        newCache.put(key, object);
        this.cache = newCache;
    }

    @Override
    public Object remove(Object key) {
        this.clearCache();
        return super.remove(key);
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        this.clearCache();
        return super.replace(key, oldValue, newValue);
    }

    protected static final CharSequence toCharSequence(Object value) {
        if (value instanceof CharSequence) {
            return (CharSequence)value;
        }
        return String.valueOf(value);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super Object, ? extends Object> function) {
        this.clearCache();
        super.replaceAll(function);
    }

    public Object resolveValue(Condition container, Object expression, Scope scope, boolean unwrapConditionResults) throws CompareException {
        Object before = expression;
        if (expression instanceof Map && !(expression instanceof Condition)) {
            Map old = (Map)expression;
            expression = this.newInstance();
            ((Condition)expression).putAll(old);
        }
        if (expression instanceof Condition) {
            expression = ((Condition)expression).evaluateInternal(scope);
        }
        if (expression instanceof String && ((String)expression).startsWith("\u00a7")) {
            try {
                expression = this.resolveKeyPath(scope, JSPath.fromPathString((String)expression)).getLast();
            }
            catch (InvalidPathException e) {
                throw new CompareException(e);
            }
        }
        if (before != expression && container._isDebug()) {
            container.log(scope.getPath(), "Resolved " + before + " = " + expression);
        }
        if (unwrapConditionResults) {
            return container.unwrap(expression);
        }
        return expression;
    }

    @Override
    public String toString() {
        return "Condition: " + super.toString();
    }

    public static <T> List<T> find(Collection<T> values, Condition condition) throws CompareException {
        ArrayList<T> ret = new ArrayList<T>();
        for (T v : values) {
            if (!condition.matches(v)) continue;
            ret.add(v);
        }
        return ret;
    }

    public static Object resolve(String keyString, Object object) throws CompareException, InvalidPathException {
        Condition c = new Condition();
        Scope ret = c.resolveKeyPath(new Scope(object), JSPath.fromPathString(keyString));
        return ret.getLast();
    }

    public Object convertSpecialTypes(Object expression, Object matcherValue) throws CompareException {
        if (matcherValue instanceof TimeSpan) {
            expression = this.toTimeSpan(expression);
        } else if (matcherValue instanceof Date) {
            expression = this.toDate(expression);
        }
        return expression;
    }

    static {
        IGNORE.add($OPTIONS);
        IGNORE.add($IGNORE_GETTER_EXCEPTIONS);
        OPS.put($GTE, new NumberOp(NumberOp.OP.GTE));
        OPS.put($GT, new NumberOp(NumberOp.OP.GT));
        OPS.put($LTE, new NumberOp(NumberOp.OP.LTE));
        OPS.put($LT, new NumberOp(NumberOp.OP.LT));
        OPS.put($EQ, EQOP);
        OPS.put($IN, new InOp());
        OPS.put($EXISTS, new ExistsOp());
        OPS.put($NE, new NotEqualsOp());
        OPS.put($NIN, new NinOp());
        OPS.put($REGEX, new RegexOp());
        OPS.put($OR, new OrOp());
        OPS.put($AND, new AndOp());
        OPS.put($EACH, new EachOp());
        OPS.put($PROJECT, new ProjectOp());
        OPS.put($ANY, new AnyOp());
        OPS.put($NOT, new NotOp());
        OPS.put($ADD, new AddOp());
        OPS.put($SUBTRACT, new SubtractOp());
        OPS.put($SUM, new SumOp());
        OPS.put($MIN, new MinOp());
        OPS.put($MAX, new MaxOp());
        OPS.put($DIVIDE, new DivideOp());
        OPS.put($MULTIPLY, new MultiplyOp());
        OPS.put($CONCAT, new ConcatOp());
        OPS.put($REGEX_FIND_ONE, new RegexFindOp());
        THREAD_DEBUG = new ThreadLocal();
        THREAD_LOGGER = new ThreadLocal();
    }

    public static class SumOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            if (expression instanceof Number) {
                return expression;
            }
            if (ReflectionUtils.isListOrArray(expression.getClass())) {
                int length = ReflectionUtils.getListLength(expression);
                Number result = null;
                for (int index = 0; index < length; ++index) {
                    Number num;
                    block7: {
                        Object value = ReflectionUtils.getListElement(expression, index);
                        num = 0;
                        try {
                            if (ReflectionUtils.isListOrArray(value.getClass()) && length == 1) {
                                num = (Number)this.opEval(container, value, scope);
                                break block7;
                            }
                            if ((value = container.resolveValue(container, value, scope, true)) instanceof Number) {
                                num = (Number)value;
                            }
                            if (!ReflectionUtils.isListOrArray(value.getClass())) break block7;
                            num = (Number)this.opEval(container, value, scope);
                        }
                        catch (AggregationException e) {
                            continue;
                        }
                    }
                    result = result == null ? (Number)num : (Number)(Clazz.isDouble(result.getClass()) || Clazz.isDouble(num.getClass()) ? (Number)(result.doubleValue() + num.doubleValue()) : (Number)(Clazz.isFloat(result.getClass()) || Clazz.isFloat(num.getClass()) ? (Number)Float.valueOf(result.floatValue() + num.floatValue()) : (Number)(result.longValue() + num.longValue())));
                }
                return result;
            }
            return 0;
        }
    }

    public static class SubtractOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expressions, Scope scope) throws CompareException {
            if (ReflectionUtils.isListOrArray(expressions.getClass())) {
                List<Object> listExpressions = ReflectionUtils.wrapUnmodifiableList(expressions, Object.class);
                Number result = null;
                for (Object expression : listExpressions) {
                    Number num = (Number)container.resolveValue(container, expression, scope, true);
                    if (result == null) {
                        result = num;
                        continue;
                    }
                    if (Clazz.isDouble(result.getClass()) || Clazz.isDouble(num.getClass())) {
                        result = result.doubleValue() - num.doubleValue();
                        continue;
                    }
                    if (Clazz.isFloat(result.getClass()) || Clazz.isFloat(num.getClass())) {
                        result = Float.valueOf(result.floatValue() - num.floatValue());
                        continue;
                    }
                    result = result.longValue() - num.longValue();
                }
                return new AggregationResult(result);
            }
            throw new AggregationException("SubstracOp:" + container + "|" + expressions);
        }
    }

    public static class ResolverOPHandler<Input, Output>
    implements OpHandler {
        private final String key;
        private final ConditionResolver<Input, Output> resolver;

        public ResolverOPHandler(String key, ConditionResolver<Input, Output> resolver) {
            this.key = key;
            this.resolver = resolver;
        }

        @Override
        public Object opEval(Condition<?> container, Object query, Scope matcher) throws CompareException {
            if (query instanceof Condition) {
                Condition cQuery = (Condition)query;
                Map options = (Map)cQuery.get(Condition.$OPTIONS);
                if (options == null) {
                    throw new CompareException("\u00a7options property is missing. Add \u00a7options." + this.key.substring(1));
                }
                Object parameters = options.get(this.key.substring(1));
                if (parameters == null) {
                    throw new CompareException("\u00a7options." + this.key.substring(1) + " property is missing");
                }
                Output resolved = this.resolver.resolve(parameters);
                ArrayList<Object> newScopeObjects = new ArrayList<Object>(matcher.getScope());
                newScopeObjects.set(newScopeObjects.size() - 1, resolved);
                return container.resolveValue(container, cQuery, new Scope(newScopeObjects, matcher.getPath()), false);
            }
            throw new CompareException();
        }

        @Override
        public boolean isFilterRoot() {
            return false;
        }
    }

    public static class RegexOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        private int getFlags(Condition container) throws CompareException {
            int flags = 0;
            Object options = container.get(Condition.$OPTIONS);
            if (options == null) {
                return flags;
            }
            if (options instanceof Condition && (options = ((Condition)options).get("flags")) == null) {
                return flags;
            }
            block5: for (int i = 0; i < ((String)options).length(); ++i) {
                switch (((String)options).charAt(i)) {
                    case 'i': {
                        flags |= 2;
                        continue block5;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block5;
                    }
                    case 's': {
                        flags |= 0x20;
                        continue block5;
                    }
                    default: {
                        throw new CompareException("Unsupported Regex Option");
                    }
                }
            }
            return flags;
        }

        protected boolean matchPattern(Object matcherValue, Pattern pattern) {
            if (matcherValue == null) {
                return false;
            }
            Matcher matcher = pattern.matcher("");
            List<Object> matcherValues = ReflectionUtils.wrapUnmodifiableList(matcherValue, Object.class);
            if (matcherValues != null) {
                for (Object matcherObject : matcherValues) {
                    if (matcherObject == null || !matcher.reset(Condition.toCharSequence(matcherObject)).matches()) continue;
                    return true;
                }
            }
            return matcher.reset(Condition.toCharSequence(matcherValue)).matches();
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            Object matcherValue = scope.getLast();
            if (matcherValue == KEY_DOES_NOT_EXIST) {
                return false;
            }
            try {
                expression = container.resolveValue(container, expression, scope, true);
                Pattern pattern = (Pattern)container.getCache(RegexOp.class);
                if (ReflectionUtils.isListOrArray(expression)) {
                    if (pattern == null) {
                        pattern = Pattern.compile(String.valueOf(container.resolveValue(container, ReflectionUtils.getListElement(expression, 0), scope, true)), this.getFlags(container));
                    }
                    container.putCache(RegexOp.class, pattern);
                    return this.matchPattern(container.resolveValue(container, ReflectionUtils.getListElement(expression, 1), scope, true), pattern);
                }
                if (expression instanceof Pattern) {
                    pattern = (Pattern)expression;
                    container.putCache(RegexOp.class, pattern);
                    return this.matchPattern(matcherValue, pattern);
                }
                if (expression instanceof String) {
                    if (pattern == null) {
                        expression = container.resolveValue(container, expression, scope, true);
                        pattern = Pattern.compile((String)expression, this.getFlags(container));
                    }
                    container.putCache(RegexOp.class, pattern);
                    return this.matchPattern(matcherValue, pattern);
                }
            }
            catch (PatternSyntaxException e) {
                throw new CompareException(e);
            }
            catch (IllegalArgumentException e) {
                throw new CompareException(e);
            }
            throw new CompareException("Operator expects a String or a Pattern(is not serializable) type as parameter");
        }
    }

    public static class RegexFindOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            try {
                if (ReflectionUtils.isListOrArray(expression)) {
                    Matcher matcher;
                    Object matcherObject = container.resolveValue(container, ReflectionUtils.getListElement(expression, 0), scope, true);
                    if (matcherObject == KEY_DOES_NOT_EXIST) {
                        return null;
                    }
                    Pattern pattern = (Pattern)container.getCache(RegexFindOp.class);
                    if (pattern == null) {
                        Object patternString = container.resolveValue(container, ReflectionUtils.getListElement(expression, 1), scope, true);
                        pattern = Pattern.compile(String.valueOf(patternString));
                        container.putCache(RegexFindOp.class, pattern);
                    }
                    int groupIndex = 1;
                    if (ReflectionUtils.getListLength(expression) > 2) {
                        Object obj = container.resolveValue(container, ReflectionUtils.getListElement(expression, 2), scope, true);
                        groupIndex = Integer.parseInt(String.valueOf(obj));
                    }
                    if ((matcher = pattern.matcher(Condition.toCharSequence(matcherObject))).find()) {
                        return matcher.group(groupIndex);
                    }
                    return null;
                }
            }
            catch (CompareException e) {
                throw new AggregationException(e);
            }
            throw new AggregationException();
        }
    }

    public static interface PathHandler {
        public Scope resolve(Scope var1, Scope var2, Object var3);
    }

    public static class OrOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return true;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            List<Object> listExpression = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
            for (Object exp : listExpression) {
                Object resolved = container.resolveValue(container, exp, scope, false);
                if (!((Condition)container).isTrue(resolved)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface OpHandler
    extends Operator {
    }

    public static class NotOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            return !container.equalsDeep(container, expression, scope.getLast(), scope);
        }
    }

    public static class NotEqualsOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            if (scope.getLast() == KEY_DOES_NOT_EXIST) {
                return true;
            }
            Object result = EQOP.opEvalInternal(container, expression, scope, true);
            return result != Boolean.TRUE;
        }
    }

    public static class NinOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return true;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            Object matcherValue = scope.getLast();
            if (matcherValue == KEY_DOES_NOT_EXIST) {
                return true;
            }
            if (!ReflectionUtils.isListOrArray(expression)) {
                throw new CompareException("Operator expects an array as parameter");
            }
            if (!ReflectionUtils.isListOrArray(matcherValue)) {
                List<Object> listExpressions = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
                for (Object exp : listExpressions) {
                    if (!container.equalsDeep(container, exp, matcherValue, scope)) continue;
                    return false;
                }
                return true;
            }
            List<Object> listExpression = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
            List<Object> listMatcherValues = ReflectionUtils.wrapUnmodifiableList(matcherValue, Object.class);
            for (Object exp : listExpression) {
                for (Object matcher : listMatcherValues) {
                    if (!container.equalsDeep(container, exp, matcher, scope)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class MultiplyOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expressions, Scope scope) throws CompareException {
            if (ReflectionUtils.isListOrArray(expressions.getClass())) {
                List<Object> listExpressions = ReflectionUtils.wrapUnmodifiableList(expressions, Object.class);
                Number result = null;
                for (Object expression : listExpressions) {
                    Number num = (Number)container.resolveValue(container, expression, scope, true);
                    if (result == null) {
                        result = num;
                        continue;
                    }
                    if (Clazz.isDouble(result.getClass()) || Clazz.isDouble(num.getClass())) {
                        result = result.doubleValue() * num.doubleValue();
                        continue;
                    }
                    if (Clazz.isFloat(result.getClass()) || Clazz.isFloat(num.getClass())) {
                        result = Float.valueOf(result.floatValue() * num.floatValue());
                        continue;
                    }
                    result = result.longValue() * num.longValue();
                }
                return new AggregationResult(result);
            }
            throw new AggregationException("MultiplyOp:" + container + "|" + expressions);
        }
    }

    public static class MinOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            if (expression instanceof Number) {
                return expression;
            }
            Number result = null;
            if (ReflectionUtils.isListOrArray(expression.getClass())) {
                int length = ReflectionUtils.getListLength(expression);
                for (int index = 0; index < length; ++index) {
                    Number num;
                    block7: {
                        Object value = ReflectionUtils.getListElement(expression, index);
                        num = null;
                        try {
                            if (ReflectionUtils.isListOrArray(value.getClass()) && length == 1) {
                                num = (Number)this.opEval(container, value, scope);
                                break block7;
                            }
                            if ((value = container.resolveValue(container, value, scope, true)) instanceof Number) {
                                num = (Number)value;
                            }
                            if (!ReflectionUtils.isListOrArray(value.getClass())) break block7;
                            num = (Number)this.opEval(container, value, scope);
                        }
                        catch (AggregationException e) {
                            continue;
                        }
                    }
                    result = result == null ? (Number)num : (Number)(Clazz.isDouble(result.getClass()) || Clazz.isDouble(num.getClass()) ? (Number)Math.min(result.doubleValue(), num.doubleValue()) : (Number)(Clazz.isFloat(result.getClass()) || Clazz.isFloat(num.getClass()) ? (Number)Float.valueOf(Math.min(result.floatValue(), num.floatValue())) : (Number)Math.min(result.longValue(), num.longValue())));
                }
            }
            return new AggregationResult(result);
        }
    }

    public static class MaxOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            if (expression instanceof Number) {
                return expression;
            }
            Number result = null;
            if (ReflectionUtils.isListOrArray(expression.getClass())) {
                int length = ReflectionUtils.getListLength(expression);
                for (int index = 0; index < length; ++index) {
                    Number num;
                    block7: {
                        Object value = ReflectionUtils.getListElement(expression, index);
                        num = null;
                        try {
                            if (ReflectionUtils.isListOrArray(value.getClass()) && length == 1) {
                                num = (Number)this.opEval(container, value, scope);
                                break block7;
                            }
                            if ((value = container.resolveValue(container, value, scope, true)) instanceof Number) {
                                num = (Number)value;
                            }
                            if (!ReflectionUtils.isListOrArray(value.getClass())) break block7;
                            num = (Number)this.opEval(container, value, scope);
                        }
                        catch (AggregationException e) {
                            continue;
                        }
                    }
                    result = result == null ? (Number)num : (Number)(Clazz.isDouble(result.getClass()) || Clazz.isDouble(num.getClass()) ? (Number)Math.max(result.doubleValue(), num.doubleValue()) : (Number)(Clazz.isFloat(result.getClass()) || Clazz.isFloat(num.getClass()) ? (Number)Float.valueOf(Math.max(result.floatValue(), num.floatValue())) : (Number)Math.max(result.longValue(), num.longValue())));
                }
            }
            return new AggregationResult(result);
        }
    }

    public static class KeyOnClass {
        private final Class<? extends Object> class1;
        private final int hashCode;
        private final String key;

        public KeyOnClass(Class<? extends Object> class1, String key) {
            this.class1 = class1;
            this.key = key;
            this.hashCode = class1.hashCode() + key.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof KeyOnClass)) {
                return false;
            }
            if (!this.class1.equals(((KeyOnClass)obj).class1)) {
                return false;
            }
            return this.key.equals(((KeyOnClass)obj).key);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class InOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            Object matcherValue = scope.getLast();
            expression = container.resolveValue(container, expression, scope, true);
            if (matcherValue == KEY_DOES_NOT_EXIST) {
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": KEY_DOES_NOT_EXIST -> false");
                }
                return false;
            }
            if (!ReflectionUtils.isListOrArray(expression)) {
                throw new CompareException("Operator expects an array as parameter");
            }
            if (!ReflectionUtils.isListOrArray(matcherValue)) {
                List<Object> listExpression = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
                for (Object exp : listExpression) {
                    if (!container.equalsDeep(container, exp, matcherValue, scope)) continue;
                    if (container._isDebug()) {
                        ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": 'does matcher match any expression-list-element-mode':  " + matcherValue + ".matches(" + exp + ") = true");
                    }
                    return true;
                }
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": 'does matcher match any expression-list-element-mode':  " + matcherValue + " does not match any of " + expression);
                }
                return false;
            }
            List<Object> listExpression = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
            List<Object> listMatcherValues = ReflectionUtils.wrapUnmodifiableList(matcherValue, Object.class);
            for (Object exp : listExpression) {
                for (Object matcher : listMatcherValues) {
                    if (!container.equalsDeep(container, exp, matcher, scope)) continue;
                    if (container._isDebug()) {
                        ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": 'does any matcher-list-element match any expression-list-element-mode':  " + matcher + ".matches(" + exp + ") = true");
                    }
                    return true;
                }
            }
            if (container._isDebug()) {
                ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": 'oes any matcher-list-element match any expression-list-element-mode':  " + matcherValue + " has no element that matches any element of " + expression);
            }
            return false;
        }
    }

    public static class NumberOp
    implements Operator {
        private final OP op;

        @Override
        public boolean isFilterRoot() {
            return false;
        }

        public NumberOp(OP op) {
            this.op = op;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            Object before = expression;
            Object matcherValue = scope.getLast();
            Condition root = (Condition)ROOT_CONDITION.get();
            if (ReflectionUtils.isListOrArray(expression)) {
                List<Number> aggregation = ReflectionUtils.wrapList(expression, false, Number.class);
                Number a = (Number)container.resolveValue(container, aggregation.get(0), scope, true);
                Number b = (Number)container.resolveValue(container, aggregation.get(1), scope, true);
                boolean ret = this.op.opEval(CompareUtils.compareNumber(a, b));
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + " \"" + aggregation.get(0) + "\"." + this.op.name() + "(" + aggregation.get(1) + ") = " + ret);
                }
                return new AggregationResult(ret);
            }
            expression = container.resolveValue(container, expression, scope, true);
            if (matcherValue == KEY_DOES_NOT_EXIST) {
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + " \"" + KEY_DOES_NOT_EXIST + "\"." + this.op.name() + "(" + expression + ") = " + false);
                }
                return false;
            }
            if (expression instanceof Condition) {
                Number a = (Number)matcherValue;
                Number b = (Number)container.resolveValue(container, expression, scope, true);
                boolean ret = this.op.opEval(CompareUtils.compareNumber(a, b));
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": " + a + "." + this.op.name() + "(" + b + ") = " + ret);
                }
                return ret;
            }
            expression = container.convertSpecialTypes(expression, matcherValue);
            if (matcherValue instanceof Number && expression instanceof Number) {
                Number a = (Number)matcherValue;
                Number b = (Number)expression;
                boolean ret = this.op.opEval(CompareUtils.compareNumber(a, b));
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": " + a + "." + this.op.name() + "(" + b + ") = " + ret);
                }
                return ret;
            }
            if (matcherValue instanceof Comparable && expression instanceof Comparable) {
                boolean ret = this.op.opEval(CompareUtils.compare((Comparable)matcherValue, (Comparable)expression));
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + " \"" + matcherValue + "\"." + this.op.name() + "(" + expression + ") = " + ret);
                }
                return ret;
            }
            throw new CompareException("Unsupported expression: " + expression + " on " + matcherValue);
        }

        public static enum OP {
            LTE{

                @Override
                protected boolean opEval(int compareResult) {
                    return compareResult <= 0;
                }
            }
            ,
            LT{

                @Override
                protected boolean opEval(int compareResult) {
                    return compareResult < 0;
                }
            }
            ,
            GTE{

                @Override
                protected boolean opEval(int compareResult) {
                    return compareResult >= 0;
                }
            }
            ,
            GT{

                @Override
                protected boolean opEval(int compareResult) {
                    return compareResult > 0;
                }
            };


            protected abstract boolean opEval(int var1);
        }
    }

    public static class ExistsOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            if (ReflectionUtils.isListOrArray(expression)) {
                Object matcherValue = container.resolveValue(container, ReflectionUtils.getListElement(expression, 0), scope, true);
                expression = container.resolveValue(container, ReflectionUtils.getListElement(expression, 1), scope, true);
                boolean exists = ((Condition)container).isTrue(expression);
                if (exists |= expression instanceof Number && ((Number)expression).intValue() != 0) {
                    return matcherValue != KEY_DOES_NOT_EXIST;
                }
                return matcherValue == KEY_DOES_NOT_EXIST;
            }
            expression = container.resolveValue(container, expression, scope, true);
            boolean exists = Boolean.TRUE.equals(expression);
            if (exists |= expression instanceof Number && ((Number)expression).intValue() != 0) {
                return scope.getLast() != KEY_DOES_NOT_EXIST ? Boolean.TRUE : Boolean.FALSE;
            }
            return scope.getLast() == KEY_DOES_NOT_EXIST ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public static class EqOp
    implements Operator {
        public static final String CASE_INSENSITIVE = "caseInsensitive";
        public static final String DISABLE_LIST_SPECIAL_HANDLING = "disableListSpecialHandling";

        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            boolean isNEQ = false;
            return this.opEvalInternal(container, expression, scope, isNEQ);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object opEvalInternal(Condition container, Object expression, Scope scope, boolean isNEQ) throws CompareException {
            List<Object> aggregation;
            boolean queryMode = true;
            Object matcherValue = scope.getLast();
            Object options = container.get(Condition.$OPTIONS);
            if (options != null && options instanceof Condition && Boolean.TRUE.equals(((Condition)options).get(Condition.OPTIONS_AGGREGATE))) {
                queryMode = false;
            }
            if (queryMode) {
                if (container.equalsDeep(container, expression = container.convertSpecialTypes(expression, matcherValue), matcherValue, scope)) {
                    if (container._isDebug()) {
                        container.log(scope.getPath(), this.getClass().getSimpleName() + " " + expression + ".equals(" + scope.getLast() + ") = true |Options: " + options);
                    }
                    return true;
                }
                boolean disableMongoDBListSpecial = false;
                if (options != null && options instanceof Condition && Boolean.TRUE.equals(((Condition)options).get(DISABLE_LIST_SPECIAL_HANDLING))) {
                    disableMongoDBListSpecial = true;
                }
                if (ReflectionUtils.isListOrArray(matcherValue) && !disableMongoDBListSpecial && !isNEQ) {
                    List<Object> list = ReflectionUtils.wrapList(matcherValue, false, Object.class);
                    int i = 0;
                    for (Object obj : list) {
                        scope.add(obj, i++);
                        try {
                            if (!container.equalsDeep(container, expression, obj, scope)) continue;
                            if (container._isDebug()) {
                                container.log(scope.getPath(), this.getClass().getSimpleName() + " (Matcher List contains expression Mode)\"" + scope.getLast() + "\".equals(" + expression + ") = true |Options: " + options);
                            }
                            Boolean bl = true;
                            return bl;
                        }
                        finally {
                            scope.removeLast();
                        }
                    }
                    if (container._isDebug()) {
                        container.log(scope.getPath(), this.getClass().getSimpleName() + " (Matcher List contains expression Mode)\"" + scope.getLast() + "\".contains(" + expression + ") = false |Options: " + options);
                    }
                    return false;
                }
                if (container._isDebug()) {
                    container.log(scope.getPath(), this.getClass().getSimpleName() + " " + expression + ".equals(" + scope.getLast() + ") = false |Options: " + options);
                }
                return false;
            }
            if (ReflectionUtils.isListOrArray(expression.getClass()) && (aggregation = ReflectionUtils.wrapList(expression, false, Object.class)).size() == 2) {
                Object x = container.resolveValue(container, aggregation.get(0), scope, true);
                Object y = container.resolveValue(container, aggregation.get(1), scope, true);
                return new AggregationResult(CompareUtils.equals(y, x));
            }
            return new AggregationResult(false);
        }
    }

    public static class EachOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return true;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            Object last = scope.getLast();
            if (last == KEY_DOES_NOT_EXIST) {
                return false;
            }
            if (last == null || Clazz.isPrimitive(last.getClass()) || last instanceof String) {
                return container.resolveValue(container, expression, scope, false);
            }
            try {
                Condition filter = null;
                Object options = container.get(Condition.$OPTIONS);
                if (options != null && options instanceof Condition) {
                    filter = (Condition)((Condition)options).get("filter");
                }
                for (String g : container.listKeys(last)) {
                    Object resolved;
                    Scope newScope = container.resolveKeyPath(scope, JSPath.fromPathString(g));
                    if (filter != null && !filter.matchesWithoutExceptions(newScope.getLast()) || ((Condition)container).isTrue(resolved = container.resolveValue(container, expression, newScope, false))) continue;
                    return false;
                }
            }
            catch (SecurityException e) {
                throw new CompareException(e);
            }
            catch (InvalidPathException e) {
                throw new CompareException(e);
            }
            return true;
        }
    }

    public static class ProjectOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return true;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            Object last = scope.getLast();
            if (last == KEY_DOES_NOT_EXIST) {
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + " -> KEY_DOES_NOT_EXIST ");
                }
                return last;
            }
            if (last == null || last instanceof String || Clazz.isPrimitive(last.getClass()) || Clazz.isEnum(last.getClass())) {
                if (((Condition)container).isTrue(container.resolveValue(container, expression, scope, false))) {
                    return last;
                }
                return null;
            }
            if (last instanceof Map) {
                HashMap result = new HashMap();
                Scope newScope = scope.copy();
                for (Map.Entry entry : ((Map)last).entrySet()) {
                    Object key = entry.getKey();
                    Object o = entry.getValue();
                    newScope.add(o, key);
                    if (((Condition)container).isTrue(container.resolveValue(container, expression, newScope, false))) {
                        result.put(key, o);
                    }
                    newScope.removeLast();
                }
                if (container._isDebug()) {
                    ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + " -> Map with " + result.size() + " entries: " + result.keySet());
                }
                return result;
            }
            if (Clazz.isArray(last.getClass()) || last instanceof List || last instanceof Collection) {
                Collection<Object> collection = ReflectionUtils.wrapCollection(last, false, Object.class);
                LinkedList<Object> result = new LinkedList<Object>();
                int i = 0;
                Scope newScope = scope.copy();
                for (Object o : collection) {
                    newScope.add(o, i++);
                    if (((Condition)container).isTrue(container.resolveValue(container, expression, newScope, false))) {
                        result.add(o);
                    }
                    newScope.removeLast();
                }
                return result;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            try {
                Scope newScope = scope.copy();
                for (Getter key : ClassCache.getClassCache(last.getClass()).getGetter()) {
                    Object o = key.getValue(last);
                    newScope.add(o, key);
                    if (((Condition)container).isTrue(container.resolveValue(container, expression, newScope, false))) {
                        result.put(key.getKey(), o);
                    }
                    newScope.removeLast();
                }
            }
            catch (SecurityException e) {
                throw new CompareException(e);
            }
            catch (NoSuchMethodException e) {
                throw new CompareException(e);
            }
            catch (IllegalArgumentException e) {
                throw new CompareException(e);
            }
            catch (IllegalAccessException e) {
                throw new CompareException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (CompareException e) {
                throw new CompareException(e);
            }
            return result;
        }
    }

    public static class DivideOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expressions, Scope scope) throws CompareException {
            List<Object> division;
            if (expressions != null && ReflectionUtils.isListOrArray(expressions.getClass()) && (division = ReflectionUtils.wrapUnmodifiableList(expressions, Object.class)).size() == 2) {
                Number dividend = (Number)container.resolveValue(container, division.get(0), scope, true);
                Number divisor = (Number)container.resolveValue(container, division.get(1), scope, true);
                Number result = Clazz.isDouble(dividend.getClass()) || Clazz.isDouble(divisor.getClass()) ? (Number)(dividend.doubleValue() / divisor.doubleValue()) : (Number)(Clazz.isFloat(dividend.getClass()) || Clazz.isFloat(divisor.getClass()) ? (Number)Float.valueOf(dividend.floatValue() / divisor.floatValue()) : (Number)(dividend.longValue() / divisor.longValue()));
                return new AggregationResult(result);
            }
            throw new AggregationException("DivideOp:" + container + "|" + expressions);
        }
    }

    public static interface ConditionResolver<Input, Output> {
        public Output resolve(Input var1) throws CompareException;
    }

    public static class ConcatOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return false;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            try {
                if (ReflectionUtils.isListOrArray(expression)) {
                    StringBuilder sb = new StringBuilder();
                    List<Object> listExpression = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
                    for (Object exp : listExpression) {
                        sb.append(container.resolveValue(container, exp, scope, true));
                    }
                    return sb.toString();
                }
            }
            catch (CompareException e) {
                throw new AggregationException(e);
            }
            throw new AggregationException();
        }
    }

    public static class AnyOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return true;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            Object last = scope.getLast();
            if (last == KEY_DOES_NOT_EXIST) {
                return false;
            }
            if (last == null || Clazz.isPrimitive(last.getClass()) || last instanceof String) {
                return container.resolveValue(container, expression, scope, false);
            }
            try {
                for (String g : container.listKeys(last)) {
                    Scope newScope = container.resolveKeyPath(scope, JSPath.fromPathElements(g));
                    if (!container.equalsDeep(container, expression, expression, newScope)) continue;
                    if (container._isDebug()) {
                        ((Condition)container).log(newScope.getPath(), this.getClass().getSimpleName() + ": " + container.resolveValue(container, expression, newScope, false) + ".matches(" + expression + ")");
                    }
                    return true;
                }
            }
            catch (SecurityException e) {
                throw new CompareException(e);
            }
            if (container._isDebug()) {
                ((Condition)container).log(scope.getPath(), this.getClass().getSimpleName() + ": no element matches(" + expression + ")");
            }
            return false;
        }
    }

    public static class AndOp
    implements Operator {
        @Override
        public boolean isFilterRoot() {
            return true;
        }

        @Override
        public Object opEval(Condition<?> container, Object expression, Scope scope) throws CompareException {
            if (scope.getLast() == KEY_DOES_NOT_EXIST) {
                return false;
            }
            List<Object> listExpression = ReflectionUtils.wrapUnmodifiableList(expression, Object.class);
            for (Object exp : listExpression) {
                Object resolved = container.resolveValue(container, exp, scope, false);
                if (!container.isFalse(resolved)) continue;
                return false;
            }
            return true;
        }
    }

    public static class AddOp
    implements Operator {
        @Override
        public Object opEval(Condition<?> container, Object expressions, Scope scope) throws CompareException {
            if (ReflectionUtils.isListOrArray(expressions.getClass())) {
                List<Object> listExpressions = ReflectionUtils.wrapUnmodifiableList(expressions, Object.class);
                Number result = null;
                for (Object expression : listExpressions) {
                    Number num = (Number)container.resolveValue(container, expression, scope, true);
                    if (result == null) {
                        result = num;
                        continue;
                    }
                    if (Clazz.isDouble(result.getClass()) || Clazz.isDouble(num.getClass())) {
                        result = result.doubleValue() + num.doubleValue();
                        continue;
                    }
                    if (Clazz.isFloat(result.getClass()) || Clazz.isFloat(num.getClass())) {
                        result = Float.valueOf(result.floatValue() + num.floatValue());
                        continue;
                    }
                    result = result.longValue() + num.longValue();
                }
                return result;
            }
            throw new AggregationException("AddOp:" + container + "|" + expressions);
        }

        @Override
        public boolean isFilterRoot() {
            return false;
        }
    }

    public static class AccessNotFound
    implements AccessMethod {
        @Override
        public Object getValue(Object value, String key) throws CannotGetValueException {
            return KEY_DOES_NOT_EXIST;
        }
    }

    public static interface AccessMethod {
        public Object getValue(Object var1, String var2) throws CannotGetValueException;
    }

    public static class AccessMapElement
    implements AccessMethod {
        @Override
        public Object getValue(Object value, String key) throws CannotGetValueException {
            try {
                Map map = (Map)value;
                Object ret = map.get(key);
                if (ret == null) {
                    if (map.containsKey(key)) {
                        return null;
                    }
                    return KEY_DOES_NOT_EXIST;
                }
                return ret;
            }
            catch (Throwable e) {
                throw new CannotGetValueException(e);
            }
        }
    }

    public static class AccessArrayElement
    implements AccessMethod {
        @Override
        public Object getValue(Object value, String key) throws CannotGetValueException {
            try {
                int index = Integer.parseInt(key);
                return Array.get(value, index);
            }
            catch (Throwable e) {
                throw new CannotGetValueException(e);
            }
        }
    }

    public static class AccessCollectionElement
    implements AccessMethod {
        @Override
        public Object getValue(Object value, String key) throws CannotGetValueException {
            try {
                int index = Integer.parseInt(key);
                for (Object r : (Collection)value) {
                    if (index == 0) {
                        return r;
                    }
                    --index;
                }
            }
            catch (Throwable e) {
                throw new CannotGetValueException(e);
            }
            throw new CannotGetValueException("Index out of bounds");
        }
    }

    public static class AccessListElement
    implements AccessMethod {
        @Override
        public Object getValue(Object value, String key) throws CannotGetValueException {
            try {
                int index = Integer.parseInt(key);
                return ((List)value).get(index);
            }
            catch (Throwable e) {
                throw new CannotGetValueException(e);
            }
        }
    }

    public static class AccessByMethod
    implements AccessMethod {
        private final boolean isStatic;
        private final Method method;
        private static final Object[] EMPTY_ARGS = new Object[0];

        public AccessByMethod(Method method) {
            this.method = method;
            this.isStatic = Modifier.isStatic(method.getModifiers());
        }

        @Override
        public Object getValue(Object value, String key) throws CannotGetValueException {
            try {
                if (this.isStatic) {
                    return this.method.invoke(null, EMPTY_ARGS);
                }
                return this.method.invoke(value, EMPTY_ARGS);
            }
            catch (IllegalAccessException e) {
                throw new CannotGetValueException(e);
            }
            catch (IllegalArgumentException e) {
                throw new CannotGetValueException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new CannotGetValueException(e);
            }
            catch (RuntimeException e) {
                throw new CannotGetValueException(e);
            }
        }
    }

    public static class AccessByField
    implements AccessMethod {
        private final Field field;
        private final boolean isStatic;

        public AccessByField(Field field) {
            this.field = field;
            this.isStatic = Modifier.isStatic(field.getModifiers());
        }

        @Override
        public Object getValue(Object value, String key) throws CannotGetValueException {
            try {
                if (this.isStatic) {
                    return this.field.get(null);
                }
                return this.field.get(value);
            }
            catch (IllegalAccessException e) {
                throw new CannotGetValueException(e);
            }
        }
    }
}

