/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.propertystate;

import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.appwork.propertystate.Manager;
import org.appwork.propertystate.PropertyState;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ReflectionUtils;

public class PropertyAccess<OwnerType, T> {
    private final String key;
    private final Type type;
    private final AtomicReferenceFieldUpdater<OwnerType, PropertyState> updater;
    private final T defaultValue;
    private final Class<?> rawClass;

    public PropertyAccess(AtomicReferenceFieldUpdater<OwnerType, PropertyState> updater, String key, Type type, T defaultValue) {
        this.key = key;
        this.updater = updater;
        this.defaultValue = defaultValue;
        this.type = type;
        this.rawClass = ReflectionUtils.getRaw(type);
    }

    public Class<?> getRawClass() {
        return this.rawClass;
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public T get(OwnerType owner) {
        return this.updater.get(owner).get(this.key, this.type, this.defaultValue);
    }

    public boolean set(OwnerType owner, T value) {
        block1: {
            PropertyState newState;
            PropertyState old;
            do {
                old = this.updater.get(owner);
                Manager manager = old.getManager();
                newState = CompareUtils.equals(value, this.defaultValue) ? manager.remove(old, this.key) : manager.put(old, this.key, value);
                if (newState == old) break block1;
            } while (!this.updater.compareAndSet(owner, old, newState));
            return true;
        }
        return false;
    }
}

