/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.resources;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.appwork.resources.MultiResolutionImageHelper;
import org.appwork.utils.images.AbstractIconPipe;
import org.appwork.utils.images.AlignHorizontal;
import org.appwork.utils.images.AlignVertical;
import org.appwork.utils.images.CroppedIcon;
import org.appwork.utils.images.ModificationType;

public class HighDPIIcon
extends AbstractIconPipe {
    private static final Set<ModificationType> MODIFICATIONS = Collections.unmodifiableSet(new HashSet<ModificationType>(Arrays.asList(ModificationType.NONE)));

    public HighDPIIcon(Icon icon) {
        super(icon);
    }

    @Override
    public Set<ModificationType> getModifications() {
        return MODIFICATIONS;
    }

    public HighDPIIcon(Image image) {
        this(new ImageIcon(image));
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, List<Icon> parents) {
        if (!(this.delegate instanceof ImageIcon)) {
            this.paintDelegate(c, g, x, y, parents);
            return;
        }
        Image image = ((ImageIcon)this.delegate).getImage();
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform transform = g2.getTransform();
        double scaleX = transform.getScaleX();
        double scaleY = transform.getScaleY();
        if ((scaleX != 1.0 || scaleY != 1.0) && this.isHDPIFixRequired(scaleX, scaleY, transform.getTranslateX(), transform.getTranslateY())) {
            double scaledW = (double)this.getIconWidth() * scaleX;
            double scaledH = (double)this.getIconHeight() * scaleY;
            Image best = MultiResolutionImageHelper.isInstanceOf(image) ? MultiResolutionImageHelper.getResolutionVariant(image, scaledW, scaledH) : image;
            boolean perfectFit = (double)best.getWidth(null) == scaledW && (double)best.getHeight(null) == scaledH;
            AffineTransform currentTransform = g2.getTransform();
            double fixtX = currentTransform.getTranslateX() % 1.0;
            double fixtY = currentTransform.getTranslateY() % 1.0;
            g2.translate(-fixtX, -fixtY);
            if (perfectFit) {
                g2.scale(1.0 / scaleX, 1.0 / scaleY);
                g2.drawImage(best, (int)Math.round((double)x * scaleX), (int)Math.round((double)y * scaleY), c);
                g2.translate(fixtX, fixtY);
                g2.scale(scaleX, scaleY);
            } else {
                if (Math.abs(scaledW - (double)best.getWidth(null)) > 1.0 || Math.abs(scaledH - (double)best.getHeight(null)) > 1.0) {
                    this.paintDelegate(c, g, x, y, parents);
                    g2.translate(fixtX, fixtY);
                    return;
                }
                g2.scale(1.0 / scaleX, 1.0 / scaleY);
                new CroppedIcon(new ImageIcon(best), (int)Math.round(scaledW), (int)Math.round(scaledH), AlignHorizontal.CENTER, AlignVertical.CENTER).paintIcon(c, g2, (int)((double)x * scaleX), (int)((double)y * scaleY));
                g2.translate(fixtX, fixtY);
                g2.scale(scaleX, scaleY);
            }
            return;
        }
        this.paintDelegate(c, g, x, y, parents);
    }

    public boolean isHDPIFixRequired(double scaleX, double scaleY, double translateX, double translateY) {
        boolean iconIsDividableBy4;
        boolean iconIsDividableBy2;
        if (translateX % 1.0 != 0.0) {
            return true;
        }
        if (translateY % 1.0 != 0.0) {
            return true;
        }
        boolean scaleIsDividableBy50 = scaleX % 0.5 == 0.0 && scaleY % 0.5 == 0.0;
        boolean bl = iconIsDividableBy2 = this.getIconHeight() % 2 == 0 && this.getIconHeight() % 2 == 0;
        if (scaleIsDividableBy50 && iconIsDividableBy2) {
            return false;
        }
        boolean scaleIsDividableBy25 = scaleX % 0.25 == 0.0 && scaleY % 0.25 == 0.0;
        boolean bl2 = iconIsDividableBy4 = this.getIconHeight() % 4 == 0 && this.getIconHeight() % 4 == 0;
        return !scaleIsDividableBy25 || !iconIsDividableBy4;
    }
}

