/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage;

import java.lang.reflect.Type;
import java.util.List;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.DeSerializerInput;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JsonDeSerializer;
import org.appwork.storage.JsonSerializer;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.TypeRef;
import org.appwork.storage.converter.ConverterInput;
import org.appwork.storage.converter.JsonConverterForDeserialization;
import org.appwork.storage.converter.JsonConverterForSerialization;
import org.appwork.storage.mapper.AbstractJsonMapper;
import org.appwork.storage.simplejson.JSonFactory;
import org.appwork.storage.simplejson.JSonNode;
import org.appwork.storage.simplejson.ParserException;
import org.appwork.storage.simplejson.mapper.JSonMapper;
import org.appwork.storage.simplejson.mapper.MapperException;
import org.appwork.utils.Exceptions;

public class SimpleMapper
extends AbstractJsonMapper {
    protected final JSonMapper mapper = this.buildMapper();
    private boolean prettyPrintEnabled = true;

    protected JSonMapper buildMapper() {
        return new JSonMapper(){

            protected Object jsonToObjectByPassDeserializers(JSonNode json, Type type) throws MapperException {
                return super.jsonToObject(json, type);
            }

            @Override
            public Object jsonToObject(final JSonNode json, Type type) throws MapperException {
                try {
                    Object ret;
                    Object input;
                    Class raw = SimpleMapper.this.getRawTypeForDeserialization(type);
                    SimpleTypeRef typeRef = null;
                    List matches = SimpleMapper.this.findBestTypeMatch(raw, SimpleMapper.this.convertForDeserialization, JsonConverterForDeserialization.class);
                    if (matches != null && matches.size() > 0) {
                        input = new ConverterInput(json){

                            @Override
                            protected Object lazyGenericRepresentationInit() {
                                try {
                                    return this.jsonToObjectByPassDeserializers(json, (Type)((Object)Object.class));
                                }
                                catch (MapperException e) {
                                    throw new WTFException();
                                }
                            }
                        };
                        if (typeRef == null) {
                            typeRef = new SimpleTypeRef(type);
                        }
                        if ((ret = SimpleMapper.this.handleDeserializationConverterMatches((ConverterInput)input, typeRef, matches)) != input) {
                            return ret;
                        }
                    }
                    if ((matches = SimpleMapper.this.findBestTypeMatch(raw, SimpleMapper.this.deSerializer, JsonDeSerializer.class)) != null && matches.size() > 0) {
                        input = new DeSerializerInput(json){

                            @Override
                            protected String lazyJSONRepresentationInit() {
                                return json.toString();
                            }
                        };
                        if (typeRef == null) {
                            typeRef = new SimpleTypeRef(type);
                        }
                        if ((ret = SimpleMapper.this.handleDeserializationMatches((DeSerializerInput)input, typeRef, matches)) != input) {
                            return ret;
                        }
                    }
                    return this.jsonToObjectByPassDeserializers(json, type);
                }
                catch (WTFException e) {
                    MapperException hiddenMapperException = Exceptions.getInstanceof(e, MapperException.class);
                    if (hiddenMapperException != null) {
                        throw hiddenMapperException;
                    }
                    throw e;
                }
            }

            @Override
            public JSonNode create(Object obj) throws MapperException {
                Object ret;
                List matches = SimpleMapper.this.findBestTypeMatch(obj == null ? null : obj.getClass(), SimpleMapper.this.convertForSerialization, JsonConverterForSerialization.class);
                if (matches != null && matches.size() > 0 && (ret = SimpleMapper.this.handleSerializationConverterMatches(obj, matches)) != JsonConverterForSerialization.SKIP && ret != obj) {
                    obj = ret;
                }
                if ((matches = SimpleMapper.this.findBestTypeMatch(obj == null ? null : obj.getClass(), SimpleMapper.this.serializer, JsonSerializer.class)) != null && matches.size() > 0 && (ret = SimpleMapper.this.handleSerializationMatches(obj, matches)) != JsonSerializer.SKIP) {
                    return new JSonNode((String)ret){
                        final /* synthetic */ String val$ret;
                        {
                            this.val$ret = string;
                        }

                        public String toString() {
                            return this.val$ret;
                        }

                        @Override
                        public String toPrettyString() {
                            return this.val$ret;
                        }
                    };
                }
                return super.create(obj);
            }
        };
    }

    public JSonMapper getMapper() {
        return this.mapper;
    }

    public boolean isPrettyPrintEnabled() {
        return this.prettyPrintEnabled;
    }

    protected JSonFactory newJsonFactory(String jsonString) {
        return new JSonFactory(jsonString);
    }

    public SimpleMapper setPrettyPrintEnabled(boolean prettyPrintEnabled) {
        this.prettyPrintEnabled = prettyPrintEnabled;
        return this;
    }

    @Override
    public String objectToString(Object value) throws JSonMapperException {
        try {
            if (this.isPrettyPrintEnabled()) {
                return this.mapper.create(value).toPrettyString();
            }
            return this.mapper.create(value).toString();
        }
        catch (MapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T stringToObject(String jsonString, Class<T> clazz) throws JSonMapperException {
        try {
            JSonNode jsonFactory = this.newJsonFactory(jsonString).parse();
            jsonString = null;
            return (T)this.mapper.jsonToObject(jsonFactory, clazz);
        }
        catch (ParserException e) {
            throw new JSonMapperException(e);
        }
        catch (MapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T stringToObject(String jsonString, TypeRef<T> type) throws JSonMapperException {
        try {
            JSonNode jsonFactory = this.newJsonFactory(jsonString).parse();
            jsonString = null;
            return this.mapper.jsonToObject(jsonFactory, type);
        }
        catch (ParserException e) {
            throw new JSonMapperException(e);
        }
        catch (MapperException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T convert(Object object, TypeRef<T> type) throws JSonMapperException {
        try {
            return this.mapper.jsonToObject(this.mapper.create(object), type);
        }
        catch (MapperException e) {
            throw new JSonMapperException(e);
        }
    }
}

