/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultDoubleValue;
import org.appwork.storage.config.annotations.DoubleSpinnerValidator;
import org.appwork.storage.config.annotations.LookUpKeys;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.StringUtils;

public class DoubleKeyHandler
extends KeyHandler<Double> {
    private DoubleSpinnerValidator validator;

    public DoubleKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultDoubleValue.class;
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[]{LookUpKeys.class, DoubleSpinnerValidator.class};
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(0.0);
    }

    @Override
    protected Double getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        if (rawValue instanceof Number) {
            return ((Number)rawValue).doubleValue();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (StringUtils.equalsIgnoreCase("null", stringValue)) {
                if (this.isRealPrimitive()) {
                    return 0.0;
                }
                return null;
            }
            return Double.valueOf(stringValue);
        }
        return (Double)rawValue;
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Double && y instanceof Double) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(DoubleSpinnerValidator.class);
        try {
            this.setDefaultValue(this.getAnnotation(DefaultDoubleValue.class).value());
        }
        catch (NullPointerException e) {
            this.setDefaultValue(0.0);
        }
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected void putValue(Double object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected void validateValue(Double object) throws Throwable {
        if (this.validator != null) {
            double v = object;
            double min = this.validator.min();
            double max = this.validator.max();
            if (v < min) {
                throw new ValidationException("value=" + v + " < min=" + min);
            }
            if (v > max) {
                throw new ValidationException("value=" + v + " > max=" + max);
            }
        }
    }
}

