/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.ListHandler;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class ConfigUtils {
    public static void printStaticMappings(Class<? extends ConfigInterface> configInterface) {
        ConfigUtils.printStaticMappings(configInterface, null);
    }

    public static void printStaticMappings(Class<? extends ConfigInterface> configInterface, String resource) {
        ConfigUtils.printStaticMappings(configInterface, resource, "JsonConfig.create");
    }

    public static void printStaticMappings(Class<? extends ConfigInterface> configInterface, String resource, String factory) {
        StringBuilder strBuild = new StringBuilder();
        System.err.println(configInterface);
        System.err.flush();
        strBuild.append("\r\n");
        strBuild.append("//Static Mappings for " + configInterface);
        strBuild.append("\r\n");
        if (resource == null) {
            strBuild.append("public static final " + configInterface.getSimpleName() + "                 CFG                               = " + factory + "(" + configInterface.getSimpleName() + ".class);");
        } else {
            strBuild.append("public static final " + configInterface.getSimpleName() + "                 CFG                               = " + factory + "(" + resource + ", " + configInterface.getSimpleName() + ".class);");
        }
        strBuild.append("\r\n");
        strBuild.append("public static final StorageHandler<" + configInterface.getSimpleName() + ">                 SH                               = (StorageHandler<" + configInterface.getSimpleName() + ">) CFG._getStorageHandler();");
        strBuild.append("\r\n");
        strBuild.append("//let's do this mapping here. If we map all methods to static handlers, access is faster, and we get an error on init if mappings are wrong.");
        for (KeyHandler<?> kh : JsonConfig.create(configInterface)._getStorageHandler().getKeyHandler()) {
            strBuild.append("\r\n");
            String methodname = kh.getGetMethod().getName().startsWith("is") ? kh.getGetMethod().getName().substring(2) : kh.getGetMethod().getName().substring(3);
            StringBuilder sb = new StringBuilder();
            char lastc = ' ';
            for (int i = 0; i < methodname.length(); ++i) {
                char c = methodname.charAt(i);
                if (sb.length() > 0 && Character.isUpperCase(c) && Character.isLowerCase(lastc)) {
                    sb.append('_');
                }
                sb.append(Character.toUpperCase(c));
                lastc = c;
            }
            if (kh.getAnnotation(DescriptionForConfigEntry.class) != null) {
                strBuild.append("\r\n");
                strBuild.append("/**");
                strBuild.append("\r\n");
                strBuild.append(" * " + kh.getAnnotation(DescriptionForConfigEntry.class).value());
                strBuild.append("\r\n");
                strBuild.append("**/");
            }
            strBuild.append("\r\n");
            if (kh.getClass().getName().contains("$")) {
                if (ListHandler.class.isAssignableFrom(kh.getClass())) {
                    ParameterizedType sc = (ParameterizedType)kh.getClass().getGenericSuperclass();
                    Class type = (Class)sc.getActualTypeArguments()[0];
                    String sn = type.getSimpleName();
                    Type raw = sc.getRawType();
                    if (raw instanceof Class) {
                        strBuild.append("public static final " + ((Class)raw).getSimpleName() + "<" + sn + "> " + sb + " = (" + ((Class)raw).getSimpleName() + "<" + sn + ">)SH.getKeyHandler(\"" + methodname + "\", " + ((Class)raw).getSimpleName() + ".class);");
                        continue;
                    }
                    throw new WTFException(raw + " - isNoClass");
                }
                throw new WTFException("Unsupported Keyhanlder");
            }
            strBuild.append("public static final " + kh.getClass().getSimpleName() + " " + sb + " = SH.getKeyHandler(\"" + methodname + "\", " + kh.getClass().getSimpleName() + ".class);");
        }
        System.err.println("=======================");
        System.err.flush();
        try {
            Dialog.getInstance().showInputDialog(64, configInterface.toString(), strBuild.toString());
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
    }
}

