/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.mod;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.moncompare.Condition;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.InvalidPathException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.mod.IllegalPathException;
import org.appwork.storage.flexijson.mapper.mod.JsonModification;
import org.appwork.storage.flexijson.mapper.mod.MergeException;
import org.appwork.storage.simplejson.ValueType;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.logging2.ConsoleLogImpl;
import org.appwork.utils.logging2.LogInterface;

public class FlexiModifier<T extends FlexiJSonNode, MatcherType> {
    private final T targetObject;
    private boolean breakOnError = true;
    private final FlexiJSonMapper mapper;
    private MatcherType conditionMapper;
    private boolean autoCreateStructures = true;
    private LogInterface logger = new ConsoleLogImpl();
    private int changes;

    public T getTargetObject() {
        return this.targetObject;
    }

    public FlexiJSonMapper getMapper() {
        return this.mapper;
    }

    public boolean isBreakOnError() {
        return this.breakOnError;
    }

    public void setBreakOnError(boolean breakOnError) {
        this.breakOnError = breakOnError;
    }

    public FlexiModifier(T base) {
        this.targetObject = base;
        this.mapper = this.createMapper();
    }

    protected FlexiJSonMapper createMapper() {
        return new FlexiJSonMapper();
    }

    public T merge(List<JsonModification<FlexiJSonObject, MatcherType>> mod) throws MergeException {
        for (JsonModification<FlexiJSonObject, MatcherType> m : mod) {
            this.merge(m);
        }
        return this.targetObject;
    }

    public int merge(JsonModification<FlexiJSonObject, MatcherType> mod) throws MergeException {
        Set<String> unset;
        FlexiJSonObject setIfUnset;
        Condition<MatcherType>[] conditions = mod.getConditions();
        if (conditions != null && conditions.length > 0 && !this.evalConditions(mod.getConditions())) {
            return -1;
        }
        int modsBefore = this.changes;
        FlexiJSonObject set = mod.getSet();
        if (set != null) {
            this.set(set, false);
        }
        if ((setIfUnset = mod.getSetIfUnset()) != null) {
            this.set(setIfUnset, true);
        }
        if ((unset = mod.getUnset()) != null) {
            this.unset(unset);
        }
        return this.changes - modsBefore;
    }

    private int unset(Set<String> unset) throws MergeException {
        for (String path : unset) {
            try {
                JSPath jsPath = this.fromPathString(path);
                this.unset(jsPath);
            }
            catch (Exception e1) {
                if (!this.isBreakOnError(e1)) continue;
                throw MergeException.wrap(e1);
            }
        }
        return this.changes;
    }

    public void unset(JSPath jsPath) throws IllegalPathException {
        block10: {
            FlexiJSonNode parent = this.targetObject.resolvePath(jsPath.getParent());
            if (parent == null) {
                return;
            }
            Object pathElement = jsPath.getLast();
            if (parent instanceof FlexiJSonArray) {
                try {
                    int index = JSPath.toArrayIndex(pathElement);
                    if (((FlexiJSonArray)parent).size() > index) {
                        ((FlexiJSonArray)parent).remove(index);
                        if (this.logger != null) {
                            this.logger.info("Removed from array " + jsPath.toPathString(true));
                        }
                        ++this.changes;
                        return;
                    }
                    break block10;
                }
                catch (NumberFormatException e1) {
                    throw new IllegalPathException("Element is an array, but the path does NOT contain an int key" + jsPath.toPathString(true));
                }
            }
            if (parent instanceof FlexiJSonObject) {
                if (JSPath.isArrayKey(pathElement)) {
                    throw new IllegalPathException("Element is an object, but the path contains an int key" + jsPath.toPathString(true));
                }
                if (((FlexiJSonObject)parent).remove(String.valueOf(pathElement)) != null) {
                    if (this.logger != null) {
                        this.logger.info("Removed from object " + jsPath.toPathString(true));
                    }
                    ++this.changes;
                    return;
                }
                return;
            }
            throw new IllegalPathException("Path exists, but contains an unsupported element: " + jsPath.getParent() + "; Type:" + parent.getClass());
        }
    }

    public int getChanges() {
        return this.changes;
    }

    public LogInterface getLogger() {
        return this.logger;
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    public boolean isAutoCreateStructures() {
        return this.autoCreateStructures;
    }

    public void setAutoCreateStructures(boolean autoCreateStructures) {
        this.autoCreateStructures = autoCreateStructures;
    }

    private void set(FlexiJSonObject set, boolean onlyIfUnset) throws MergeException {
        for (KeyValueElement e : set.getElements()) {
            FlexiJSonNode value = e.getValue();
            if (value == null || value instanceof FlexiJSonComments || value instanceof FlexiComment) continue;
            try {
                JSPath jsPath = this.fromPathString(e.getKey());
                this.set(jsPath, value, onlyIfUnset);
            }
            catch (Exception e1) {
                if (!this.isBreakOnError(e1)) continue;
                throw MergeException.wrap(e1);
            }
        }
    }

    protected JSPath fromPathString(String key) throws InvalidPathException {
        return JSPath.fromPathString(key);
    }

    protected void set(JSPath jsPath, FlexiJSonNode value, boolean onlyIfUnset) throws IllegalPathException, FlexiMapperException {
        FlexiJSonNode parent = this.resolveParent((FlexiJSonNode)this.targetObject, jsPath);
        Object pathElement = jsPath.getLast();
        if (parent instanceof FlexiJSonArray) {
            try {
                int index = JSPath.toArrayIndex(pathElement);
                if (((FlexiJSonArray)parent).size() < index) {
                    if (this.isAutoCreateStructures()) {
                        for (int ii = ((FlexiJSonArray)parent).size(); ii < index; ++ii) {
                            ((FlexiJSonArray)parent).add(this.mapper.createFlexiJSonValue());
                            if (this.logger != null) {
                                this.logger.info("Add undefined array " + jsPath.getParent().derive(ii).toPathString(true));
                            }
                            ++this.changes;
                        }
                    } else {
                        throw new IllegalPathException("Path does not exist: " + jsPath.toPathString(true));
                    }
                }
                if (((FlexiJSonArray)parent).size() <= index) {
                    ((FlexiJSonArray)parent).add(value);
                    if (this.logger != null) {
                        this.logger.info("Add to array " + jsPath.toPathString(true) + " = " + FlexiUtils.serializeMinimizedWithWTF(value));
                    }
                    ++this.changes;
                    return;
                }
                if (onlyIfUnset) {
                    return;
                }
                ((FlexiJSonArray)parent).set(index, value);
                if (this.logger != null) {
                    this.logger.info("Set in array " + jsPath.toPathString(true));
                }
                ++this.changes;
                return;
            }
            catch (NumberFormatException e1) {
                throw new IllegalPathException("Element is an array, but the path does NOT contain an int key" + jsPath.toPathString(true));
            }
        }
        if (parent instanceof FlexiJSonObject) {
            FlexiJSonNode old;
            if (JSPath.isArrayKey(pathElement)) {
                throw new IllegalPathException("Element is an object, but the path contains an int key" + jsPath.toPathString(true));
            }
            if (onlyIfUnset && ((FlexiJSonObject)parent).getElement(String.valueOf(pathElement)) != null) {
                return;
            }
            ((FlexiJSonObject)parent).put(String.valueOf(pathElement), value);
            if (this.logger != null && !CompareUtils.equalsDeep(value, old = ((FlexiJSonObject)parent).getNode(String.valueOf(pathElement)))) {
                this.logger.info("Put in object " + jsPath.toPathString(true) + " = " + FlexiUtils.serializeMinimizedWithWTF(value) + "/old: " + old);
            }
            ++this.changes;
            return;
        }
        throw new IllegalPathException("Path exists, but contains an unsupported element: " + jsPath.getParent() + "; Type:" + parent.getClass());
    }

    private FlexiJSonNode resolveParent(FlexiJSonNode parent, JSPath jsPath) throws IllegalPathException {
        JSPath currentPath = new JSPath();
        for (int i = 0; i < jsPath.size() - 1; ++i) {
            FlexiJSonNode oldParent;
            Object pathElement = jsPath.getElements().get(i);
            Object nextPathElement = jsPath.getElements().get(i + 1);
            currentPath.add(pathElement);
            if (parent instanceof FlexiJSonArray) {
                oldParent = (FlexiJSonArray)parent;
                try {
                    int index = JSPath.toArrayIndex(pathElement);
                    parent = ((FlexiJSonArray)parent).size() <= index ? null : (FlexiJSonNode)((FlexiJSonArray)parent).get(index);
                    if (parent instanceof FlexiJSonValue) {
                        if (((FlexiJSonValue)parent).getType() == ValueType.NULL || ((FlexiJSonValue)parent).getType() == ValueType.UNDEFINED) {
                            parent = null;
                        } else {
                            throw new IllegalPathException("Path exists, but directs to a value. Expected: " + (nextPathElement instanceof Number ? "Array" : "Object"));
                        }
                    }
                    if (parent != null) continue;
                    if (this.isAutoCreateStructures()) {
                        parent = JSPath.isArrayKey(nextPathElement) ? this.mapper.createFlexiJSonArray(10) : this.mapper.createFlexiJSonObject();
                        for (int ii = ((ArrayList)((Object)oldParent)).size(); ii < index; ++ii) {
                            ((FlexiJSonArray)oldParent).add(this.mapper.createFlexiJSonValue());
                        }
                        ((FlexiJSonArray)oldParent).add(parent);
                        continue;
                    }
                    throw new IllegalPathException("Path does not exist: " + currentPath.toPathString(true));
                }
                catch (NumberFormatException e1) {
                    throw new IllegalPathException("Element is an array, but the path does NOT contain an int key" + currentPath.toPathString(true));
                }
            }
            if (parent instanceof FlexiJSonObject) {
                oldParent = (FlexiJSonObject)parent;
                if (JSPath.isArrayKey(pathElement)) {
                    throw new IllegalPathException("Element is an object, but the path contains an int key" + currentPath.toPathString(true));
                }
                KeyValueElement element = ((FlexiJSonObject)parent).getElement(String.valueOf(pathElement));
                if ((parent = element == null ? null : element.getValue()) instanceof FlexiJSonValue) {
                    if (((FlexiJSonValue)parent).getType() == ValueType.NULL || ((FlexiJSonValue)parent).getType() == ValueType.UNDEFINED) {
                        parent = null;
                    } else {
                        throw new IllegalPathException("Path exists, but directs to a value. Expected: " + (nextPathElement instanceof Number ? "Array" : "Object"));
                    }
                }
                if (parent != null) continue;
                if (this.isAutoCreateStructures()) {
                    parent = JSPath.isArrayKey(nextPathElement) ? this.mapper.createFlexiJSonArray(10) : this.mapper.createFlexiJSonObject();
                    try {
                        ((FlexiJSonObject)oldParent).put(String.valueOf(pathElement), parent);
                        continue;
                    }
                    catch (FlexiMapperException e) {
                        throw new WTFException("Should not happen. Parent is a node");
                    }
                }
                throw new IllegalPathException("Path does not exist: " + currentPath.toPathString(true));
            }
            throw new IllegalPathException("Path exists, but contains an unsupported element: " + currentPath.getParent() + "; Type:" + parent.getClass());
        }
        return parent;
    }

    public boolean isBreakOnError(Exception e) {
        return this.breakOnError;
    }

    protected boolean evalConditions(Condition[] conditions) {
        for (Condition c : conditions) {
            if (c.matchesWithoutExceptions(this.conditionMapper)) continue;
            if (this.logger != null) {
                this.logger.info("Condition failed: " + FlexiUtils.serializeMinimizedWithWTF(c));
            }
            return false;
        }
        if (this.logger != null) {
            this.logger.info("Conditions matched: " + FlexiUtils.serializeMinimizedWithWTF(conditions));
        }
        return true;
    }

    public FlexiModifier<T, MatcherType> conditionMatcher(MatcherType conditionMapper) {
        this.conditionMapper = conditionMapper;
        return this;
    }
}

