/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.mod;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.appwork.moncompare.Condition;
import org.appwork.storage.BuildsInfo;
import org.appwork.storage.FailLevel;
import org.appwork.storage.MapperType;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAvailableSince;
import org.appwork.storage.StorableDoc;
import org.appwork.storage.StorableSupportedMappers;
import org.appwork.storage.StorableValidateNotNull;
import org.appwork.storage.StorableValidator;
import org.appwork.storage.flexijson.CannotResolvePathException;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.InvalidPathException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.validator.classvalidator.StorableAbstractValidator;
import org.appwork.storage.validator.classvalidator.StorableClassValidator1;
import org.appwork.utils.reflection.CompiledType;

@StorableSupportedMappers(value={MapperType.AW_FLEXI})
public class JsonModification<TargetType, MatcherType>
implements Storable {
    private BuildsInfo targetBuilds;
    private Condition<MatcherType>[] conditions;
    @StorableDoc(value="Can be used to store a comment about the modification. This comment is not used in application logic.")
    private String comment;
    @StorableDoc(value="A int from -2147483648 to 2147483647. Modifications with higher priority are applied first.")
    private int priority = 0;
    private TargetType setIfUnset;
    private TargetType set;
    private Set<String> unset;

    @StorableAvailableSince(value="2023-07-5T00:00+0200", level=FailLevel.INFO)
    @StorableDoc(value="Information about the target Clients this configuration should be used with. This information is used to create warnings or to avoid that unsupported or deprectaed features are used.")
    @StorableValidateNotNull(description="It is recommended to set up a proper targetClients property.", level=FailLevel.WARNING)
    public BuildsInfo getTargetBuilds() {
        return this.targetBuilds;
    }

    public void setTargetBuilds(BuildsInfo clientInfo) {
        this.targetBuilds = clientInfo;
    }

    @StorableDoc(value="The Conditions property is used to specify under which circumstances a modification is applied.")
    public Condition<MatcherType>[] getConditions() {
        return this.conditions;
    }

    public void setConditions(Condition<MatcherType>[] conditions) {
        this.conditions = conditions;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @StorableDoc(value="Define fields to set if the path is not available in the target object - this can be used to define defaults")
    public TargetType getSetIfUnset() {
        return this.setIfUnset;
    }

    public void setSetIfUnset(TargetType setIfUnset) {
        this.setIfUnset = setIfUnset;
    }

    @StorableDoc(value="Define fields to set. Fields will get overwrittten")
    public TargetType getSet() {
        return this.set;
    }

    public void setSet(TargetType set) {
        this.set = set;
    }

    @StorableClassValidator1(cls=UnsetValidator.class)
    public Set<String> getUnset() {
        return this.unset;
    }

    public void setUnset(Set<String> unset) {
        this.unset = unset;
    }

    public static class UnsetValidator
    extends StorableAbstractValidator {
        @Override
        public List<? extends StorableValidator.ValidatorException> validate(StorableValidator validator, Object root, Object value, FlexiJSonNode node, JSPath path, CompiledType type, String parameter, FailLevel level, String message) {
            ArrayList<StorableValidator.ValidatorException> ret = new ArrayList<StorableValidator.ValidatorException>();
            if (node == null) {
                return ret;
            }
            if (!(node instanceof FlexiJSonArray)) {
                ret.add(new StorableValidator.InvalidTypeException(validator, path, node, type, "Array<String> expected!", FailLevel.ERROR));
            }
            CompiledType toCheckType = validator.getRootType().getComponentType().getComponentType();
            for (int i = 0; i < ((FlexiJSonArray)node).size(); ++i) {
                FlexiJSonNode element = (FlexiJSonNode)((FlexiJSonArray)node).get(i);
                String key = ((FlexiJSonValue)element).getStringValue();
                if (key == null) {
                    ret.add(new StorableValidator.ValidatorValueIsNullException(validator, path.derive(i), element, CompiledType.STRING, "May not be null", FailLevel.ERROR));
                    continue;
                }
                try {
                    try {
                        CompiledType exists = toCheckType.resolve(JSPath.fromPathString(key));
                        ret.add(new StorableValidator.ValidatorException(validator, path.derive(i), element, null, "Will delete '" + JSPath.fromPathString(key) + "' of type " + exists.toString(new CompiledType.ToStringRule(CompiledType.ToStringSyntax.JAVA)), FailLevel.INFO));
                    }
                    catch (CannotResolvePathException e) {
                        ret.add(new StorableValidator.ValidatorException(validator, path.derive(i), element, null, "Unknown element - the path " + JSPath.fromPathString(key) + " does not exist in " + toCheckType.toString(new CompiledType.ToStringRule(CompiledType.ToStringSyntax.JAVA)), FailLevel.WARNING));
                    }
                    continue;
                }
                catch (InvalidPathException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }

        @Override
        public String getDocsDescription(String parameter, Object anno) {
            return null;
        }
    }
}

