/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.stringify;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;

public class PropertyJSonPrettyStringify
extends FlexiJSonStringBuilder {
    @Override
    protected void initTags(Charset charset) {
        super.initTags(charset);
        this.lineCommentStart = "// ".getBytes(charset);
        this.inlineCommentStart = "/* ".getBytes(charset);
        this.inlineCommendEnd = " */".getBytes(charset);
    }

    @Override
    public String toJSONString(FlexiJSonNode node) {
        return super.toJSONString(node);
    }

    @Override
    public void appendPrimitiveValue(FlexiJSonValue value, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        FlexiJSonComments b = value.getCommentsBefore();
        FlexiJSonComments a = value.getCommentsAfter();
        if (b != null) {
            b.writeToStream(this, out, 0, path);
        }
        if (out.transferedBytes() > 0L) {
            out.write(this.newLineRN);
        }
        boolean first = true;
        for (Object e : path) {
            String n = (String)e;
            if (n.charAt(0) != '[' && !n.matches("^[a-zA-Z_$][a-zA-Z_$0-9]*$")) {
                n = "[" + JSonStorage.serializeToJson(n) + "]";
            }
            if (first) {
                first = false;
            } else if (n.charAt(0) != '[') {
                out.write(".".getBytes(this.charset));
            }
            out.write(n.getBytes(this.charset));
        }
        if (path.size() == 0) {
            out.write("value".getBytes(this.charset));
        }
        out.write(" = ".getBytes(this.charset));
        super.appendPrimitiveValueWithoutComments(value, out, path, layer);
        if (a != null) {
            a.writeToStream(this, out, 0, path);
        }
    }

    @Override
    protected void appendString(FlexiJSonStringBuilder.JSONBuilderOutputStream out, String s) throws IOException, CharacterCodingException {
        this.stringToStream(out, s.replace("\r", "\\r").replace("\n", "\\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendObject(FlexiJSonObject object, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        FlexiJSonComments b = object.getCommentsBefore();
        FlexiJSonComments a = object.getCommentsAfter();
        if (b != null) {
            b.writeToStream(this, out, layer, path);
        }
        for (KeyValueElement es : object.getElements()) {
            path.add(es.getKey());
            try {
                if (es.getCommentsBeforeKey() != null) {
                    es.getCommentsBeforeKey().writeToStream(this, out, layer + 1, path);
                }
                if (es.getKey() == null) continue;
                if (es.getCommentsAfterKey() != null) {
                    es.getCommentsAfterKey().writeToStream(this, out, layer + 1, path);
                }
                Set<FlexiMapperTags> tags = es.getValue().getTags();
                if (this.isWriteDefaultValuesAsComment(object, es.getValue(), path) && tags != null && tags.contains((Object)FlexiMapperTags.DEFAULT_VALUE)) {
                    String comment = this.toJSONString(es.getValue());
                    new FlexiComment(comment, FlexiComment.Type.INLINE, FlexiMapperTags.DEFAULT_VALUE).writeToStream(this, out, layer, path);
                    continue;
                }
                es.getValue().writeToStream(this, out, layer + this.getLayerIndent(), path);
            }
            finally {
                path.removeLast();
            }
        }
        if (object.getCommentsInside() != null) {
            for (FlexiCommentJsonNode c : object.getCommentsInside()) {
                c.writeToStream(this, out, layer + 1, path);
            }
        }
        if (a != null) {
            a.writeToStream(this, out, layer, path);
        }
    }

    public boolean isWriteDefaultValuesAsComment(FlexiJSonObject object, FlexiJSonNode value, LinkedList<String> path) {
        return false;
    }

    protected int getLayerIndent() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendArray(FlexiJSonArray array, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        try {
            FlexiJSonComments b = array.getCommentsBefore();
            FlexiJSonComments a = array.getCommentsAfter();
            if (b != null) {
                b.writeToStream(this, out, layer, path);
            }
            boolean firstElement = true;
            for (int i = 0; i < array.size(); ++i) {
                FlexiJSonNode n = (FlexiJSonNode)array.get(i);
                try {
                    path.add("[" + i + "]");
                    n.writeToStream(this, out, layer + 1, path);
                    continue;
                }
                finally {
                    path.removeLast();
                }
            }
            if (array.getCommentsInside() != null) {
                if (!firstElement) {
                    out.write(this.commaString);
                    out.write(this.spaceString);
                }
                array.getCommentsInside().writeToStream(this, out, layer, path);
            }
            if (a != null) {
                a.writeToStream(this, out, layer, path);
            }
        }
        catch (Throwable e) {
            System.out.println(1);
            throw new WTFException(e);
        }
    }

    @Override
    public void appendComment(FlexiComment comment, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        this.writeIfNotEOL(out);
        for (String line : comment.getText().split("[\r\n]{1,2}")) {
            if (Arrays.equals(out.getLookBackBuffer(), this.newLineRN) || out.transferedBytes() == 0L) {
                this.stringToStream(out, "# " + line.trim());
                continue;
            }
            this.stringToStream(out, "\r\n# " + line.trim());
        }
    }

    @Override
    public void appendComments(FlexiJSonComments comments, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        for (FlexiCommentJsonNode c : comments) {
            c.writeToStream(this, out, 0, path);
        }
    }
}

