/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MinimalMemoryMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final Object NULLKEY = new Object();
    private Object[] table = null;

    public MinimalMemoryMap() {
    }

    public MinimalMemoryMap(int initialCapacity) {
        if (initialCapacity > 0) {
            this.ensureCapacity(initialCapacity);
        }
    }

    public MinimalMemoryMap(Map<K, V> map) {
        if (map != null) {
            this.ensureCapacity(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.putObject(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void main(String[] args) {
        MinimalMemoryMap<String, Boolean> test = new MinimalMemoryMap<String, Boolean>();
        System.out.println(test.put("test", Boolean.TRUE) + " " + test.size() + "\t" + test);
        System.out.println(test.put("test", Boolean.FALSE) + " " + test.size() + "\t" + test);
        System.out.println(test.put("test2", Boolean.FALSE) + " " + test.size() + "\t" + test);
        System.out.println(test.put(null, Boolean.FALSE) + " " + test.size() + "\t" + test);
        System.out.println(test.put(null, Boolean.TRUE) + " " + test.size() + "\t" + test);
        System.out.println(test.remove(null) + " " + test.size() + "\t" + test);
        System.out.println(test.remove(null) + " " + test.size() + "\t" + test);
        Iterator it = test.entrySet().iterator();
        System.out.println(test.remove("test") + " " + test.size() + "\t" + test);
        System.out.println(test.remove("test") + " " + test.size() + "\t" + test);
    }

    protected Object[] getTable() {
        return this.table;
    }

    protected Object[] ensureCapacity(int capacity) {
        if (this.table == null && capacity == 0) {
            return null;
        }
        if (this.table == null) {
            this.table = new Object[capacity * 2];
        } else {
            int length = this.table.length;
            int grow = capacity * 2 - length;
            if (grow > 0) {
                Object[] tmpTable = new Object[length + grow];
                System.arraycopy(this.table, 0, tmpTable, 0, length);
                this.table = tmpTable;
            }
        }
        return this.table;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getKeyIndex(key) >= 0;
    }

    @Override
    public V remove(Object key) {
        Object[] table = this.getTable();
        int index = this.getKeyIndex(key);
        if (index >= 0 && table != null) {
            Object value = table[index + 1];
            table[index] = null;
            table[index + 1] = null;
            return (V)value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        return this.putObject(key, value);
    }

    @Override
    public V get(Object key) {
        return this.getValue(key);
    }

    protected V putObject(Object key, V value) {
        if (key == null) {
            key = NULLKEY;
        }
        Object[] table = this.ensureCapacity(1);
        int length = table.length;
        int index = this.getKeyIndex(key);
        if (index != -1) {
            Object old = table[index + 1];
            table[index + 1] = value;
            return (V)old;
        }
        for (index = 0; index < length; index += 2) {
            if (table[index] != null) continue;
            table[index] = key;
            table[index + 1] = value;
            return null;
        }
        Object[] newTable = this.ensureCapacity(length / 2 + 1);
        newTable[length] = key;
        newTable[length + 1] = value;
        return null;
    }

    protected V getValue(Object key) {
        Object[] table = this.getTable();
        if (table != null) {
            if (key == null) {
                key = NULLKEY;
            }
            int length = table.length;
            for (int index = 0; index < length; index += 2) {
                if (!key.equals(table[index])) continue;
                return (V)table[index + 1];
            }
        }
        return null;
    }

    protected int getKeyIndex(Object key) {
        Object[] table = this.getTable();
        if (table != null) {
            if (key == null) {
                key = NULLKEY;
            }
            int length = table.length;
            for (int index = 0; index < length; index += 2) {
                if (!key.equals(table[index])) continue;
                return index;
            }
        }
        return -1;
    }

    @Override
    public boolean containsValue(Object value) {
        Object[] table = this.getTable();
        if (table != null) {
            int length = table.length;
            for (int index = 0; index < length; index += 2) {
                Object v = table[index + 1];
                if ((value == null || !value.equals(v)) && (value != null || v != null)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.table = null;
    }

    @Override
    public int size() {
        Object[] table = this.getTable();
        int ret = 0;
        if (table != null) {
            int length = table.length;
            for (int index = 0; index < length - 1; index += 2) {
                if (table[index] == null) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public boolean isEmpty() {
        Object[] table = this.getTable();
        if (table != null) {
            int length = table.length;
            for (int index = 0; index < length - 1; index += 2) {
                if (table[index] == null) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    int index = 0;
                    Map.Entry<K, V> last = null;

                    @Override
                    public boolean hasNext() {
                        Object[] table = MinimalMemoryMap.this.getTable();
                        for (int pos = this.index; table != null && pos < table.length - 1; pos += 2) {
                            if (table[pos] == null) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void remove() {
                        if (this.last != null) {
                            MinimalMemoryMap.this.remove(this.last.getKey());
                            this.last = null;
                        }
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        Object[] table = MinimalMemoryMap.this.getTable();
                        int pos = this.index;
                        while (table != null && pos < table.length - 1) {
                            Object key = table[pos];
                            Object value = table[pos + 1];
                            this.index = pos += 2;
                            if (key == null) continue;
                            this.last = new AbstractMap.SimpleEntry<K, V>(key == NULLKEY ? null : key, value){

                                @Override
                                public V setValue(V value) {
                                    super.setValue(value);
                                    return MinimalMemoryMap.this.put(this.getKey(), value);
                                }
                            };
                            return this.last;
                        }
                        return null;
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return MinimalMemoryMap.this.isEmpty();
            }

            @Override
            public int size() {
                return MinimalMemoryMap.this.size();
            }
        };
    }
}

