/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.sunwrapper.sun.swing;

import java.awt.Color;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import org.appwork.utils.ReflectionUtils;

public class DefaultLookupWrapper {
    private static Method getColorMethod = null;
    private static boolean preferNativeGetColorMethod = true;
    private static Method getBorderMethod = null;
    private static boolean preferNativeGetBorderMethod = true;

    private static Method findGetColorMethod(JComponent comp, ComponentUI ui, String key) {
        Object[] params = new Object[]{comp, ui, key};
        try {
            return ReflectionUtils.findMatchingMethod("sun.swing.DefaultLookup", "getColor", params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Color getColor(JComponent comp, ComponentUI ui, String key) {
        try {
            Method method = getColorMethod;
            if (method == null && preferNativeGetColorMethod) {
                getColorMethod = method = DefaultLookupWrapper.findGetColorMethod(comp, ui, key);
            }
            if (method != null) {
                return (Color)method.invoke(null, comp, ui, key);
            }
            preferNativeGetColorMethod = false;
        }
        catch (NoClassDefFoundError e) {
            preferNativeGetColorMethod = false;
        }
        catch (IllegalAccessError e) {
            preferNativeGetColorMethod = false;
        }
        catch (Exception ignore) {
            preferNativeGetColorMethod = false;
        }
        return (Color)UIManager.get(key, comp.getLocale());
    }

    private static Method findGetBorderMethod(JComponent comp, ComponentUI ui, String key) {
        Object[] params = new Object[]{comp, ui, key};
        try {
            return ReflectionUtils.findMatchingMethod("sun.swing.DefaultLookup", "getBorder", params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Border getBorder(JComponent comp, ComponentUI ui, String key) {
        try {
            Method method = getBorderMethod;
            if (method == null && preferNativeGetBorderMethod) {
                getBorderMethod = method = DefaultLookupWrapper.findGetBorderMethod(comp, ui, key);
            }
            if (method != null) {
                return (Border)method.invoke(null, comp, ui, key);
            }
            preferNativeGetBorderMethod = false;
        }
        catch (NoClassDefFoundError e) {
            preferNativeGetBorderMethod = false;
        }
        catch (IllegalAccessError e) {
            preferNativeGetBorderMethod = false;
        }
        catch (Exception ignore) {
            preferNativeGetBorderMethod = false;
        }
        return (Border)UIManager.get(key, comp.getLocale());
    }
}

