/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.circlebar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;
import org.appwork.swing.components.circlebar.CircleProgressBarUI;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.exttable.columns.ExtCircleProgressColumn;
import org.appwork.utils.event.predefined.changeevent.ChangeEvent;
import org.appwork.utils.event.predefined.changeevent.ChangeListener;

public class BasicCircleProgressBarUI
extends CircleProgressBarUI {
    private float animationStepSize = 0.0f;
    private static final Color FOREGROUND = Color.GREEN;
    private Timer timer;
    private CircledProgressBar circleBar;
    private Handler handler;
    private float animatedProgress = 0.0f;

    public static ComponentUI createUI(JComponent x) {
        return new BasicCircleProgressBarUI();
    }

    public void cleanUpIndeterminateValues() {
        Timer ltimer = this.timer;
        if (ltimer != null) {
            ltimer.stop();
        }
        this.timer = null;
        this.animatedProgress = 0.0f;
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return super.getBaseline(c, width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        return super.getBaselineResizeBehavior(c);
    }

    private Color getForeground() {
        Color fg = this.circleBar.getForeground();
        return fg == null ? FOREGROUND : fg;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return super.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return super.getMinimumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.circleBar.getValueClipPainter().getPreferredSize();
    }

    public void initIndeterminate() {
        if (this.timer != null) {
            return;
        }
        Timer timer = new Timer(1000 / this.circleBar.getAnimationFPS(), new AnimationListener());
        timer.setInitialDelay(0);
        timer.setRepeats(true);
        timer.start();
        this.timer = timer;
    }

    private void installListeners() {
        this.handler = new Handler();
        this.circleBar.addPropertyChangeListener(this.handler);
        this.circleBar.getEventSender().addListener(this.handler);
    }

    @Override
    public void installUI(JComponent c) {
        this.circleBar = (CircledProgressBar)c;
        this.installListeners();
        if (this.circleBar.isIndeterminate()) {
            this.initIndeterminate();
        }
    }

    public void paint(Graphics g, double progress, IconPainter bgi, IconPainter clipIcon) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Insets b = this.circleBar.getInsets();
        Dimension size = this.circleBar.getSize();
        int diameter = Math.min(size.height - b.top - b.bottom, size.width - b.left - b.right);
        int midy = b.top + (size.height - b.top - b.bottom) / 2;
        int midx = b.left + (size.width - b.left - b.right) / 2;
        g2.translate(midx, midy);
        Area clip = null;
        if (progress == 1.0) {
            clip = new Area(new Ellipse2D.Float(-diameter, -diameter, diameter * 2, diameter * 2));
        } else if (progress > 0.0) {
            clip = new Area(new Arc2D.Float(-diameter, -diameter, diameter * 2, diameter * 2, 90.0f, (float)(-progress * 360.0), 2));
        }
        g2.setColor(Color.RED);
        if (clip != null) {
            // empty if block
        }
        if (bgi != null) {
            Area a = new Area(new Rectangle2D.Double(-diameter, -diameter, diameter * 2, diameter * 2));
            if (clip != null) {
                a.subtract(new Area(clip));
            }
            bgi.paint(this.circleBar, g2, a, diameter, progress);
        }
        if (clipIcon != null && clip != null) {
            clipIcon.paint(this.circleBar, g2, clip, diameter, progress);
        }
        g2.translate(-midx, -midy);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.circleBar.isIndeterminate()) {
            this.paintIndeterminate(g);
        } else {
            this.paintDeterminate(g);
        }
    }

    private void paintDeterminate(Graphics g) {
        BoundedRangeModel model = this.circleBar.getModel();
        double progress = (double)model.getValue() / (double)model.getMaximum();
        this.paint(g, progress, this.circleBar.getNonvalueClipPainter(), this.circleBar.getValueClipPainter());
    }

    private void paintIndeterminate(Graphics g) {
        if ((double)this.animatedProgress > 1.0) {
            this.paint(g, (double)this.animatedProgress - 1.0, this.circleBar.getValueClipPainter(), this.circleBar.getNonvalueClipPainter());
        } else {
            this.paint(g, this.animatedProgress, this.circleBar.getNonvalueClipPainter(), this.circleBar.getValueClipPainter());
        }
    }

    private void paintIndeterminate(Graphics g, double progress, IconPainter bgi, IconPainter clipIcon) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Insets b = this.circleBar.getInsets();
        Dimension size = this.circleBar.getSize();
        int diameter = Math.min(size.height - b.top - b.bottom, size.width - b.left - b.right);
        g2.translate(b.left, b.top);
        float pDia = (float)((double)diameter * progress);
        Ellipse2D.Float clip = new Ellipse2D.Float(((float)diameter - pDia) / 2.0f, ((float)diameter - pDia) / 2.0f, pDia, pDia);
        if (bgi != null) {
            Area a = new Area(new Rectangle2D.Double(0.0, 0.0, diameter, diameter));
            a.subtract(new Area(clip));
            g2.setClip(a);
            bgi.paint(this.circleBar, g2, null, diameter, progress);
        }
        g2.setClip(clip);
        if (clipIcon != null) {
            clipIcon.paint(this.circleBar, g2, null, diameter, progress);
        }
        g2.translate(-b.left, -b.top);
    }

    private void uninstallListeners() {
        this.circleBar.removePropertyChangeListener(this.handler);
        this.circleBar.getEventSender().removeListener(this.handler);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.circleBar = null;
        this.uninstallListeners();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
    }

    class Handler
    implements PropertyChangeListener,
    ChangeListener {
        Handler() {
        }

        @Override
        public void onChangeEvent(ChangeEvent event) {
            if (!BasicCircleProgressBarUI.this.circleBar.isIndeterminate()) {
                BasicCircleProgressBarUI.this.circleBar.repaint();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("indeterminate" == prop) {
                if (BasicCircleProgressBarUI.this.circleBar.isIndeterminate()) {
                    BasicCircleProgressBarUI.this.initIndeterminate();
                } else {
                    BasicCircleProgressBarUI.this.cleanUpIndeterminateValues();
                }
                BasicCircleProgressBarUI.this.circleBar.repaint();
            }
            BasicCircleProgressBarUI.this.animationStepSize = 1.0f / ((float)BasicCircleProgressBarUI.this.circleBar.getAnimationFPS() / BasicCircleProgressBarUI.this.circleBar.getCyclesPerSecond());
        }
    }

    class AnimationListener
    implements ActionListener {
        AnimationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BasicCircleProgressBarUI.this.circleBar.isDisplayable()) {
                BasicCircleProgressBarUI.this.cleanUpIndeterminateValues();
            }
            if (BasicCircleProgressBarUI.this.circleBar.isShowing() || BasicCircleProgressBarUI.this.circleBar instanceof ExtCircleProgressColumn.IndeterminatedCircledProgressBar) {
                BasicCircleProgressBarUI.this.animatedProgress = BasicCircleProgressBarUI.this.animatedProgress + BasicCircleProgressBarUI.this.animationStepSize;
                BasicCircleProgressBarUI.this.animatedProgress = BasicCircleProgressBarUI.this.animatedProgress % 2.0f;
                BasicCircleProgressBarUI.this.circleBar.repaint();
            }
        }
    }
}

