/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.tooltips;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.TooltipPanel;
import org.appwork.utils.swing.SwingUtils;

public class BasicExtTooltip
extends ExtTooltip
implements PropertyChangeListener {
    private static final long serialVersionUID = 6869465876669412410L;
    private JTextArea tf;
    private final JComponent component;

    public BasicExtTooltip(JComponent circledProgressBar) {
        this.component = circledProgressBar;
        this.component.addPropertyChangeListener("ToolTipText", this);
        this.tf.setText(this.component.getToolTipText());
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.component.removePropertyChangeListener("ToolTipText", this);
    }

    @Override
    public TooltipPanel createContent() {
        TooltipPanel p = new TooltipPanel("ins 2,wrap 1", "[]", "[]");
        this.tf = new JTextArea();
        Color color = UIManager.getColor("Appwork.Tooltip.Foreground");
        if (color == null) {
            color = new JLabel().getForeground();
        }
        this.tf.setForeground(color);
        this.tf.setBackground(null);
        this.tf.setEditable(false);
        SwingUtils.setOpaque(this.tf, false);
        p.add(this.tf);
        return p;
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.component.getToolTipText() == null || this.component.getToolTipText().length() == 0) {
            ToolTipController.getInstance().hideTooltip();
        } else {
            this.tf.setText(this.component.getToolTipText());
            System.out.println(this.component.getToolTipText());
            this.repaint();
        }
    }

    @Override
    public String toText() {
        return this.tf.getText();
    }
}

