/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.locale._AWU;

public abstract class ExtPasswordEditorColumn<E>
extends ExtTextColumn<E>
implements ActionListener {
    private static final long serialVersionUID = -3107569347493659178L;
    private static final String BLINDTEXT = "******";

    public ExtPasswordEditorColumn(String name) {
        this(name, null);
    }

    public ExtPasswordEditorColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.editorField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ExtPasswordEditorColumn.this.editorField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return this.editorField;
    }

    protected abstract String getPlainStringValue(E var1);

    @Override
    public String getStringValue(E value) {
        return this.hasPassword(value) ? BLINDTEXT : "";
    }

    @Override
    protected String getTooltipText(E obj) {
        return _AWU.T.extpasswordeditorcolumn_tooltip();
    }

    private boolean hasPassword(E value) {
        String pw = this.getPlainStringValue(value);
        return pw != null && pw.length() > 0;
    }

    @Override
    public boolean isEditable(E obj) {
        return true;
    }

    @Override
    public boolean matchSearch(E object, Pattern pattern) {
        return false;
    }

    @Override
    protected abstract void setStringValue(String var1, E var2);

    @Override
    public void setValue(Object value, E object) {
        if (!value.toString().equals(BLINDTEXT)) {
            this.setStringValue((String)value, object);
        }
    }
}

