/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.testframework;

import java.awt.AWTException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.sink.SimpleFormatter;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.storage.tests.ClassPathScanner;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.TestInterface;
import org.appwork.utils.Application;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.LineParsingOutputStream;
import org.appwork.utils.reflection.CompiledType;

public class IDETestRunner {
    private static File lastExecutedTestsFile = null;

    private static void init() {
        Application.setApplication(".tests");
        lastExecutedTestsFile = Application.getResource("cfg/lastExecutedTests.classes");
        AWTest.initLogger(new SimpleFormatter(){
            {
                this.offsetForThrownAt = new SimpleFormatter.IntByReference(20);
            }

            @Override
            protected String createPre(LogRecord2 record, String sourceString) {
                if ((IDETestRunner.class.getSimpleName() + ".java").equals(record.getThrownAt().getFileName())) {
                    return 1.fillPre(((SimpleDateFormat)this.longTimestamp.get()).format(new Date(record.timestamp)), " ", this.offsetForTimestamp) + " - ";
                }
                return 1.fillPre(((SimpleDateFormat)this.longTimestamp.get()).format(new Date(record.timestamp)), " ", this.offsetForTimestamp) + " - " + 1.fillPost("(" + record.getThrownAt().getFileName() + ":" + record.getThrownAt().getLineNumber() + ")." + this.abbr(record.getThrownAt().getMethodName(), 30), " ", this.offsetForThrownAt) + " > ";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        IDETestRunner.init();
        PrintStream outBefore = System.out;
        PrintStream errBefore = System.err;
        System.setOut(new PrintStream(new LineParsingOutputStream(Charset.forName("UTF-8")){

            @Override
            protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
                LogV3.info("stdout> " + sb.substring(startIndex, endIndex));
            }
        }));
        System.setErr(new PrintStream(new LineParsingOutputStream(Charset.forName("UTF-8")){

            @Override
            protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
                LogV3.severe("stderr> " + sb.substring(startIndex, endIndex));
            }
        }));
        try {
            IDETestRunner.runClasspathTests();
        }
        catch (Throwable e) {
            AWTest.setLoggerSilent(false, true);
            LogV3.log(e);
        }
        finally {
            System.setErr(errBefore);
            System.setOut(outBefore);
        }
        if (!Arrays.asList(args).contains("-noexit")) {
            LogV3.disableSysout();
            System.exit(0);
        }
    }

    public static void runClasspathTests() throws URISyntaxException, ClassNotFoundException {
        AWTest.pauseLogger();
        ArrayList<String> testClasses = new ArrayList<String>();
        ArrayList<String> lastExecutedTestClasses = new ArrayList<String>();
        Object lastFailedClassName = null;
        if (lastExecutedTestsFile != null && lastExecutedTestsFile.isFile()) {
            try {
                String[] lastExecutedTests;
                for (String lastExecutedTest : lastExecutedTests = IO.readFileToTrimmedString(lastExecutedTestsFile).split("\r\n")) {
                    if (!StringUtils.isNotEmpty(lastExecutedTest)) continue;
                    lastExecutedTestClasses.add(lastExecutedTest);
                }
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
        for (URL url : ClassPathScanner.getClassPath()) {
            File root = new File(url.toURI());
            if (!root.isDirectory()) continue;
            AWTest.logInfoAnyway("Scan " + root);
            List<File> files = Files.getFiles(true, true, root);
            int testsFound = 0;
            for (File file : files) {
                String rel = Files.getRelativePath(root, file);
                if (!rel.matches("(?i).*(test|ide).*\\.class$") || !file.isFile()) continue;
                testClasses.add(rel.replace("/", ".").substring(0, rel.length() - ".class".length()));
                ++testsFound;
            }
            AWTest.logInfoAnyway("Scanned " + root + " and found " + files.size() + " files and " + testsFound + " test-related classes/files");
        }
        Collections.shuffle(testClasses);
        Iterator it = lastExecutedTestClasses.iterator();
        while (it.hasNext()) {
            String lastExecutedTestClass = (String)it.next();
            if (!testClasses.remove(lastExecutedTestClass)) continue;
            if (it.hasNext()) {
                testClasses.add(lastExecutedTestClass);
                continue;
            }
            testClasses.add(0, lastExecutedTestClass);
        }
        int actualTestCount = 0;
        for (String testClass : testClasses) {
            Class<?> cls = Class.forName(testClass, false, Thread.currentThread().getContextClassLoader());
            if (!TestInterface.class.isAssignableFrom(cls) || TestInterface.class == cls || cls == AWTest.class) continue;
            ++actualTestCount;
        }
        AWTest.logInfoAnyway("Found  " + testClasses.size() + " test-related classes/files - Actual Tests: " + actualTestCount);
        for (String testClass : testClasses) {
            Class<?> cls = Class.forName(testClass, false, Thread.currentThread().getContextClassLoader());
            if (!TestInterface.class.isAssignableFrom(cls) || TestInterface.class == cls || cls == AWTest.class) continue;
            IDETestRunner.runTestInternal(cls);
        }
        AWTest.logInfoAnyway("Finished IDE Build Tests");
        lastExecutedTestsFile.delete();
    }

    private static void runTestInternal(Class<?> cls) {
        try {
            if (Modifier.isAbstract(cls.getModifiers())) {
                return;
            }
            if (cls.isAnonymousClass()) {
                return;
            }
            FileOutputStream fos = new FileOutputStream(lastExecutedTestsFile, true);
            try {
                fos.write(("\r\n" + cls.getName()).getBytes("UTF-8"));
            }
            finally {
                fos.close();
            }
            AWTest.logInfoAnyway("[** START **]" + cls.getName());
            ((TestInterface)ClassCache.getClassCache(cls).getInstance()).runTest();
            if (!CompiledType.isThreadLocalCacheEmpty()) {
                throw new AWTException("CompiledType.ThreadLocalCache is not empty!");
            }
            AWTest.clearLoggerCache();
            AWTest.logInfoAnyway("    >> SUCCESS");
        }
        catch (Exception e) {
            AWTest.setLoggerSilent(false, true);
            LogV3.info("FAILED " + cls.getName());
            LogV3.log(e);
            LogV3.disableSysout();
            System.exit(1);
        }
    }

    public static void run(Class<? extends TestInterface> cls) {
        IDETestRunner.init();
        IDETestRunner.runTestInternal(cls);
    }
}

