/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.timetracker;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.appwork.loggingv3.LogV3;
import org.appwork.timetracker.TrackedEntry;
import org.appwork.timetracker.TrackerJob;
import org.appwork.timetracker.TrackerRule;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogInterface;

public class TimeTracker {
    private final String id;
    private final CopyOnWriteArrayList<TrackerRule> rules = new CopyOnWriteArrayList();
    private final LinkedList<TrackedEntry> entries = new LinkedList();
    private final LogInterface logger;

    public String getId() {
        return this.id;
    }

    public TimeTracker(String typeID) {
        this.id = typeID;
        this.logger = LogV3.I().getLogger("TimeTracker " + this.id);
    }

    public void addRule(TrackerRule rule) {
        if (rule != null) {
            this.rules.addIfAbsent(rule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(TrackerJob job) throws InterruptedException {
        TrackedEntry entry;
        if (this.rules.size() == 0 || job == null) {
            return;
        }
        TimeTracker timeTracker = this;
        synchronized (timeTracker) {
            long waitFor = this.getWaitFor(job.getWeight());
            entry = this.createEntry(waitFor, job.getWeight());
            this.entries.add(entry);
        }
        if (entry.getWaitFor() > 0L) {
            this.logger.info("Wait " + TimeFormatter.formatMilliSeconds(entry.getWaitFor(), 0));
            job.waitForNextSlot(entry.getWaitFor());
        }
        job.run();
        this.logger.info("RUN");
    }

    protected long getWaitFor(int weight) {
        int sum = 0;
        LinkedList<TrackerRule> lRules = new LinkedList<TrackerRule>(this.rules);
        ListIterator<TrackedEntry> itEntres = this.entries.listIterator(this.entries.size());
        long time = System.currentTimeMillis();
        this.logger.info("Find wait For");
        long interval = 0L;
        while (itEntres.hasPrevious()) {
            TrackedEntry entry = itEntres.previous();
            this.logger.info("Check Entry " + new Date(entry.getTime()));
            sum += entry.getWeight();
            Iterator it = lRules.iterator();
            while (it.hasNext()) {
                long ninterval;
                TrackerRule r = (TrackerRule)it.next();
                long diff = time - entry.getTime();
                if (diff > (long)r.getInterval()) {
                    it.remove();
                    if (lRules.size() != 0) continue;
                    this.logger.info("" + sum + "/" + r.getAmount() + " in the last " + r.getInterval());
                    while (itEntres.hasPrevious()) {
                        itEntres.previous();
                        itEntres.remove();
                    }
                    return interval;
                }
                if (sum < r.getAmount() || (ninterval = Math.max(interval, (long)r.getInterval() - diff)) <= interval) continue;
                this.logger.info("" + sum + "/" + r.getAmount() + " in the last " + r.getInterval() + " -> Wait " + TimeFormatter.formatMilliSeconds(interval, 0));
                interval = ninterval;
            }
        }
        this.logger.info("" + sum + " --> " + TimeFormatter.formatMilliSeconds(interval, 0));
        return interval;
    }

    protected TrackedEntry createEntry(long waitFor, int weight) {
        return new TrackedEntry(weight, waitFor);
    }
}

