/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.loggingv3.NullLogger;
import org.appwork.updatesys.client.AccessCallback;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.FileAccessType;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.locale.UpdTrans;
import org.appwork.utils.Exceptions;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.NonInterruptibleRunnableException;
import org.appwork.utils.extioexceptions.CouldNotCreateDirectoryExtIOException;
import org.appwork.utils.extioexceptions.CouldNotCreateHardlinkExtIOException;
import org.appwork.utils.extioexceptions.CouldNotDeleteFileExtIOException;
import org.appwork.utils.extioexceptions.CouldNotOpenFileInputStreamExtIOException;
import org.appwork.utils.extioexceptions.CouldNotOpenFileOutputStreamExtIOException;
import org.appwork.utils.extioexceptions.CouldNotReadFileExtIOException;
import org.appwork.utils.extioexceptions.CouldNotRenameDirectory;
import org.appwork.utils.extioexceptions.CouldNotRenameFile;
import org.appwork.utils.extioexceptions.CouldNotWriteFileExtIOException;
import org.appwork.utils.extioexceptions.FileNotFoundExtIOException;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;

public class DefaultFileAccessHandler
implements FileAccessHandler {
    protected final UpdateClient updateClient;
    protected final AccessCallback accessCallback;

    public UpdateClient getUpdateClient() {
        return this.updateClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveFile(File src, File dst, boolean deleteDest) throws ExtIOException, InterruptedException {
        if (src.equals(dst)) {
            return;
        }
        try {
            this.request(src, FileAccessType.DELETE);
            try {
                this.request(dst, FileAccessType.WRITE);
                try {
                    this.moveImpl(src, dst, deleteDest);
                }
                catch (Throwable throwable) {
                    this.release(dst, FileAccessType.WRITE);
                    throw throwable;
                }
                this.release(dst, FileAccessType.WRITE);
            }
            catch (Throwable throwable) {
                this.release(src, FileAccessType.DELETE);
                throw throwable;
            }
            this.release(src, FileAccessType.DELETE);
        }
        catch (RuntimeException e) {
            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
        }
    }

    protected void moveImpl(File src, File dest, boolean deleteDest) throws ExtIOException, InterruptedException {
        try {
            if (!src.exists()) {
                throw new FileNotFoundExtIOException(UpdTrans.I().getErrorCannotMoveNonExistingFile(src, dest), null, src);
            }
            boolean isDir = src.isDirectory();
            if (dest.exists()) {
                if (deleteDest) {
                    this.deleteFileIfExists(dest);
                } else {
                    if (isDir) {
                        throw new CouldNotRenameDirectory(UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dest), null, dest, src);
                    }
                    throw new CouldNotRenameFile(UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dest), null, dest, src);
                }
            }
            this.mkdirs(dest.getParentFile());
            boolean result = src.renameTo(dest);
            if (!result && CrossSystem.isWindows()) {
                this.getLogger().info("Apply workaround for File.renameTo(" + src.toString() + "," + dest.toString());
                Thread.sleep(500L);
                result = src.exists() ? src.renameTo(dest) : true;
            }
            if (!result) {
                if (isDir) {
                    throw new CouldNotRenameDirectory(UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dest), null, dest, src);
                }
                throw new CouldNotRenameFile(UpdTrans.I().getErrorCouldNotMoveFILEAtoFILEB(src, dest), null, dest, src);
            }
        }
        catch (RuntimeException e) {
            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(File src, File dest, boolean deleteDest, IO.SYNC sync) throws ExtIOException, InterruptedException {
        try {
            if (deleteDest) {
                this.deleteFileIfExists(dest);
            }
            this.request(src, FileAccessType.READ);
            try {
                this.request(dest, FileAccessType.WRITE);
                try {
                    this.mkdirs(dest.getParentFile());
                    IO.copyFile(src, dest, sync);
                }
                catch (Throwable throwable) {
                    this.release(src, FileAccessType.WRITE);
                    throw throwable;
                }
                this.release(src, FileAccessType.WRITE);
            }
            catch (Throwable throwable) {
                this.release(dest, FileAccessType.READ);
                throw throwable;
            }
            this.release(dest, FileAccessType.READ);
        }
        catch (ClosedByInterruptException e) {
            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
        }
        catch (IOException e) {
            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
        }
        catch (RuntimeException e) {
            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(File file, byte[] bytes, boolean overwrite) throws ExtIOException, InterruptedException {
        try {
            this.request(file, FileAccessType.WRITE);
            try {
                if (overwrite) {
                    this.deleteFileIfExists(file);
                }
                this.mkdirs(file.getParentFile());
                IO.writeToFile(file, bytes);
            }
            catch (Throwable throwable) {
                this.release(file, FileAccessType.WRITE);
                throw throwable;
            }
            this.release(file, FileAccessType.WRITE);
        }
        catch (ClosedByInterruptException e) {
            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
        }
        catch (IOException e) {
            throw new CouldNotWriteFileExtIOException(UpdTrans.I().getErrorCannotWriteFile(file), e, file);
        }
        catch (RuntimeException e) {
            throw new CouldNotWriteFileExtIOException(UpdTrans.I().getErrorCannotWriteFile(file), e, file);
        }
    }

    @Override
    public void secureWrite(final File file, final byte[] bytes, final boolean overwrite) throws ExtIOException {
        new NonInterruptibleRunnableException<ExtIOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void execute() throws ExtIOException, InterruptedException {
                try {
                    File newTmp = new File(file.getAbsolutePath() + ".new");
                    DefaultFileAccessHandler.this.mkdirs(newTmp.getParentFile());
                    DefaultFileAccessHandler.this.deleteFileIfExists(newTmp);
                    boolean deleteFile = true;
                    try {
                        DefaultFileAccessHandler.this.request(newTmp, FileAccessType.WRITE);
                        try {
                            IO.writeToFile(newTmp, bytes, IO.SYNC.META_AND_DATA);
                        }
                        catch (Throwable throwable) {
                            DefaultFileAccessHandler.this.release(newTmp, FileAccessType.WRITE);
                            throw throwable;
                        }
                        DefaultFileAccessHandler.this.release(newTmp, FileAccessType.WRITE);
                        DefaultFileAccessHandler.this.moveFile(newTmp, file, overwrite);
                        deleteFile = false;
                    }
                    finally {
                        if (deleteFile) {
                            DefaultFileAccessHandler.this.deleteFileIfExists(newTmp);
                        }
                    }
                }
                catch (ClosedByInterruptException e) {
                    throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                }
                catch (FileNotFoundException e) {
                    throw new FileNotFoundExtIOException("Could not open(write) the file " + file, e, file);
                }
                catch (IOException e) {
                    throw new CouldNotWriteFileExtIOException(UpdTrans.I().getErrorCannotWriteFile(file), e, file);
                }
                catch (RuntimeException e) {
                    throw new CouldNotWriteFileExtIOException(UpdTrans.I().getErrorCannotWriteFile(file), e, file);
                }
            }
        }.startAndWait();
    }

    @Override
    public void release(File file, FileAccessType ... type) throws ExtIOException {
        AccessCallback accessCallback = this.getAccessCallback();
        if (accessCallback != null) {
            accessCallback.onFileAccessRelease(this, file, type);
        }
    }

    @Override
    public void request(File file, FileAccessType ... type) throws ExtIOException {
        AccessCallback accessCallback = this.getAccessCallback();
        if (accessCallback != null) {
            accessCallback.onFileAccessRequest(this, file, type);
        }
    }

    public AccessCallback getAccessCallback() {
        return this.accessCallback;
    }

    @Override
    public boolean deleteFileIfExists(File file) throws ExtIOException, InterruptedException {
        boolean bl;
        if (file == null || !file.exists()) {
            return false;
        }
        this.request(file, FileAccessType.DELETE);
        try {
            bl = this.deleteFileIfExistsImpl(file);
        }
        catch (Throwable throwable) {
            this.release(file, FileAccessType.DELETE);
            throw throwable;
        }
        this.release(file, FileAccessType.DELETE);
        return bl;
    }

    protected boolean deleteFileIfExistsImpl(File file) throws ExtIOException, InterruptedException {
        if (!file.delete() && file.exists()) {
            throw new CouldNotDeleteFileExtIOException(UpdTrans.I().getErrorCouldNotDeleteFILE(file), null, file);
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileInputStream openFileInputStream(final File file) throws ExtIOException {
        FileInputStream fileInputStream;
        AtomicBoolean releaseFlag = new AtomicBoolean(true);
        final FileAccessType fileAccessType = FileAccessType.READ;
        this.request(file, fileAccessType);
        try {
            final AtomicBoolean finalReleaseFlag = releaseFlag;
            FileInputStream fis = new FileInputStream(file){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    catch (Throwable throwable) {
                        DefaultFileAccessHandler.this.release(finalReleaseFlag, file, new FileAccessType[]{fileAccessType});
                        throw throwable;
                    }
                    DefaultFileAccessHandler.this.release(finalReleaseFlag, file, new FileAccessType[]{fileAccessType});
                }
            };
            releaseFlag = null;
            fileInputStream = fis;
        }
        catch (FileNotFoundException e) {
            try {
                try {
                    this.release(releaseFlag, file, fileAccessType);
                    throw new FileNotFoundExtIOException("Could not open(read) the file " + file, e, file);
                }
                catch (ExtIOException sub) {
                    Exceptions.addSuppressed(e, sub);
                    throw new FileNotFoundExtIOException("Could not open(read) the file " + file, e, file);
                }
                catch (RuntimeException sub) {
                    Exceptions.addSuppressed(e, sub);
                }
                throw new FileNotFoundExtIOException("Could not open(read) the file " + file, e, file);
                catch (RuntimeException e2) {
                    try {
                        this.release(releaseFlag, file, fileAccessType);
                        throw new CouldNotOpenFileInputStreamExtIOException("Could not open(read) the file " + file, e2, file);
                    }
                    catch (ExtIOException sub) {
                        Exceptions.addSuppressed(e2, sub);
                        throw new CouldNotOpenFileInputStreamExtIOException("Could not open(read) the file " + file, e2, file);
                    }
                    catch (RuntimeException sub) {
                        Exceptions.addSuppressed(e2, sub);
                    }
                    throw new CouldNotOpenFileInputStreamExtIOException("Could not open(read) the file " + file, e2, file);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.release(releaseFlag, file, fileAccessType);
                    throw throwable;
                }
                catch (ExtIOException e3) {
                    this.getLogger().log(e3);
                    throw throwable;
                }
                catch (RuntimeException e4) {
                    this.getLogger().log(e4);
                }
                throw throwable;
            }
        }
        try {
            this.release(releaseFlag, file, fileAccessType);
            return fileInputStream;
        }
        catch (ExtIOException e) {
            this.getLogger().log(e);
            return fileInputStream;
        }
        catch (RuntimeException e) {
            this.getLogger().log(e);
        }
        return fileInputStream;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileOutputStream openFileOutputStream(final File file, boolean append) throws ExtIOException {
        FileOutputStream fileOutputStream;
        AtomicBoolean releaseFlag = new AtomicBoolean(true);
        final FileAccessType fileAccessType = FileAccessType.WRITE;
        this.request(file, fileAccessType);
        try {
            this.mkdirs(file.getParentFile());
            final AtomicBoolean finalReleaseFlag = releaseFlag;
            FileOutputStream fos = new FileOutputStream(file, append){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    catch (Throwable throwable) {
                        DefaultFileAccessHandler.this.release(finalReleaseFlag, file, new FileAccessType[]{fileAccessType});
                        throw throwable;
                    }
                    DefaultFileAccessHandler.this.release(finalReleaseFlag, file, new FileAccessType[]{fileAccessType});
                }
            };
            releaseFlag = null;
            fileOutputStream = fos;
        }
        catch (FileNotFoundException e) {
            try {
                try {
                    this.release(releaseFlag, file, fileAccessType);
                    throw new FileNotFoundExtIOException("Could not open(read) the file " + file, e, file);
                }
                catch (ExtIOException sub) {
                    Exceptions.addSuppressed(e, sub);
                    throw new FileNotFoundExtIOException("Could not open(read) the file " + file, e, file);
                }
                catch (RuntimeException sub) {
                    Exceptions.addSuppressed(e, sub);
                }
                throw new FileNotFoundExtIOException("Could not open(read) the file " + file, e, file);
                catch (RuntimeException e2) {
                    try {
                        this.release(releaseFlag, file, fileAccessType);
                        throw new CouldNotOpenFileOutputStreamExtIOException(null, e2, file);
                    }
                    catch (ExtIOException sub) {
                        Exceptions.addSuppressed(e2, sub);
                        throw new CouldNotOpenFileOutputStreamExtIOException(null, e2, file);
                    }
                    catch (RuntimeException sub) {
                        Exceptions.addSuppressed(e2, sub);
                    }
                    throw new CouldNotOpenFileOutputStreamExtIOException(null, e2, file);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.release(releaseFlag, file, fileAccessType);
                    throw throwable;
                }
                catch (ExtIOException e3) {
                    this.getLogger().log(e3);
                    throw throwable;
                }
                catch (RuntimeException e4) {
                    this.getLogger().log(e4);
                }
                throw throwable;
            }
        }
        try {
            this.release(releaseFlag, file, fileAccessType);
            return fileOutputStream;
        }
        catch (ExtIOException e) {
            this.getLogger().log(e);
            return fileOutputStream;
        }
        catch (RuntimeException e) {
            this.getLogger().log(e);
        }
        return fileOutputStream;
    }

    protected LogInterface getLogger() {
        UpdateClient uc = this.getUpdateClient();
        if (uc == null) {
            return new NullLogger();
        }
        return uc.getLogger();
    }

    private final void release(AtomicBoolean hold, File file, FileAccessType ... type) throws ExtIOException {
        if (hold != null && hold.compareAndSet(true, false) && file != null && type != null) {
            this.release(file, type);
        }
    }

    @Override
    public void createHardlink(File src, File dest) throws ExtIOException, InterruptedException {
        throw new CouldNotCreateHardlinkExtIOException(null, null, src, dest);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String readFileToString(File revisionFile) throws ExtIOException, InterruptedException {
        String string;
        this.request(revisionFile, FileAccessType.READ);
        try {
            string = IO.readFileToTrimmedString(revisionFile);
        }
        catch (ClosedByInterruptException e) {
            try {
                throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                catch (FileNotFoundException e2) {
                    throw new FileNotFoundExtIOException(null, e2, revisionFile);
                }
                catch (IOException e3) {
                    throw new CouldNotReadFileExtIOException(null, e3, revisionFile);
                }
                catch (RuntimeException e4) {
                    throw new CouldNotReadFileExtIOException(null, e4, revisionFile);
                }
            }
            catch (Throwable throwable) {
                this.release(revisionFile, FileAccessType.READ);
                throw throwable;
            }
        }
        this.release(revisionFile, FileAccessType.READ);
        return string;
    }

    @Override
    public String secureReadFileToString(final File revisionFile) throws ExtIOException {
        String string;
        this.request(revisionFile, FileAccessType.READ);
        try {
            string = (String)new NonInterruptibleRunnable<String, ExtIOException>(){

                @Override
                public String run() throws ExtIOException, InterruptedException {
                    try {
                        return IO.readFileToTrimmedString(revisionFile);
                    }
                    catch (ClosedByInterruptException e) {
                        throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
                    }
                    catch (FileNotFoundException e) {
                        throw new FileNotFoundExtIOException(null, e, revisionFile);
                    }
                    catch (IOException e) {
                        throw new CouldNotReadFileExtIOException(null, e, revisionFile);
                    }
                    catch (RuntimeException e) {
                        throw new CouldNotReadFileExtIOException(null, e, revisionFile);
                    }
                }
            }.startAndWait();
        }
        catch (Throwable throwable) {
            this.release(revisionFile, FileAccessType.READ);
            throw throwable;
        }
        this.release(revisionFile, FileAccessType.READ);
        return string;
    }

    @Override
    public void copyFolderRecursive(final File src, final File dest, final boolean overwriteFiles, final FileFilter filter, final IO.SYNC sync) throws ExtIOException, InterruptedException {
        try {
            Files.walkThroughStructure(new Files.AbstractHandler<IOException>(){

                @Override
                public void onFile(File f) throws IOException {
                    try {
                        if (filter == null || filter.accept(f)) {
                            String path = Files.getRelativePath(src, f);
                            if (path == null) {
                                throw new IOException("No rel Path " + src + "-" + f);
                            }
                            if (f.isDirectory()) {
                                DefaultFileAccessHandler.this.mkdirs(new File(dest, path));
                            } else {
                                File dst = new File(dest, path);
                                DefaultFileAccessHandler.this.mkdirs(dst.getParentFile());
                                DefaultFileAccessHandler.this.copyFile(f, dst, overwriteFiles, sync);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        throw DefaultFileAccessHandler.wrapInterruptedException(e);
                    }
                }
            }, src);
        }
        catch (ClosedByInterruptException e) {
            throw DefaultFileAccessHandler.wrapClosedByInterruptException(e);
        }
        catch (IOException e) {
            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
        }
        catch (RuntimeException e) {
            throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
        }
    }

    public static ClosedByInterruptException wrapInterruptedException(InterruptedException e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Thread.currentThread().interrupt();
        return Exceptions.addSuppressed(new ClosedByInterruptException(), e);
    }

    public static InterruptedException wrapClosedByInterruptException(ClosedByInterruptException e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Thread.interrupted();
        return Exceptions.addSuppressed(new InterruptedException(e.getMessage()), e);
    }

    public DefaultFileAccessHandler(UpdateClient updateClient) {
        this(updateClient, null);
    }

    public DefaultFileAccessHandler(UpdateClient updateClient, AccessCallback callback) {
        this.updateClient = updateClient;
        this.accessCallback = callback;
    }

    @Override
    public boolean mkdirs(File file) throws ExtIOException {
        boolean bl;
        if (file.isDirectory()) {
            return false;
        }
        this.request(file, FileAccessType.WRITE);
        try {
            this.mkDirsInternal(file);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.release(file, FileAccessType.WRITE);
                throw throwable;
            }
            catch (RuntimeException e) {
                throw ExtIOException.getInstance(e, ExtIOException.IOExceptionType.LOCAL);
            }
        }
        this.release(file, FileAccessType.WRITE);
        return bl;
    }

    protected void mkDirsInternal(File file) throws ExtIOException {
        if (!file.mkdirs() && !file.isDirectory()) {
            if (file.isFile()) {
                throw new CouldNotCreateDirectoryExtIOException(UpdTrans.I().getErrorCannotCreateFoldersFileExists(), null, file);
            }
            throw new CouldNotCreateDirectoryExtIOException(UpdTrans.I().getErrorCannotCreateFolders(), null, file);
        }
    }

    @Override
    public long getUsableSpace(File file) throws ExtIOException {
        return Files.getUsableSpace(file);
    }

    @Override
    public File guessRoot(File file) throws ExtIOException {
        return Files.guessRoot(file);
    }
}

