/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.FileAccessHandler;
import org.appwork.updatesys.client.FileListWalker;
import org.appwork.updatesys.client.LinecountWriter;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.NonInterruptibleRunnable;
import org.appwork.utils.NonInterruptibleRunnableException;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.CountingInputStream;
import org.appwork.utils.os.CrossSystem;

public class FileList {
    private final File file;
    private final LogInterface logger;
    private HashMap<String, Boolean> set;
    private LinecountWriter output;
    private File tmpfile;
    private File backup;
    private boolean closed = false;
    private boolean opened = false;
    private final UpdateClient client;
    private final FileAccessHandler fileSystem;
    private static final int COMPARE_SETSIZE_LIMIT = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSHA256(File arg) throws NoSuchAlgorithmException, IOException {
        if (arg == null) {
            throw new NullPointerException();
        }
        if (!arg.exists()) {
            throw new FileNotFoundException(arg.getAbsolutePath());
        }
        if (arg.isDirectory()) {
            throw new FileNotFoundException(arg + " is a Directory");
        }
        FileInputStream fis = null;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-256");
            byte[] b = new byte[Short.MAX_VALUE];
            fis = new FileInputStream(arg);
            int n = 0;
            while ((n = fis.read(b)) >= 0) {
                if (n <= 0) continue;
                md.update(b, 0, n);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable b) {}
        }
        byte[] digest = md.digest();
        return HexFormatter.byteArrayToHex(digest);
    }

    public FileList(UpdateClient client, File path, LogInterface logInterface) throws IOException {
        if (path != null) {
            path = new File(path.getAbsolutePath().replace("/cfg/versioninfo/JD", "/update/versioninfo/JD").replace("\\cfg\\versioninfo\\JD", "\\update\\versioninfo\\JD"));
        }
        this.file = path;
        this.logger = logInterface;
        this.logger.info("FileList at " + this.file.getAbsolutePath() + " Size: " + this.file.length());
        this.output = null;
        this.client = client;
        this.fileSystem = client.getFileSystem();
    }

    public void addFile(AbsoluteFile f) throws IOException, NoSuchAlgorithmException {
        if (this.closed) {
            throw new IOException("File has already been closed");
        }
        if (!f.exists()) {
            throw new IOException("File " + f + " does not exist!");
        }
        this.logger.info("add File" + f);
        String rel = f.getRelative();
        if (rel == null) {
            this.logger.info(" warning. cannot convertToRelPath " + f);
        } else {
            this.init();
            this.logger.info("add relative" + rel);
            if (this.set.get(rel) == Boolean.TRUE) {
                this.logger.info(" warning. List already contains " + rel);
                return;
            }
            if (this.output == null) {
                this.logger.info(" Create new Outputstream: " + this.tmpfile);
                this.output = (LinecountWriter)new NonInterruptibleRunnable<LinecountWriter, IOException>(){

                    @Override
                    public LinecountWriter run() throws IOException, InterruptedException {
                        FileList.this.fileSystem.mkdirs(FileList.this.tmpfile.getParentFile());
                        return new LinecountWriter(new OutputStreamWriter((OutputStream)FileList.this.fileSystem.openFileOutputStream(FileList.this.tmpfile, false), "UTF-8"));
                    }
                }.startAndWait();
            }
            if (f.isDirectory()) {
                this.output.write("D");
                this.output.write("-");
                this.output.write(rel);
                this.output.newLine();
                this.output.incLines();
                this.set.put(rel, true);
            } else {
                this.output.write("F");
                this.output.write("-");
                this.output.write(this.getHash(f));
                this.output.write("-");
                this.output.write(rel);
                this.output.write("-" + f.lastModified());
                this.output.newLine();
                this.output.incLines();
                this.set.put(rel, true);
            }
            if (this.set.size() > 10000) {
                this.logger.info("Hashset Size limit reached 10000");
                this.flush();
            }
        }
    }

    public void close() throws FileNotFoundException, IOException {
        if (!this.opened) {
            return;
        }
        this.closed = true;
        this.flush();
        new NonInterruptibleRunnableException<ExtIOException>(){

            @Override
            protected void execute() throws ExtIOException, InterruptedException {
                FileList.this.fileSystem.deleteFileIfExists(FileList.this.backup);
            }
        }.startAndWait();
        this.opened = false;
    }

    public void flush() throws FileNotFoundException, IOException {
        new NonInterruptibleRunnableException<IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            protected void execute() throws IOException, InterruptedException {
                try {
                    3 var1_1 = this;
                    // MONITORENTER : var1_1
                    if (!FileList.this.opened) {
                        // MONITOREXIT : var1_1
                        return;
                    }
                    // MONITOREXIT : var1_1
                    if (FileList.this.output == null) {
                        FileList.this.logger.info(" Create new Outputstream: " + FileList.this.tmpfile);
                        FileList.this.output = new LinecountWriter(new OutputStreamWriter((OutputStream)FileList.this.fileSystem.openFileOutputStream(FileList.this.tmpfile, false), "UTF-8"));
                    }
                    FileList.this.logger.info("Merged. diff size: " + FileList.this.output.getLines());
                    FileList.this.mergeLists(FileList.this.file, FileList.this.output, FileList.this.set);
                    FileList.this.output.close();
                    FileList.this.fileSystem.moveFile(FileList.this.tmpfile, FileList.this.file, true);
                    FileList.this.logger.info("Merged. new listsize: " + FileList.this.output.getLines());
                    FileList.this.output = null;
                    FileList.this.set.clear();
                    return;
                }
                finally {
                    try {
                        FileList.this.output.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }.startAndWait();
    }

    private String getHash(File f) throws NoSuchAlgorithmException, IOException {
        if (!this.isHashSupportEnabled()) {
            return "0000000000000000000000000000000000000000000000000000000000000000";
        }
        return FileList.getSHA256(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        if (this.opened) {
            return;
        }
        FileList fileList = this;
        synchronized (fileList) {
            if (this.opened) {
                return;
            }
            this.opened = true;
            this.backup = new File(this.file.getAbsolutePath() + ".backup");
            if (this.backup.exists()) {
                new NonInterruptibleRunnableException<ExtIOException>(){

                    @Override
                    protected void execute() throws ExtIOException, InterruptedException {
                        FileList.this.fileSystem.moveFile(FileList.this.backup, FileList.this.file, true);
                    }
                }.startAndWait();
            }
            if (this.file.exists()) {
                new NonInterruptibleRunnableException<ExtIOException>(){

                    @Override
                    protected void execute() throws ExtIOException, InterruptedException {
                        FileList.this.logger.info(" copy " + FileList.this.file + " to " + FileList.this.backup);
                        FileList.this.fileSystem.copyFile(FileList.this.file, FileList.this.backup, false, null);
                    }
                }.startAndWait();
            } else {
                this.logger.info(this.file + " does not exist");
            }
            this.set = new HashMap();
            this.tmpfile = new File(this.file.getAbsolutePath() + ".tmp");
        }
    }

    public boolean isHashSupportEnabled() {
        return !CrossSystem.isWindows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeLists(File list, LinecountWriter output, HashMap<String, Boolean> set2) throws FileNotFoundException, IOException, InterruptedException {
        if (!list.exists()) {
            return;
        }
        FileInputStream fis = null;
        int lastIndex = -1;
        try {
            String line;
            fis = this.fileSystem.openFileInputStream(list);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(fis), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                String path;
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if (StringUtils.isEmpty(line)) continue;
                if (line.charAt(0) == 'D') {
                    if (line.length() < 3) {
                        this.logger.severe("Bad Line in FileList: " + line);
                        continue;
                    }
                    path = line.substring(2);
                } else {
                    lastIndex = line.lastIndexOf("-");
                    if (lastIndex < 68) {
                        this.logger.severe("Bad Line in FileList: " + line);
                        continue;
                    }
                    path = line.substring(67, lastIndex);
                }
                if (set2.containsKey(path)) continue;
                output.write(line);
                output.newLine();
                output.incLines();
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public void removeFile(AbsoluteFile file) throws IOException {
        if (this.closed) {
            throw new IOException("File has already been closed");
        }
        String relative = file.getRelative();
        if (relative == null) {
            this.logger.info(" warning. cannot convertToRelPath " + file);
        } else {
            this.removeFile(relative);
        }
    }

    public void removeFile(String relative) throws IOException {
        if (this.closed) {
            throw new IOException("File has already been closed");
        }
        this.init();
        this.logger.info("Remove " + relative);
        Boolean value = this.set.get(relative);
        if (value == Boolean.FALSE) {
            this.logger.info(" warning. List " + relative + " is already on remove list");
            return;
        }
        if (value == null) {
            this.set.put(relative, false);
        } else {
            this.flush();
            this.set.put(relative, false);
        }
    }

    public void revert() throws FileNotFoundException, IOException {
        this.flush();
        this.init();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk(FileListWalker fileListWalker) throws FileNotFoundException, IOException, InterruptedException {
        this.flush();
        FileInputStream fis = null;
        try {
            String line;
            fis = this.fileSystem.openFileInputStream(this.file);
            CountingInputStream cis = new CountingInputStream(fis);
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(cis), "UTF-8"));
            while ((line = f.readLine()) != null) {
                if (StringUtils.isEmpty(line)) continue;
                char type = line.charAt(0);
                if (type == 'F') {
                    String hash = line.substring(2, 66);
                    String path = line.substring(67, line.lastIndexOf("-"));
                    long timestamp = Long.parseLong(line.substring(line.lastIndexOf("-") + 1));
                    fileListWalker.fileStep(hash, path, timestamp, (double)cis.transferedBytes() / (double)this.file.length());
                    continue;
                }
                if (type != 'D') continue;
                fileListWalker.folderStep(line.substring(2));
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

