/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.extensions;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.appwork.loggingv3.LogV3;
import org.appwork.updatesys.client.AbsoluteFile;
import org.appwork.updatesys.client.FailedActionException;
import org.appwork.updatesys.client.InstallException;
import org.appwork.updatesys.client.UpdateClient;
import org.appwork.updatesys.client.extensions.CompiledServerOptions;
import org.appwork.updatesys.client.extensions.ExtensionManagerInterface;
import org.appwork.updatesys.client.install.AbstractBackupFileWriter;
import org.appwork.updatesys.client.install.BackupFileWriterImpl;
import org.appwork.updatesys.client.serveroptions.ServerOptionsManager;
import org.appwork.updatesys.transport.exchange.BooleanTristate;
import org.appwork.updatesys.transport.exchange.ServerOptions;
import org.appwork.utils.Application;
import org.appwork.utils.ExtIOException;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;

public abstract class AbstractExtensionManager
implements ExtensionManagerInterface {
    protected final LogInterface logger;
    protected final UpdateClient updateClient;

    public AbstractExtensionManager(UpdateClient updateClient) {
        this(updateClient, null);
    }

    public AbstractExtensionManager(UpdateClient updateClient, LogInterface logger) {
        this.updateClient = updateClient;
        this.logger = logger;
    }

    private final String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.ENGLISH);
    }

    public UpdateClient getUpdateClient() {
        return this.updateClient;
    }

    protected void uninstallFileOrFolder(CompiledServerOptions cso, AbstractBackupFileWriter backupFileWriter, String path, AbsoluteFile file) throws IOException, InstallException, ExtIOException, InterruptedException, FailedActionException {
        if (!this.getUpdateClient().isAllowedToDelete(file.getRelative(), file)) {
            this.getLogger().info("Skip Deletion:" + file);
        } else {
            if (file.isDirectory()) {
                for (AbsoluteFile f : file.listFiles()) {
                    if (f.getName().endsWith(".updRemoved")) continue;
                    this.installServerOptionUpdate(cso, backupFileWriter, f.getRelative());
                }
            }
            this.getUpdateClient().removeFile(backupFileWriter, null, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installServerOptionUpdate(CompiledServerOptions cso, AbstractBackupFileWriter backup, String path) throws IOException, InstallException, InterruptedException, FailedActionException {
        this.getUpdateClient().onPreServerOptionInstall(path, cso);
        try {
            ServerOptions so = cso.getServerOption(path);
            if (so == null) {
                return;
            }
            AbsoluteFile file = this.getUpdateClient().convertRelPath(path);
            if (!this.doesAffectedFileExist(file, so)) {
                return;
            }
            if (!this.keepFileAccordingToServerOption(so)) {
                this.uninstallFileOrFolder(cso, backup, path, file);
            }
        }
        finally {
            this.getUpdateClient().onPostServerOptionInstall(path, cso);
        }
    }

    protected boolean doesAffectedFileExist(AbsoluteFile file, ServerOptions so) {
        return CrossSystem.caseSensitiveFileExists(file);
    }

    public boolean keepFileAccordingToServerOption(ServerOptions so) {
        boolean is64BitJvm = Application.is64BitJvm();
        boolean is64BitOS = CrossSystem.is64BitOperatingSystem();
        String arch = so.getArch();
        if (so.getJvm32Bit() == BooleanTristate.FALSE && !is64BitJvm) {
            return false;
        }
        if (so.getJvm64Bit() == BooleanTristate.FALSE && is64BitJvm) {
            return false;
        }
        if (so.getLinux() == BooleanTristate.FALSE && CrossSystem.isLinux()) {
            return false;
        }
        if (so.getWindows() == BooleanTristate.FALSE && CrossSystem.isWindows()) {
            return false;
        }
        if (so.getMac() == BooleanTristate.FALSE && CrossSystem.isMac()) {
            return false;
        }
        if (so.getBsd() == BooleanTristate.FALSE && CrossSystem.isBSD()) {
            return false;
        }
        if (so.getOs32Bit() == BooleanTristate.FALSE && !is64BitOS) {
            return false;
        }
        if (so.getOs64Bit() == BooleanTristate.FALSE && is64BitOS) {
            return false;
        }
        if (arch != null && !arch.equalsIgnoreCase(CrossSystem.getARCHFamily().name())) {
            return false;
        }
        if (so.getParentIDList() != null) {
            for (String s : so.getParentIDList()) {
                if (!this.keepFile(s = this.toLowerCase(s))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected abstract boolean keepFile(String var1);

    @Override
    public void runInstallation(ServerOptionsManager serverOptionsManager, File backupFile) throws InstallException {
        CompiledServerOptions cso = serverOptionsManager.compile();
        this.getLogger().info(cso.toString());
        this.getLogger().info("Modified/Added ServerOptions: \r\n" + serverOptionsManager.getNewEntries());
        this.getLogger().info("Removed ServerOptions: \r\n" + serverOptionsManager.getRemovedEntries());
        AbstractBackupFileWriter backup = null;
        try {
            backup = new BackupFileWriterImpl(this.getUpdateClient(), backupFile, true);
            for (Map.Entry<String, String> e : serverOptionsManager.getNewEntries().entrySet()) {
                this.installServerOptionUpdate(cso, backup, e.getKey());
            }
            for (Map.Entry<String, String> e : serverOptionsManager.getRemovedEntries().entrySet()) {
                this.installServerOptionUpdate(cso, backup, e.getKey());
            }
        }
        catch (Exception e) {
            throw InstallException.wrap(this.getUpdateClient(), e);
        }
        finally {
            try {
                backup.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public LogInterface getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        if (this.updateClient != null) {
            return this.updateClient.getLogger();
        }
        return LogV3.I().getDefaultLogger();
    }
}

