/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.extensions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.appwork.storage.JSonStorage;
import org.appwork.updatesys.client.extensions.ServerOptionNode;
import org.appwork.updatesys.client.serveroptions.ServerOptionsManager;
import org.appwork.updatesys.transport.exchange.ServerOptions;

public class CompiledServerOptions
extends ServerOptionNode {
    protected final ServerOptionsManager manager;

    public CompiledServerOptions(ServerOptionsManager serverOptionsManager) {
        super("root");
        this.manager = serverOptionsManager;
        ArrayList<String> removeList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : serverOptionsManager.getAll().entrySet()) {
            File file = new File(entry.getKey());
            try {
                ServerOptions so = JSonStorage.restoreFromString(entry.getValue(), ServerOptions.TYPE);
                this.map(file, so);
            }
            catch (RuntimeException e1) {
                this.getManager().getUpdateClient().getLogger().exception("Bad Json Format: " + entry, e1);
                removeList.add(entry.getKey());
            }
        }
        if (removeList.size() > 0) {
            for (String removeEntry : removeList) {
                this.getManager().removeServerOption(removeEntry);
            }
            try {
                this.getManager().save();
            }
            catch (IOException e) {
                this.getManager().getUpdateClient().getLogger().log(e);
            }
        }
    }

    public ServerOptionsManager getManager() {
        return this.manager;
    }

    private void map(File f, ServerOptions so) {
        List<String> path = this.getPath(f);
        ServerOptionNode node = this;
        for (String s : path) {
            node = node.getOrCreate(s);
            so = this.merge(so, node.getServerOptions());
        }
        node.setServerOptions(so);
    }

    private List<String> getPath(File f) {
        LinkedList<String> ret = new LinkedList<String>();
        do {
            ret.add(0, f.getName());
        } while ((f = f.getParentFile()) != null);
        return ret;
    }

    public ServerOptions getServerOption(String string) {
        String s;
        List<String> path = this.getPath(new File(string));
        ServerOptionNode node = this;
        ServerOptionNode newNode = null;
        Iterator<String> iterator = path.iterator();
        while (iterator.hasNext() && (newNode = (ServerOptionNode)node.get(s = iterator.next())) != null) {
            node = newNode;
        }
        return node.getServerOptions();
    }
}

